************************ FUNCTION INDEXREL *************************
FUNCTION INDEXREL(REL_VAR, DB, RETURN_VAR)
**********
*
* FUNCTIONS: Simulates using a SET RELATION and alias for indexing, e.g.
*               SET RELATION TO OECLNTNBR INTO CUSTDB
*               INDEX ON CUSTDB->CSTSLSMN
*            This is required because using an alias in an index
*            clause does not work at this time.
* PARAMETERS:
*    rel_var - the value of the relational variable, e.g. oeclntnbr
*    db - the database that is the object of the relation, e.g. CUSTDB
*    return_var - the name of the variable whose value is to be
*                 returned, e.g. CSTSLSMN
* RETURN VALUE:
*    The value of the variable indicated by return_var
*
***********

LOCAL last_area
last_area := SELECT()       && save area currently selected
SELECT (db)                 && select related database
SEEK rel_var                && seek the value passed
ret_value := &return_var    && get the value of the variable specified
SELECT (last_area)          && reselect original database
RETURN ret_value            && return specified variable

