* This is a UDF to figure out elapsed time over days.  The parameters are
* flexible and allow for the specification of open or peak hours.
* This was created by John Wright [WRIGHTware]  72377,1770

*!*********************************************************************
*!
*!       Function: HOW_LONG()
*!
*!*********************************************************************
FUNCTION How_long
* Figure the time between two time strings.
* Returns a character string containing the hours and minutes.
*
* Parameters passed :   jt1 - first time string    jt2 - second time string
*                       jd1 - first date           jd2 - second date
*                       jh1 - first time of day    jh2 - last time of day
*                       jwe - ignore weekend (Saturday & Sunday) .T. or .F.
*
* Default values are the current date and 00:00 - 24:00 for times in day.
* If you want to specify only certain hours in a day then send the last
* three parameters.  (Ex. Bank hours are 08:00 - 16:00. ignore weekends)
* If you specify hours of operation you must specify how to handle weekends.
* Example : HOW_LONG(time1,time2,date1,date2,"08:00","16:00",.T.)
*
DO CASE
CASE Pcount() = 7
  PARAMETERS jt1,jt2,jd1,jd2,jh1,jh2,jwe
  jh_first=(VAL(SUBSTR(jh1,1,2))*3600)+(VAL(SUBSTR(jh1,4,2))*60)
  jh_last=(VAL(SUBSTR(jh2,1,2))*3600)+(VAL(SUBSTR(jh2,4,2))*60)
CASE Pcount() = 4
  PARAMETERS jt1,jt2,jd1,jd2
  jh_first=0
  jh_last=86400
  jwe=.F.
OTHERWISE
  PARAMETERS jt1,jt2
  STORE DATE() TO jd1,jd2
  jh_first=0
  jh_last=86400
  jwe=.F.
ENDCASE

th1=VAL(SUBSTR(jt1,1,2))
tm1=VAL(SUBSTR(jt1,4,2))
tt1=(th1*3600)+(tm1*60)

th2=VAL(SUBSTR(jt2,1,2))
tm2=VAL(SUBSTR(jt2,4,2))
tt2=(th2*3600)+(tm2*60)

DO CASE
CASE jd1 = jd2 .AND. jt1 > jt2
  RETURN " ERROR"
CASE jd1 = jd2
  ttt=tt2-tt1
CASE jd1 > jd2
  RETURN " ERROR"
CASE jd1 < jd2
  ttt=(jh_last-tt1)+(tt2-jh_first)
  IF jd2-jd1 > 1
    IF jwe                && ignore weekend days (Saturday & Sunday)
      STORE 0 TO jw_days
      STORE jd1+1 TO jw_date
      FOR X = 1 TO jd2-jd1-1
        IF CDOW(jw_date) <> "S"
          STORE jw_days+1 TO jw_days
        ENDIF
        STORE jw_date+1 TO jw_date
      NEXT
    ELSE
      STORE jd2-jd1-1 TO jw_days
    ENDIF
    * this will add whole days worth of time
    ttt=ttt+(jh_last-jh_first)*jw_days
  ENDIF
ENDCASE

* how many hours have gone by ...
tth=ttt/3600
tth=INT(tth)
IF tth > 0
  ttt=ttt-(tth*3600)
ENDIF
* how many minutes ...
ttm=INT((ttt/60))

RETURN STR(tth,3)+":"+IF(ttm<10,"0"+STR(ttm,1),STR(ttm,2))

