/***
*  getstuff.prg
*  Basic get routines
*
*  Copyright (c) 1990 Nantucket Corp.  All rights reserved.
*  Craig Ogg
*
*/


/***
*  DisplayGets( <aGets> ) --> <aGets>
*  Display the passed get array
*
*/
FUNCTION DisplayGets( aGets )
   LOCAL nIndex
 
   FOR nIndex := 1 to LEN( aGets )
      aGets[nIndex]:display()
   NEXT

   RETURN (aGets)

/***
*  MoveGets( <aGets>, <nRows>, <nCols> ) --> <aGets>
*  Move get array to new location and redisplay
*
*/
FUNCTION MoveGets( aGets, nRows, nCols )
   LOCAL i

   FOR i := 1 to LEN( aGets )
      aGets[i]:row += nRows
      aGets[i]:col += nCols
      aGets[i]:display()
   NEXT

   RETURN (aGets)


/***
*  ColorGets( <aGets>, <cColor> ) --> <aGets>
*  Change color of all gets in get array
*
*/
FUNCTION ColorGets( aGets, cColor )
   LOCAL i

   FOR i := 1 to LEN( aGets )
      aGets[i]:colorSpec := cColor
      aGets[i]:display() 
   NEXT

   RETURN aGets





