Getred.ASM

; Program ...: Getred.ASM
; Author ....: Keith Mund
; Date ......: October 1, 1987
; Notes .....: There are three optional lines of code which can be "uncommented"
;              to force Getred.BIN to recognize only print devices.  These lines
;              have comments beginning with "***".  
;----------------------------------------------------------------------------
; DOS equates.
;
DOSINT  EQU     21H
GETRED  EQU     5F02H            ; Get network redirection function.
;ISPRNT EQU     3                ; *** Optional to allow printer devices only.
;
;----------------------------------------------------------------------------
; ASCII equates.
;
NULL    EQU     0
TO_UP   EQU     0DFh             ; Uppercase conversion mask.
;
;----------------------------------------------------------------------------
; Segment and offset definition.
;
CODE    SEGMENT
        ASSUME  CS:CODE,DS:CODE,ES:CODE
;
MAIN    PROC    FAR
        JMP     START
;
;----------------------------------------------------------------------------
; Constants and variables.
;
        DB      13,'Copyright (C) 1987 by Ashton-Tate.'
        DB      13,10,'Written by Keith Mund.',1AH
BX_SAVE DW      ?
DS_SAVE DW      ?
INDEX   DW      ?                ; Index to network redirection list.
LOGDEV  DB      17 DUP (NULL)    ; The logical device from the list.
NETDEV  DB      129 DUP (NULL)   ; The network physical device from the list.
;
;----------------------------------------------------------------------------
; The code starts here.
; 
START:  MOV     AX,DS            ; The data segment is non-zero when a 
        OR      AX,AX            ;     variable is passed from dBASE.
        JNZ     START2           ; OK if not zero,
        JMP     DONE             ; Abort if zero.
;
; Initialize and save.
START2: MOV     CS:[INDEX],0     ; Network device index.
        MOV     CS:[BX_SAVE],BX  ; Address of dBASE string.
        MOV     CS:[DS_SAVE],DS  ; dBASE data segment.
;
;----------------------------------------------------------------------------
; This loop checks each redirection in the table for a match.
; There are two exits possible, one for a match, and one for aborting.
;
MORE:   PUSH    CS
        POP     DS
        MOV     CS:[NETDEV],NULL ; No redirection device.
        MOV     CS:[LOGDEV],NULL ; No logical device.
        MOV     AX,GETRED        ; Get redirection list function.
        MOV     BX,CS:[INDEX]    ; Redirection list element.
        MOV     SI,OFFSET LOGDEV
        MOV     DI,OFFSET NETDEV
        INT     DOSINT
        JC      DONE             ; Return on any errors.
;       CMP     BL,ISPRNT        ; *** Optional test that allows printer 
;       JNZ     NEXT             ; *** devices only.
        TEST    BH,1             ; Valid?
        JNZ     NEXT             ; Skip bad device error.
;
        MOV     SI,CS:[DS_SAVE]
        MOV     DS,SI
        MOV     SI,CS:[BX_SAVE]  ; dBASE device string.
        MOV     DI,OFFSET LOGDEV ; Network device string returned.
;
; A string compare like CMPSB except uppercase conversion and 
; various terminators allowed.
;
SCMP:   MOV     AL,[SI]          ; Compare with a space, colon, or NULL.
        OR      AL,AL            ; Is a match if null.
        JZ      MATCH
        CMP     AL,' '           ; Is a match if space.
        JZ      MATCH
        CMP     AL,':'           ; Is a match if colon.
        JZ      MATCH
        CMP     AL,'A'           ; Letter or number?
        JL      NEXT1            ; Skip numbers.
        AND     AL,TO_UP         ; Make letters uppercase.
NEXT1:  MOV     AH,CS:[DI]
        INC     SI
        INC     DI
        CMP     AL,AH
        JZ      SCMP             ; Still a match, falls through on no match.
;
NEXT:   INC     CS:[INDEX]       ; Try the next element in list.
        JMP     MORE
;
;----------------------------------------------------------------------------
; Perform a move to the string address passed from dBASE. Do not allow
; writing past the null terminator.
;
MATCH:  MOV     DI,CS:[DS_SAVE]
        MOV     ES,DI
        MOV     DI,CS:[BX_SAVE]  ; dBASE string location.
        PUSH    CS
        POP     DS
        MOV     SI,OFFSET NETDEV ; Network device string.
MATCH1: MOV     AL,[SI]
        OR      AL,AL            ; Out of characters?
        JZ      FILL
        MOV     AH,ES:[DI]       ; Out of space in dBASE destination?
        OR      AH,AH
        JZ      FILL
        STOSB
        INC     SI
        JMP     MATCH1
;
;----------------------------------------------------------------------------
; Space fill the rest of the destination.
;
FILL:   MOV     AL,32
FILL1:  MOV     AH,ES:[DI]       ; Out of space in dBASE destination?
        OR      AH,AH
        JZ      DONE
        STOSB
        JMP     FILL1
;
;----------------------------------------------------------------------------
; Common exit point.
;
DONE:   MOV     BX,CS:[DS_SAVE]  ; Restore the data segment.
        MOV     DS,BX
        RET
;
;----------------------------------------------------------------------------
;
MAIN    ENDP
CODE    ENDS
        END     MAIN
                                                                                                                     