/*
   Written by: Jamal Assaf     July 21, 1994             Public Domain
   CIS ID    :  74541,1146


   Purpose   : Overcome Clipper's float point math comparsion headaches.
               Eliminate the undesired ROUND() effects when you only need
               the EXACT number up to SET DECIMALS TO setting.
               This is a great function to use when comparing numbers.

   Example:
             ?  EXACT( 12.9100001 ) == EXACT( 12.91 )   EXACT   returns .t.
             ?         12.9100001   ==        12.91     CLIPPER returns .f.

   Note      : Your comments count and will greatly appreciated !

*/

#INCLUDE "SET.CH"

FUNCTION EXACT(nNum)
  LOCAL cNo, nDecPos, cIntPart, cDecPart

  cNo := STR(nNum)
  IF ( nDecPos := AT(".", cNo) ) == 0
     RETURN nNum
  ENDIF
  cIntPart := SUBSTR(cNo, 1, nDecPos - 1)

  // SET(_SET_DECIMALS) is used to provide flexiblity when returning decimals
  cDecPart := SUBSTR(cNo, nDecPos + 1, SET(_SET_DECIMALS) )

RETURN VAL(cIntPart+"."+cDecPart)

