***
*	ERRORLOG
*
*	Clipper error system.  Debugging version with log support
*
*  Original code provided by Nantucket 
*  Original code for LogMemVar() was provided by Joe Booth and 
*  Steve Straley, Additionally the idea for logging errors came from
*  Steve's second book.
*
*  Enhancements (mainly anything that begins with Log) authored by Chuck Fox                              
*  
*  For those of you with any suggestions or (more likely) complaints
*  I may be reached at (703) 486-5263 Mon-Fri (and sometimes Sat and Sun)
*  Please note that this is on the dreaded EAST COAST and that my normal 
*  hours are 8:30 AM - 5:30 PM EST or EDT depending on the time of year
*  and the current bent of the school board system. (if you lived here
*  you'd understand!)  If you feel the burning need to contact me through
*  the postal system my current mailing address is:
*        Chuck Fox
*        1111 Jefferson Davis Highway          
*        Suite 504
*        Arlington, VA 22202
* 
*  My CompuServ mail box is 72331,3446
* 
*  And as a certain someone is fond of saying 
*  HAPPY CLIPPING
*
*****************************************************************
*
* USE THIS PROGRAM AT YOUR OWN RISK !!! 
* This program is released to Public Domain, so do what you will 
* with it. (i.e., no royalties or payment of any type is expected)
*
*****************************************************************
*
*  Many of the functions used in this program are contained in the 
*  Funcky.Lib provided by DLesko Associates.
*
*  Description: This is an attempt to provide a comprehensive
*               picture of the program's environment at any time.
*               When an error occurs the log error function is called
*               and at run-time a call may be made to LogError to perform
*               a run-time report of the environment. The Error.Log that is 
*               created will rapidly grow to enormous proportions if care is
*               not taken to remove it once in a while. (this is especially 
*               true if you tend to test under live conditions, where as 
*               everyone - including Murphy - knows that every thing will 
*               go wrong)
*               
*  Usage:  A run-time report may be made by assigning the procedure LogError
*          to a key or by calling the function LogErr(0).
*          LogErr expects a number corresponding to the type of error     
*          additionally the various XXX_Error programs have as parameters     
*          Model, _1, Name, Line, Info, etc.. and these are expected to     
*          exist if you call LogErr() with any number except 0
*               
*          LogErr() - Parameter Meaning     
*               0 = Run-Time Report
*               1 = Log Database Error
*               2 = Log Expression Error
*               3 = Log Miscellaneous Error
*               4 = Log Undefined Error
*               5 = Log Open Error
*               6 = Log Printer Error
*
*
PROCEDURE Errorsys
   ALTD(2)  
RETURN


***
*	Expr_Error(Name, Line, Info, Model, _1, _2, _3)
*

FUNCTION Expr_Error
   PARAM Name, Line, Info, Model, _1, _2, _3
   PRIVATE Result, Sample
   Logerr(2)
   IF M->Info = "zero divide"
      IF "%" $ M->Model
         RETU M->_1
      ELSE
         RETU 0
      ENDIF
   ENDIF

   ALTD(2)

   IF TYPE("M->Result") != "U"
      RETU M->Result
   END


   SET DEVICE TO SCREEN
   @ 24, 0

   IF Info = "type mismatch"
      M->Sample = M->Model
      M->Sample = STRTRAN(M->Sample, "_1", TYPE("M->_1"))
      M->Sample = STRTRAN(M->Sample, "_2", TYPE("M->_2"))
      M->Sample = STRTRAN(M->Sample, "_3", TYPE("M->_3"))

      @ 24, 0 SAY "Proc " + M->Name + " Line " + LTRIM(STR(M->Line)) + ", " +;
      M->Info + ": " + M->Sample

   ELSE
      @ 24, 0 SAY "Proc " + M->Name + " Line " + LTRIM(STR(M->Line)) + ", " +;
      M->Info

   END

   BREAK

RETURN .T.


***
*	Misc_Error(Name, Line, Info, Model)
*

FUNCTION Misc_Error
   PARAM Name, Line, Info, Model
   Logerr(3)
   ALTD(2)

   SET DEVICE TO SCREEN
   @ 24, 0
   @ 24, 0 SAY "Proc " + M->Name + " Line " + LTRIM(STR(M->Line)) + ", " +;
   M->Info + ": " + M->Model

   BREAK

RETURN .F.


***
*	Open_Error(Name, Line, Info, Model, _1)
*

FUNCTION Open_Error
   PARAM Name, Line, Info, Model, _1
   Logerr(5)

   ALTD(2)

   IF NETERR() .AND. Model == "USE"
      RETU(.F.)
   ENDIF

   SET DEVICE TO SCREEN
   @ 23, 0
   @ 23, 0 SAY "Proc " + M->Name + " Line " + LTRIM(STR(M->Line)) + ", "  +;
   M->Info + ": " + M->Model + " " + M->_1
   @ 24, 0 SAY "Press Esc to abort, any other key to retry..."

   IF (INKEY(0) == 27)
      @ 23,0
      @ 24,0
      RETU .F.
   ENDIF

   @ 23,0
   @ 24,0

RETURN .T.


***
*	Undef_Error(Name, Line, Info, Model, _1)
*

FUNCTION Undef_Error
   PARAM Name, Line, Info, Model, _1
   Logerr(4)
   ALTD(2)

   SET DEVICE TO SCREEN
   @ 23, 0
   @ 23, 0 SAY "Proc " + M->Name + " Line " + LTRIM(STR(M->Line)) + ", "  +;
   M->Info + ": " + " " + M->_1
   @ 24, 0 SAY "Press Esc to abort, any other key to retry..."

   IF (INKEY(0) == 27)
      @ 23,0
      @ 24,0
      BREAK
   END

   @ 23,0
   @ 24,0
RETURN .T.


***
*	Print_Error(Name, Line)
*

FUNCTION Print_Error
   PARAM Name, Line
   PRIVATE Key, File, Info
   Info = "Printer Error"
   Logerr(6)
   SET DEVICE TO SCREEN
   @ 23, 0
   @ 23, 0 SAY "Proc " + M->Name + " Line " + LTRIM(STR(M->Line)) +;
   ", printer not ready"
   @ 24, 0 SAY "Press <I>gnore, <R>etry, <B>REAK, F<ile>, <Q>uit..."

   DO WHILE .T.
      Key = UPPER(CHR(INKey(0)))

      IF (M->Key == "Q")
         QUIT

      ELSEIF (M->Key == "I")
         @ 23,0
         @ 24,0
         RETU .F.

      ELSEIF (M->Key == "R")
         @ 23,0
         @ 24,0
         RETU .T.

      ELSEIF (M->Key == "B")
         @ 23,0
         @ 24,0
         BREAK

      ELSEIF (M->Key == "F")
         @ 23,0
         @ 24,0
         ACCEPT "FileName - " TO File
         SET PRINTER TO (M->File)
         @ 23,0
         @ 24,0
         RETU .T.

      END
   END

RETURN .F.


***
*	Db_Error(Name, Line, Info)
*

FUNCTION Db_Error
   PARAM Name, Line, Info
   Logerr(1)
   ALTD(2)
   SET DEVICE TO SCREEN
   @ 24, 0
   @ 24, 0 SAY "Proc " + M->Name + " Line " + LTRIM(STR(M->Line)) +;
   ", " + M->Info

   BREAK

RETURN .F.


PROCEDURE LogError
   LogErr(0)
RETURN

FUNCTION LogErr
   PARAMETERS LogError
   IF PCOUNT() = 0
      Logerror = 0
   ENDIF
   ErrFile = "Error.Log"
   IF Handles() = 0
      ? "No file handles available for error log"
      RETU(.T.)
   ENDIF
   IF !File(ErrFile)
      Errhandle = FCREATE(ErrFile,0)
   ELSE
      Errhandle = FOPEN(ErrFile,1)
   ENDIF
   FSEEK(Errhandle, 0, 2)                       
   Title = IF(Logerror=0,"RUN TIME REPORT FOR ","ERROR LOG FOR ")
   FWriteLine(ErrHandle,"")
   FWriteLine(Errhandle,""+REPLICATE("",78)+"")
   FWriteLine(ErrHandle,""+STRCENTER(Title+PROGRAM()+" Logged on "+DTOW(DATE())+" at "+TIME(),78)+"")
   FWriteLine(Errhandle,""+REPLICATE("",78)+"")
   IF DOSERROR() > 0
      FWriteLine(Errhandle,DosErrMsg())
   ENDIF
   IF LogError > 0
      FWriteLine(ErrHandle,"ERROR CLASS")
      DO CASE             
         CASE Logerror = 1                          && Db_Error
            FWriteLine(Errhandle," Db_Error         : "+UPPER(Info))
            FWriteLine(Errhandle," MODULE           : "+UPPER(Name))
            FWriteLine(Errhandle," LINE NUMBER      : "+TRANSFORM(Line,"999,999"))
         CASE Logerror = 2                          && Expr_Error has additional parms MODEL, _1, _2, _3
            FWriteLine(Errhandle," Expr_Error       : "+UPPER(Info))
            FWriteLine(Errhandle," MODULE           : "+UPPER(Name))
            FWriteLine(Errhandle," LINE NUMBER      : "+TRANSFORM(Line,"999,999"))
            FWriteLine(Errhandle," MODEL            : "+MODEL)
            IF TYPE("_1") # "U"
               FWRITE(Errhandle," _1               : ")
               FWriteLine(Errhandle,_1)
               FWriteLine(Errhandle," TYPE(_1)         : "+TYPE("_1"))
            ENDIF
            IF TYPE("_2") # "U"
               FWRITE(Errhandle," _2               : ")
               FWriteLine(Errhandle,_2)
               FWriteLine(Errhandle," TYPE(_2)         : "+TYPE("_2"))
            ENDIF
            IF TYPE("_3") # "U"
               FWRITE(Errhandle," _3               : ")
               FWriteLine(Errhandle,_3)
               FWriteLine(Errhandle," TYPE(_3)         : "+TYPE("_3"))
            ENDIF
         CASE Logerror = 3                          && Misc_Error MODEL
            FWriteLine(Errhandle," Misc_Error       : "+UPPER(Info))
            FWriteLine(Errhandle," MODULE           : "+UPPER(Name))
            FWriteLine(Errhandle," LINE NUMBER      : "+TRANSFORM(Line,"999,999"))
            FWriteLine(Errhandle," MODEL            : "+MODEL)
         CASE Logerror = 4                          && Undef_Error MODEL, _1
            FWriteLine(Errhandle," Undef_Error      : "+UPPER(Info))
            FWriteLine(Errhandle," MODULE           : "+UPPER(Name))
            FWriteLine(Errhandle," LINE NUMBER      : "+TRANSFORM(Line,"999,999"))
            FWriteLine(Errhandle," MODEL            : "+MODEL)
            FWRITE(Errhandle," _1               : ")
            FWriteLine(Errhandle,_1)
            FWriteLine(Errhandle," TYPE(_1)         : "+TYPE("_1"))
         CASE Logerror = 5                          && Open_Error MODEL, _1
            FWriteLine(Errhandle," Open_Error       : "+UPPER(Info))
            FWriteLine(Errhandle," MODULE           : "+UPPER(Name))
            FWriteLine(Errhandle," LINE NUMBER      : "+TRANSFORM(Line,"999,999"))
            FWriteLine(Errhandle," MODEL            : "+MODEL)
            FWRITE(Errhandle," _1               : ")
            FWriteLine(Errhandle,_1)
            FWriteLine(Errhandle," TYPE(_1)         : "+TYPE("_1"))
         CASE Logerror = 6                          && Print_Error MODEL, _1
            FWriteLine(Errhandle," Print_Error      : "+UPPER(Info))
            FWriteLine(Errhandle," MODULE           : "+UPPER(Name))
            FWriteLine(Errhandle," LINE NUMBER      : "+TRANSFORM(Line,"999,999"))
            FWriteLine(Errhandle," MODEL            : "+MODEL)
            FWRITE(Errhandle," _1               : ")
            FWriteLine(Errhandle,_1)
            FWriteLine(Errhandle," TYPE(_1)         : "+TYPE("_1"))
      ENDCASE
   ENDIF
   FWriteLine(Errhandle,"")
   LogScreen()
   LogDisk()
   LogHard()
   LogSets()
   LogHotKey()
   LogMemVars()
   LogDbf()
   FWriteLine(Errhandle,STRCENTER("******** End of Report **********",78))
   FCLOSE(Errhandle)
RETURN(.T.)


FUNCTION LogDbf
   FWriteLine(Errhandle,"")
   FWriteLine(Errhandle,"DATABASE INFORMATION ")
   FWriteLine(Errhandle,"")
   IF SELECT() = 0
      FWriteLine(ErrHandle," No Area Selected ")
   ELSE
      AreaSelected = SELECT()
   ENDIF
   FWriteLine(Errhandle," * * *"+SPACE(61)+"* * *")
   FOR Out_Ctr = 1 TO 250
      IF Alltrimlen(ALIAS(Out_Ctr)) > 0
         SELECT (Out_Ctr)
         FWRITE(Errhandle,IF(SELECT()#AreaSelected," Area         : "," Selected Area: ")+ ;
         LTRIM(STR(SELECT()))+"  ")
         FWriteLine(Errhandle,ALIAS())
         FWriteLine(Errhandle," Record Number: " + ALLTRIM(TRANSFORM(RECNO(), ;
         "@B 999,999"))+" of "+ALLTRIM(TRANSFORM(RECCOUNT(),"@B 999,999"))+ ;
         IF(DELETED()," <Deleted>","")+IF(EOF()," <End of File>","")+;
         IF(BOF()," <Beginning of File>",""))   
         FWriteLine(Errhandle," Last Updated : "+DTOC(LUPDATE()))
         FOR In_Ctr = 1 TO 15
            Rstring = DBRELATION(In_Ctr)
            IF Alltrimlen(Rstring) > 0       
               FWRITE(Errhandle," Relation     :"+LTRIM(STR(In_Ctr))+"  "+TRIM(Rstring))
               FWriteLine(Errhandle," INTO "+ALIAS(DBRSELECT(In_Ctr)))
            ELSE
               IF In_Ctr = 1 
                  FWriteLine(Errhandle," Relation     : None")
                  EXIT
               ENDIF
            ENDIF
         NEXT
         IF Alltrimlen(DBFILTER()) > 0
            FWriteLine(Errhandle," Filter       : "+DBFILTER())
         ELSE
            FWriteLine(Errhandle," Filter       : None")
         ENDIF
         IF ISINDEX()
            Ntx_Cont = INDEXORD()
            FOR In_Ctr = 1 to 15
               Ntx_Key  = INDEXKey(In_Ctr)
               IF Alltrimlen(Ntx_Key) > 0     
                  FWRITE(Errhandle," Index        : "+LTRIM(STR(In_Ctr,2,0))+"  "+SUBSTR(INDEXKey(In_Ctr)+SPACE(50),1,47))
                  FWriteLine(Errhandle,IF(In_Ctr = Ntx_Cont,"Primary ","Secondary "))
               ELSE
                  EXIT
               ENDIF
            NEXT    
         ELSE                    
            FWriteLine(Errhandle," Index        : None")
         ENDIF
         FWriteLine(Errhandle," * * *"+SPACE(61)+"* * *")
      ENDIF
   NEXT
RETURN(0)


FUNCTION Print_Stat
   PARAMETER Port_Num
   Prt_stat = Prnstatus(Port_Num)
   DO CASE
      CASE Prt_Stat = 0
      RETURN("On-Line ")
   CASE Prt_Stat = 1
      RETURN("Off-Line ")
   CASE Prt_Stat = 2
      RETURN("Turned Off ")
   CASE Prt_Stat = 3
      RETURN("Out of Paper ")
   CASE Prt_Stat = 4
      RETURN("Bad Cable Connection ")
   OTHERWISE
      RETURN("Status Unknown ")
ENDCASE


FUNCTION DosErrMsg
   PRIVATE Err_Num
   Err_Num = DOSERROR()
   DO CASE
      CASE Err_Num =  0
         Msg = "Unknown or No Error"
      CASE Err_Num =  1
         Msg = "Invalid function number"
      CASE Err_Num =  2
         Msg = "File not found"
      CASE Err_Num =  3
         Msg = "Path not found"
      CASE Err_Num =  4
         Msg = "Too many open Files (no handles left)"
      CASE Err_Num =  5
         Msg = "Access denied"
      CASE Err_Num = 6
         Msg = "Invalid handle"
      CASE Err_Num =  7
         Msg = "Memory control blocks destroyed"
      CASE Err_Num =  8
         Msg = "Insufficient memory"
      CASE Err_Num =  9
         Msg = "Invalid memory block address"
      CASE Err_Num = 10
         Msg = "Invalid environment"
      CASE Err_Num = 11
         Msg = "Invalid format"
      CASE Err_Num = 12
         Msg = "Invalid access code"
      CASE Err_Num = 13
         Msg = "Invalid data"
      CASE Err_Num = 14
         Msg = "Reserved"
      CASE Err_Num = 15
         Msg = "Invalid drive was specified"
      CASE Err_Num = 16
         Msg = "Attempt to remove current directory"
      CASE Err_Num = 17
         Msg = "Not same device"
      CASE Err_Num = 18
         Msg = "No more Files"
      CASE Err_Num = 19
         Msg = "Attempt to write on write-protected diskette"
      CASE Err_Num = 20
         Msg = "Unknown unit"
      CASE Err_Num = 21
         Msg = "Drive not ready"
      CASE Err_Num = 22
         Msg = "Unknown command"
      CASE Err_Num = 23
         Msg = "Data error (CRC)"
      CASE Err_Num = 24
         Msg = "Bad request structure length"
      CASE Err_Num = 25
         Msg = "Seek error"
      CASE Err_Num = 26
         Msg = "Unknown media type"
      CASE Err_Num = 27
         Msg = "Sector not found"
      CASE Err_Num = 28
         Msg = "Printer out of paper"
      CASE Err_Num = 29
         Msg = "Write fault"
      CASE Err_Num = 30
         Msg = "Read fault"
      CASE Err_Num = 31
         Msg = "General failure"
      CASE Err_Num = 32
         Msg = "Sharing violation"
      CASE Err_Num = 33
         Msg = "Lock violation"
      CASE Err_Num = 34
         Msg = "Invalid disk change"
      CASE Err_Num = 35
         Msg = "FCB unavailable"
      CASE Err_Num = 36
         Msg = "Sharing buffer overflow"
      CASE Err_Num >= 37 .AND. Err_Num <= 49
         Msg = "Reserved"
      CASE Err_Num = 50
         Msg = "Network request not supported"
      CASE Err_Num = 51
         Msg = "Remote computer not listening"
      CASE Err_Num = 52
         Msg = "Duplicate Name on network"
      CASE Err_Num = 53
         Msg = "Network Name not found"
      CASE Err_Num = 54
         Msg = "Network busy"
      CASE Err_Num = 55
         Msg = "Network device no longer exists"
      CASE Err_Num = 56
         Msg = "Network BIOS command limit exceeded"
      CASE Err_Num = 57
         Msg = "Network adapter hardware error"
      CASE Err_Num = 58
         Msg = "Incorrect response from network"
      CASE Err_Num = 59
         Msg = "Unexpected network error"
      CASE Err_Num = 60
         Msg = "Incompatible remote adapter"
      CASE Err_Num = 61
         Msg = "Print queue full"
      CASE Err_Num = 62
         Msg = "Not enough space for print File"
      CASE Err_Num = 63
         Msg = "Print File deleted (not enough space)"
      CASE Err_Num = 64
         Msg = "Network Name deleted"
      CASE Err_Num = 65
         Msg = "Access denied"
      CASE Err_Num = 66
         Msg = "Network device type incorrect"
      CASE Err_Num = 67
         Msg = "Network Name not found"
      CASE Err_Num = 68
         Msg = "Network Name limit exceeded"
      CASE Err_Num = 69
         Msg = "Network BIOS session limit exceeded"
      CASE Err_Num = 70
         Msg = "Temporarily paused"
      CASE Err_Num = 71
         Msg = "Network request not accepted"
      CASE Err_Num = 72
         Msg = "Print or disk redirection paused"
      CASE Err_Num >= 73 .AND. Err_Num <= 79
         Msg = "Reserved"
      CASE Err_Num = 80
         Msg = "File exists"
      CASE Err_Num = 81
         Msg = "Reserved"
      CASE Err_Num = 82
         Msg = "Cannot make directory entry"
      CASE Err_Num = 83
         Msg = "Fail on INT 24"
      CASE Err_Num = 84
         Msg = "Too many redirections"
      CASE Err_Num = 85
         Msg = "Duplicate redirection"
      CASE Err_Num = 86
         Msg = "Invalid password"
      CASE Err_Num = 87
         Msg = "Invalid parameter"
      CASE Err_Num = 88
         Msg = "Network device fault"
      OTHERWISE
         MSg = "No Message Available"
   ENDCASE
RETURN("DOS Error "+TRANSFORM(Err_Num,"999")+"  "+Msg)


FUNCTION LogDisk
   FWriteLine(Errhandle,"")
   FWriteLine(Errhandle,"MEMORY/DISK")
   FWriteLine(Errhandle,"")
   FWriteLine(Errhandle," Volume Label     : "+IF(Alltrimlen(GETVOLUME())=0,"None",GETVOLUME()))
   FWriteLine(Errhandle," DOS Version      : "+TRANSFORM(DOSVERS(),"9.99"))
   FWriteLine(Errhandle," Default Path     : "+PATH())
   FWriteLine(Errhandle," Current Directory: "+CURDIR())
   FWriteLine(Errhandle," Total Disk Space : "+TRANSFORM(DISKSIZE(),"999,999,999")+" Bytes ")
   FWriteLine(Errhandle," Free Disk Space  : "+TRANSFORM(DISKSPACE(),"999,999,999")+" Bytes")
   FWriteLine(Errhandle," Number of Drives : "+TRANSFORM(DRIVES(),"99"))
   Dstr = DriveStr()
   Dstr = IF(SUBSTR(Dstr,1,1)="A",SUBSTR(Dstr,2),DStr)
   Dstr = IF(SUBSTR(Dstr,1,1)="B",SUBSTR(Dstr,2),DStr)
   FOR Ctr = 1 TO LEN(Dstr)
      IF IsDrive(SUBSTR(Dstr,Ctr,1)+":")
         FWriteLine(Errhandle," Directory of "+SUBSTR(Dstr,Ctr,1)+"   : "+CURDIR(SUBSTR(Dstr,Ctr,1)))
      ELSE
         FWriteLine(Errhandle," Directory of "+SUBSTR(Dstr,Ctr,1)+"   : Drive not ready")
      ENDIF
   NEXT
   FWriteLine(Errhandle," DOS Mem Installed: "+TRANSFORM(DOSMEM()*1024,"999,999,999")+" Bytes")
   FWriteLine(Errhandle," DOS Memory Free  : "+TRANSFORM(Fre(),"999,999,999")+" Bytes")
   FWriteLine(Errhandle," Avail Free Pool  : "+TRANSFORM(MEMORY(0)*1024,"999,999,999")+" Bytes")
   FWriteLine(Errhandle," Expanded Mem Mgr : "+IF(ISEMS(),TRANSFORM(EXPMEM()*1024,"999,999,999")+" Bytes ","None"))
   FWriteLine(Errhandle," Avail Extend Mem : "+TRANSFORM(EXTMEM()*1024,"999,999,999")+" Bytes")
   FWriteLine(Errhandle," Avail File Handle: "+TRANSFORM(HANDLES(),"999"))
   FWriteLine(Errhandle," Maximum Handles  : "+TRANSFORM(MAXHANDLES(),"999"))
RETURN(.T.)


FUNCTION LogHard
   FWriteLine(ErrHandle,"")
   FWriteLine(Errhandle,"HARDWARE")
   FWriteLine(Errhandle,"")
   FWriteLine(Errhandle," System Type      : "+SysId())
   FWriteLine(Errhandle," CPU Type         : "+TRANSFORM(CPUTYPE(),"99999"))
   FWriteLine(Errhandle," Monitor Type     : "+Monitor())
   IF VidType() = 2 .OR. VidType() = 3
      FWriteLine(Errhandle," Video Memory     : "+TRANSFORM(EGAMEM()*1024,"999,999,999")+" Bytes")
   ENDIF
   FWriteLine(Errhandle," Caps Lock        : "+IF(CapsLock(),"On","Off"))
   FWriteLine(Errhandle," Num Lock         : "+IF(NumLock(),"On","Off"))
   FWriteLine(Errhandle," Scroll Lock      : "+IF(ScrLock(),"On","Off"))
   FWriteLine(Errhandle," Insert           : "+IF(Insert(),"On","Off"))
   FWriteLine(Errhandle," Comm Port 1      : "+IF(ISCOM(1),"Installed","None"))
   FWriteLine(Errhandle," Comm Port 2      : "+IF(ISCOM(2),"Installed","None"))
   FWriteLine(Errhandle," Comm Port 3      : "+IF(ISCOM(3),"Installed","None"))
   FWriteLine(Errhandle," Comm Port 4      : "+IF(ISCOM(4),"Installed","None"))
   FWriteLine(Errhandle," Printer 1        : "+Print_Stat(1))
   FWriteLine(Errhandle," Printer 2        : "+Print_Stat(2))
   FWriteLine(Errhandle," Printer 3        : "+Print_Stat(3))
   FWriteLine(Errhandle," Co-Processor     : "+IF(NDPTYPE()=0,"None ",TRANSFORM(NDPTYPE(),"99999")))
   FWriteLine(Errhandle," Mouse            : "+IF(ISMOUSE(),"Installed","None    "))
   FWriteLine(Errhandle," Last Key         : "+LTRIM(STR(LASTKey())))
RETURN(.T.)

FUNCTION LogSets
   FWriteLine(ErrHandle,"")
   FWriteLine(Errhandle,"SET COMMANDS ")
   FWriteLine(Errhandle,"")
   FWriteLine(Errhandle," Alternate        : "+IF(STATUS(1),"ON ", "OFF"))
   FWriteLine(Errhandle," Bell             : "+IF(STATUS(2),"ON ", "OFF"))
   FWriteLine(Errhandle," Century          : "+IF(STATUS(3),"ON ", "OFF"))
   FWriteLine(Errhandle," Confirm          : "+IF(STATUS(4),"ON ", "OFF"))
   FWriteLine(Errhandle," Console          : "+IF(STATUS(5),"ON ", "OFF"))
   FWriteLine(Errhandle," Cursor           : "+IF(STATUS(6),"ON ", "OFF"))
   FWriteLine(Errhandle," Date Type        : "+DateTypeSt())
   FWriteLine(Errhandle," Decimals         : "+LTRIM(STR(Decimals())))
   FWriteLine(Errhandle," Default          : "+IF(Alltrimlen(Default()) = 0,"None",Default()))
   FWriteLine(Errhandle," Deleted          : "+IF(STATUS(7),"ON ", "OFF"))
   FWriteLine(Errhandle," Delimiters       : "+IF(STATUS(8),"ON "+Delimiters(), "OFF"))
   FWriteLine(Errhandle," Escape           : "+IF(STATUS(9),"ON ", "OFF"))
   FWriteLine(Errhandle," Exact            : "+IF(STATUS(10),"ON ","OFF"))
   FWriteLine(Errhandle," Exclusive        : "+IF(STATUS(11),"ON.","OFF"))
   FWriteLine(Errhandle," Fixed            : "+IF(STATUS(12),"ON ","OFF"))
   FWriteLine(Errhandle," Insert           : "+IF(STATUS(13),"ON ","OFF"))
   FWriteLine(Errhandle," Intensity        : "+IF(STATUS(14),"ON ","OFF"))
   FWriteLine(Errhandle," Margin           : "+LTRIM(STR(Margin())))
   FWriteLine(Errhandle," Path             : "+PATH())
   FWriteLine(Errhandle," Print            : "+IF(STATUS(15),"ON ","OFF"))
   FWriteLine(Errhandle," Scoreboard       : "+IF(STATUS(16),"ON ","OFF"))
   FWriteLine(Errhandle," Softseek         : "+IF(STATUS(17),"ON ","OFF"))
   FWriteLine(Errhandle," Unique           : "+IF(STATUS(18),"ON ","OFF"))
   FWriteLine(Errhandle," Wrap             : "+IF(STATUS(19),"ON ","OFF"))
RETURN(.T.)

FUNCTION LogHotKey
   PRIVATE Ctr
   FOR Ctr = -50 TO 400
      IF Ctr # 0
         IF IsKeySet(Ctr)
            FWriteLine(Errhandle," Key "+TRANSFORM(Ctr,"999")+"          : "+SetKey(Ctr))
         ENDIF
      ENDIF
   NEXT
   FWriteLine(Errhandle,"")
RETURN(.T.)


FUNCTION LogScreen
   ScreenVar = ReadScreen(0,0,2000)
   FWriteLine(Errhandle,"")
   FWriteLine(Errhandle,"SCREEN CONTENTS")
   FWriteLine(Errhandle,"")
   FOR Ctr = 0 TO 24
      FWriteLine(Errhandle,SUBSTR(ScreenVar,(Ctr * 80) + 1,80))
   NEXT
   RELEASE ScreenVar
RETURN(.T.)


FUNCTION Monitor
   PRIVATE MType
   MType = MONTYPE()
   IF MType = 0
      MStr = "No Display"
   ELSEIF MType = 1
      MStr = "MDA with Monochrome Display"
   ELSEIF MType = 2
      MStr = "CGA with Color Display"
   ELSEIF MType = 4
      MStr = "EGA with Color Display"
   ELSEIF MType = 5
      MStr = "EGA with Monochrome Display"
   ELSEIF MType = 6
      MStr = "Professional Graphics Adaptor"
   ELSEIF MType = 7
      MStr = "VGA with Monochrome Display"
   ELSEIF MType = 8
      MStr = "VGA with Color Display"
   ELSEIF MType = 10
      MStr = "MCGA with Digital Color Display"
   ELSEIF MType = 11
      MStr = "MCGA with Analog Monochrome Display"
   ELSEIF MType = 12
      MStr = "MCGA with Analog Color Display"
   ELSE
      MStr = "Unrecognized Display"
   ENDIF
RETURN(MStr)


FUNCTION SysId
PRIVATE IDStr, IDByte, RomBiosDate
RomBiosDate = ROMDATE()
IDByte = SYSTYPE()
IF RomBiosDate = "04/24/81" .AND. IDByte = 255
   IDStr = "IBM PC (first MODEL)"
ELSEIF RomBiosDate = "10/19/81" .AND. IDByte = 255
   IDStr = "IBM PC with bugs fixed"
ELSEIF RomBiosDate = "08/16/82" .AND. IDByte = 254
   IDStr = "IBM XT (first MODEL)"
ELSEIF RomBiosDate = "10/27/82" .AND. IDByte = 255
   IDStr = "IBM PC handling hard disk"
ELSEIF RomBiosDate = "11/08/82" .AND. IDByte = 254
   IDStr = "IBM Portable"
ELSEIF RomBiosDate = "06/01/83" .AND. IDByte = 253
   IDStr = "IBM PC Jr."
ELSEIF RomBiosDate = "01/10/84" .AND. IDByte = 252
   IDStr = "IBM AT"
ELSEIF RomBiosDate = "06/10/85" .AND. IDByte = 252
   IDStr = "IBM AT Revision 1"
ELSEIF RomBiosDate = "09/13/85" .AND. IDByte = 249
   IDStr = "IBM Convertible"
ELSEIF RomBiosDate = "11/15/85" .AND. IDByte = 252
   IDStr = "IBM AT with speed governer"
ELSEIF RomBiosDate = "01/10/86" .AND. IDByte = 251
   IDStr = "IBM XT Revision 1"
ELSEIF RomBiosDate = "04/21/86" .AND. IDByte = 252
   IDStr = "IBM XT 286 Sub MODEL 1"
ELSEIF RomBiosDate = "05/09/86" .AND. IDByte = 251
   IDStr = "IBM XT Revision 2"
ELSEIF RomBiosDate = "09/02/86" .AND. IDByte = 250
   IDStr = "IBM PS/2 MODEL 30"
ELSEIF RomBiosDate = "02/13/87" .AND. IDByte = 252
   IDStr = "IBM PS/2 MODEL 50 or 60"
ELSEIF RomBiosDate = "03/30/87" .AND. IDByte = 248
   IDStr = "IBM PS/2 MODEL 80 (16 MHz)"
ELSEIF RomBiosDate = "10/07/87" .AND. IDByte = 248
   IDStr = "IBM PS/2 MODEL 80 (20 MHz)"
ELSE
   IDStr = "Unknown Computer System"
ENDIF      
RETURN(IDStr)


FUNCTION DATETYPEST
   PRIVATE DType, DStr
   DType = DATETYPE()
   IF DType = 1 
      DStr = "American "
   ELSEIF DType = 2
      DStr = "Ansi     "
   ELSEIF DType = 3 
      DStr = "British  "
   ELSEIF DType = 4 
      DStr = "French   "
   ELSEIF DType = 5
      DStr = "German   "
   ELSEIF DType = 6 
      DStr = "Italian  "
   ENDIF
RETURN(DStr)



FUNCTION LogMemVars     
   IF Handles() = 0
      ? "No file handles available for error log"
      RETU(.T.)
   ENDIF
   MFile = "SAVEMEM.MEM"
   SAVE ALL TO (MFile)
   FWriteLine(Errhandle,"")
   FWriteLine(Errhandle,"MEMORY VARIABLES")
   FWriteLine(Errhandle,"")
   MemHandle = FOPEN(MFile)
   MemFileLen = FSEEK(MemHandle,0,2)          
   MCharLog = SPACE(1)
   FSEEK(MemHandle,0)
   STORE 0 TO N__, TB_
   IF MemFileLen < 2
      FWriteLine(Errhandle,'THERE ARE NO MEMORY VARIABLES PRESENT.')
   ELSE
      DO WHILE FSEEK(MemHandle,0,1) + 1 < MemFileLen
         MW_ = SPACE(18)
         FREAD(MemHandle,@MW_,18)
         VarName = LEFT(MW_,AT(CHR(0),MW_)-1)
         VarType = SUBSTR(MW_,12,1)
         VR_ = BIN2W(RIGHT(MW_,2))
         IF !(VarType $ (CHR(195)+CHR(204)+CHR(196)+CHR(206)))
            FCLOSE(MemHandle)
            RETU(.T.)
         ENDIF
         MC_ = 14
         FSEEK(MemHandle,MC_,1)
         IF VarType$CHR(195)+CHR(204)
            TB_ = TB_ + VR_ 
            MCHARLOG = SPACE(VR_)
            FREAD(MemHandle,@MCHARLOG,VR_)
            * take care of the null terminator
            MCharLog = SUBSTR(MCharLog,1,LEN(MCharLog)-1)
         ELSE
            TB_ = TB_ + 8
            MNUMERIC = SPACE(8)
            FREAD(MemHandle,@MNUMERIC,8)
            P1 = MOD(ASC(SUBSTR(MNUMERIC,8,1)),128)*16
            P2 = INT(ASC(SUBSTR(MNUMERIC,7,1))/16)
            POWER = P1 + P2 - 1023
            MINUS = INT(ASC(SUBSTR(MNUMERIC,8,1)) /16) >= 8
            MANT0 = MOD(ASC(SUBSTR(MNUMERIC,7,1)),16) /16
            MANT1 = BIN2W(SUBSTR(MNUMERIC,5,2)) / (65536 * 16)
            MANT2 = BIN2W(SUBSTR(MNUMERIC,3,2)) / (65536 * 65536 * 16)
            MANT3 = BIN2W(SUBSTR(MNUMERIC,1,2)) / (65536 * 65536 * 65536 * 16)
            MANTISSA = MANT0 + MANT1 + MANT2 + MANT3
            NUMVAL = IF(MINUS, (-1 + MANTISSA) * (2^POWER),(1 + MANTISSA) * (2^POWER))
            SHOWDEC = ASC(RIGHT(MW_,1))
         ENDIF
         FWRITE(ErrHandle,VarName+SPACE(10-LEN(VarName)))
         CharLen = LTRIM(STR(LEN(MCharLog))) 
         CharLen = CharLen + SPACE(6 - LEN(CharLen))
         IF VarType = CHR(195) .AND. VR_ > 51
            FWRITE(Errhandle,' C ')
            FWriteLine(Errhandle, CharLen+'"'+LEFT(MCharLog,50)+'"')
         ELSE                                                 
            DO CASE
               CASE VarType = CHR(195)
                  FWRITE(Errhandle,' C ')
                  FWriteLine(Errhandle,CharLen+["]+MCharLog+["])
               CASE VarType = CHR(204)
                  FWRITE(Errhandle,' L 1     ')
                  FWriteLine(Errhandle,IF(ASC(MCharLog)#0,'.T.','.F.'))
               CASE VarType = CHR(206)
                  FWRITE(Errhandle,' N ')
                  NumLen = LTRIM(STR(NumLength(NumVal)))+"."+LTRIM(STR(ShowDec))
                  NumLen = NumLen + SPACE(6 - LEN(NumLen))
                  FWRITE(Errhandle,NumLen)
                  FWriteLine(Errhandle,LTRIM(STR(NUMVAL,20,SHOWDEC)))
               CASE VarType = CHR(196)
                  FWRITE(Errhandle,' D 8     ')
                  FWriteLine(Errhandle,DTOC(CTOD('01/01/0100')+NUMVAL-1757585))
            ENDCASE
         ENDIF
      ENDDO
   ENDIF
   FCLOSE(MemHandle)
RETURN(.T.)

FUNCTION NumLength        
   PARAMETERS Number                                                  
   IF ShowDec = 0
      CharNum = STR(Number,19,0)             
   ELSE
      CharNum = STR(Number,19,ShowDec)             
   ENDIF
RETURN(Alltrimlen(CharNum))

