; IOCTL.ASM
; Source code for assembly language routines to access
;     IOCTL to set RAW or COOKED mode for a character device
; Released to the public domain by AccFin software
; Initial routine by Judd Cole
; Updated/enhanced by Brad Codd
; Rewritten with ability to select LPT1, 2, etc by Mark Leavitt
; Contains assembly language routines:  IORAW() and IOCOOKED()
;------------------------------------------------------------
;     IORAW()
;     Syntax:   IORAW(<expN>)
;     Params:   expN = handle for device driver of interest
;     Returns:  0 if successful, 1 if failed
;     Notes:    It calls INT 21H, Function 44H in DOS, mode
;               01H (set device information)

;     IOCOOKED()
;     Syntax:   IOCOOKED(<expN>)
;     Params:   expN = handle for device driver of interest
;     Returns:  0 if successful, 1 if failed
;     Notes:    It calls INT 21H, Function 44H in DOS, mode
;               01H (set device information)
;--------------------------------------------------------------
; Example Clipper code
;     PrnHandle=FOPEN("LPT1",2)      && Open LPT1 (or LPT2, etc)
;     Temp=IORAW(PrnHandle)          && Sets LPT1 to "RAW" (binary) mode
;     IF Temp <> 0
;        ? "Error calling IORAW"
;        QUIT
;     ENDIF
;     FWRITE(PrnHandle,"Before control-z "+CHR(26)+" after control-z")
;     FWRITE(PrnHandle,CHR(13)+CHR(10)+CHR(12))     && Eject the page
;     Temp=IOCOOKED(PrnHandle)       && Set LPT1 back to "COOKED"
;     IF Temp <> 0
;        ? "Error calling IOCOOKED"
;        QUIT
;     ENDIF
;     FCLOSE(PrnHandle)


PUBLIC IORAW,IOCOOKED

EXTRN  __PARNI:FAR
EXTRN  __RETNI:FAR

DGROUP   GROUP   DATASG
DATASG   SEGMENT 'DATA'
HANDLE   DW 0
DATASG   ENDS
_PROG    SEGMENT 'CODE'
         ASSUME CS:_PROG,DS:DGROUP
IORAW    PROC FAR
         PUSH BP
         MOV  BP,SP
         PUSH DS
         PUSH ES
         PUSH SI
         PUSH DI
;        Get first parameter: handle number
         MOV AX,1
         PUSH AX
         CALL __PARNI
         ADD SP,2
         MOV BX,AX                ; put handle number in BX
;        Now set up before calling INT21H
         MOV AX,04400H            ; Function 44H, mode 00H = get info
         INT 21H
         MOV DH,0                 ; Set DH to 0
         OR  DL,20H               ; Turn on Bit 5 to set RAW mode
         MOV AX,04401H            ; Function 44H, mode 01H = set info
         INT 21H
         XOR AX,AX                ; Set AX to 0
         JNC NOERRRAW             ; If carry clear, no error, we're done
         INC AX                   ; Error, set AX to 1
NOERRRAW:
         POP DI
         POP SI
         POP ES
         POP DS
         POP BP
         PUSH AX
         CALL __RETNI
         ADD SP,2
         RET
IORAW    ENDP

IOCOOKED PROC FAR
         PUSH BP
         MOV  BP,SP
         PUSH DS
         PUSH ES
         PUSH SI
         PUSH DI
;        Get first parameter: handle number
         MOV AX,1
         PUSH AX
         CALL __PARNI
         ADD SP,2
         MOV BX,AX                ; put handle number in BX
;        Now set up before calling INT21H
         MOV AX,04400H            ; Function 44H, mode 00H = get info
         INT 21H
         MOV DH,0                 ; Set DH to 0
         AND DL,0DFH              ; Turn off Bit 5 to set COOKED mode
         MOV AX,04401H            ; Function 44H, mode 01H = set info
         INT 21H
         XOR AX,AX                ; Set AX to 0
         JNC NOERRCOOK            ; If carry clear, no error, we're done
         INC AX                   ; Error, set AX to 1
NOERRCOOK:
         POP DI
         POP SI
         POP ES
         POP DS
         POP BP
         PUSH AX
         CALL __RETNI
         ADD SP,2
         RET
IOCOOKED ENDP
_PROG    ENDS
         END
