program dirdb;

{
   Author   : Clayton C. Ainsworth
   Date     : July 7, 1992
   Desc.    : This program will run from the DOS command line and will
              provide a listing of all .DBF files, along with other
              information derived from the file header, such as
              # of records, record length, # of fields, date of last
              update, etc.
   Compiler : Turbo Pascal (r) Version 6.0
}

uses DOS;

type

    fhdr = record               {This record definition matches}
         memo : byte;           {the first 11 bytes of the .DBF}
         yy   : byte;           {header, where the info we need}
         mm   : byte;           {is kept.                      }
         dd   : byte;
         recs : longint;
         hdrl : integer;
         recl : integer;
    end;

    foo  = file of fhdr;


const
     defmask = '*.DBF';

var
    hdr         : fhdr;
    dosrec      : SearchRec;  {special type used with FindFirst}
    mask        : string;
    rcrds       : string[7];
    rclen       : string[5];
    num         : integer;
    numflds     : string[6];
    yesno       : string;
    fsize       : string;
    foo1        : foo;        {have NO imagination for type names}
    x           : integer;
    valid       : boolean;
    mm1,dd1,yy1 : string;


procedure HelpScr;         {coulda done this in mainline code, but}
                           {just HAD to make it LOOK harder <g>   }
begin
     WriteLn;
     WriteLn('SYNTAX: DIRDB <filename.ext>  *.dbf is default mask');
     WriteLn;
end;


begin

     if ParamStr(1) = '?' then
        begin
             HelpScr;               {check for help screen call}
             exit;
        end;

     if ParamCount < 1 then
        mask := defmask              {if no parms, then *.dbf mask}
     else
        mask := ParamStr(1);


     FindFirst(mask,Archive,dosrec);      {Go get 'em, DOS!}

     If DosError <> 0 then
     begin                                {oops, try again}
          WriteLn;
          WriteLn('No files matching ',mask);
          exit;
     end;

     WriteLn;       {We found a file, so let's do headers.  >yuk< }
     WriteLn;
     WriteLn('  Filename       Records      Date       RecLen    Fields   Memo     Size');
     WriteLn('------------     -------    --------     ------    ------   ----   ---------');

     while DosError = 0 do
     begin
          assign(foo1,dosrec.name);
          reset(foo1);                {open the file and read in the header}
          Read(foo1,hdr);
          if (hdr.memo <> $83) and (hdr.memo <> $03) then    {is it a .dbf?}
             valid := False
          else
             valid := True;

          Str(hdr.recs:7,rcrds);           {write the name}
          Write(Dosrec.name,'    ');

          if NOT valid then
             WriteLn('  *** Not a dBASE III .DBF file');

          while valid do      {if it's a .DBF file, let's show the good stuff}
          begin
            for x := Length(Dosrec.name) to 12 do   {pad after filename}
              Write(' ');

            Str(hdr.mm:2,mm1);                      {gotta get the dates}
            Str(hdr.dd:2,dd1);                      {all the same length}
            Str(hdr.yy:2,yy1);
            Write(rcrds,'    ',mm1,'/',dd1,'/',yy1);

            Str(hdr.recl:5,rclen);
            num := (hdr.hdrl - 32) div 32;          {calculate # of fields}
            Str(num:6,numflds);                     {from header size     }
            if hdr.memo = $83 then
               yesno := 'YES'
            else                                    {to memo or not to memo}
               yesno := ' NO';
            Write('    ',rclen,'    ',numflds,'     ',yesno);

            Str(dosrec.size:9,fsize);
            WriteLn('   ',fsize);                   {filesize from DOS call}
          end;

            FindNext(dosrec);                       {go get another one}
     end;
     WriteLn;
end.