clear
@ 01,02 SAY "Dicdbfs version 0.9"
@ 03,02 SAY "Read a UI 2 dictionary file and list dbf info only."

dic_count = ADIR("*.dic")

DECLARE dic_files[dic_count], dic_size[dic_count]

ADIR("*.dic",dic_files,dic_size)

@ 05,20 SAY "Pick a dictionary file to read."

dic_open   = ACHOICE(07,25,12,40,dic_files)

CLEAR
buffer     = ""
buffer     = SPACE(dic_size[dic_open] + 128)
dic_handle = FOPEN(dic_files[dic_open],0)      && open the file chosen above

bytes_read = FREAD(dic_handle,@buffer,dic_size[dic_open])

offset  = 8                      && first character of dic internal name
* SET PRINT ON
* SET MARGIN TO 10
* ? CHR(15)

ndbfs   = COUNTUDBFS(dic_handle)

FCLOSE(dic_handle)  

?  dic_files[dic_open]  + " as of " + DTOC(DATE()) + "  at: " + TIME()
? 
? "Number of databases in this dictionary " + STR(ndbfs,3)
? "------------------------------------------------"
 
* a = number of dbfs (counter)
* b = number of fields in a dbf (counter)
* c = number of indexes for dbf (counter)
* d = number of relations defined

FOR a = 1 TO ndbfs
    ? "Database name.." + UI_NEXT(buffer,@offset)
    alias    = UI_NEXT(buffer,@offset)
    dbfdescr = UI_NEXT(buffer,@offset)
    slot1    = UI_NEXT(buffer,@offset)
    slot2    = UI_NEXT(buffer,@offset)
    slot3    = UI_NEXT(buffer,@offset)
    IF LEN(alias) > 0
       ? "Alias.........." + alias
    ENDIF
    IF LEN(dbfdescr) > 0
       ? "Description...." + dbfdescr
    ENDIF
    IF LEN(slot1) > 0
       ? "Slot 1........." + slot1
    ENDIF
    IF LEN(slot2) > 0
       ? "Slot 2........." + slot2
    ENDIF
    IF LEN(slot3) > 0
       ? "Slot 3........." + slot3
    ENDIF

    dbfwork  = UI_INTGER(buffer,@offset) 
    ? "Work area......" + STR(dbfwork,3)
    dbfields = UI_INTGER(buffer,@offset)
    ? "# of fields...." + STR(dbfields,3)
    ?
    ? "Field name  Type  Length  Decimals"
    ? "----------------------------------"
      
    FOR b = 1 TO dbfields
       fld_name = UI_NEXT(buffer,@offset)
       fld_type = SUBSTR(buffer,offset,1)       && 1 character
       offset   = offset + 1
       fld_lnth = UI_INTGER(buffer,@offset)
       fld_deci = UI_INTGER(buffer,@offset)
   
       ?  PAD_IT(fld_name,14) + fld_type 
       ?? STR(fld_lnth,8) 
       ?? STR(fld_deci,8)

       fdescri = UI_NEXT(buffer,@offset)
       fformul = UI_NEXT(buffer,@offset)
       fpictur = UI_NEXT(buffer,@offset)
       vclause = UI_NEXT(buffer,@offset)
       rclause = UI_NEXT(buffer,@offset)
       i_value = UI_NEXT(buffer,@offset)
       c_formu = UI_NEXT(buffer,@offset)
       fslot_1 = UI_NEXT(buffer,@offset)
       fslot_2 = UI_NEXT(buffer,@offset)
       fslot_3 = UI_NEXT(buffer,@offset)
    NEXT 

    ntxs = UI_INTGER(buffer,@offset)
    IF ntxs > 0
       FOR c = 1 TO ntxs		&&loop while doing indexes
	   FOR dummy = 1 TO 6
              ui_thing = UI_NEXT(buffer,@offset)
           NEXT
       NEXT
    ENDIF 

    relats = UI_INTGER(buffer,@offset)
    IF relats > 0		     
       FOR c = 1 TO relats              &&loop while doing relations
	   FOR dummy = 1 TO 6
	       ui_thing = UI_NEXT(buffer,@offset)
           NEXT
       NEXT
    ENDIF
?
?
NEXT
* EJECT

* SET PRINT OFF
RETURN
**************************************************************************
FUNCTION UI_INTGER

PARAMETERS ibuffer, n_offset
PRIVATE two_byte, int

two_byte = SUBSTR(ibuffer,n_offset,2)
n_offset = n_offset + 2
intger   = BIN2I(two_byte)

RETURN intger

**************************************************************************
FUNCTION UI_NEXT

PARAMETERS ibuffer, n_offset
PRIVATE nextword, nextchr 

   nextword = ""
   DO WHILE .T.
      nextchr    = SUBSTR(ibuffer,n_offset,1)
      nextword   = nextword + nextchr
      n_offset   = n_offset + 1
      IF nextchr = CHR(0)
         EXIT
      ENDIF
   ENDDO

RETURN nextword

***************************************************************************
FUNCTION PAD_IT
PARAMETERS oldstr, newlength
PRIVATE oldlen
oldlen = LEN(oldstr)
blanks = newlength - oldlen
newstr = oldstr + SPACE(blanks)

RETURN newstr
***************************************************************************
FUNCTION COUNTUDBFS

PARAMETERS d_handle

PRIVATE start, lilbuff, numdbfs, m, i

start   = FSEEK(d_handle,0,0)		  && rewind to beginning of the file
lilbuff = SPACE(8)
m       = FREAD(d_handle,@lilbuff,8)
numdbfs = SUBSTR(lilbuff,6,2)   	  && read the 6th, 7th chrs. in file
i       = BIN2I(numdbfs)
RETURN i



