clear
@ 02,02 SAY "Read a UI 2 dictionary file with clipper FOPEN() functions,etc."

dic_count = ADIR("*.dic")

DECLARE dic_files[dic_count], dic_size[dic_count]

ADIR("*.dic",dic_files,dic_size)

@ 05,20 SAY "Pick a dictionary file to read."

dic_open   = ACHOICE(07,25,12,40,dic_files)

CLEAR
buffer     = ""
buffer     = SPACE(dic_size[dic_open] + 128)
dic_handle = FOPEN(dic_files[dic_open],0)      && open the file chosen above

bytes_read = FREAD(dic_handle,@buffer,dic_size[dic_open])

offset  = 8                      && first character of dic internal name
SET PRINT ON
SET MARGIN TO 10
? CHR(15)
ndbfs   = COUNTUDBFS(dic_handle)

FCLOSE(dic_handle)  

?  dic_files[dic_open]  + " as of " + DTOC(DATE()) + "  at: " + TIME()
? 
? "Number of databases in this dictionary " + STR(ndbfs,3)
? "------------------------------------------------"
 
* a = number of dbfs (counter)
* b = number of fields in a dbf (counter)
* c = number of indexes for dbf (counter)
* d = number of relations defined

FOR a = 1 TO ndbfs
    ? "Database name.." + UI_NEXT(buffer,@offset)
    ? "Alias.........." + UI_NEXT(buffer,@offset)
    ? "Description...." + UI_NEXT(buffer,@offset)
    ? "Slot 1........." + UI_NEXT(buffer,@offset)
    ? "Slot 2........." + UI_NEXT(buffer,@offset)
    ? "Slot 3........." + UI_NEXT(buffer,@offset)
    dbfwork  = UI_INTGER(buffer,@offset) 
    ? "Work area......" + STR(dbfwork,3)
    dbfields = UI_INTGER(buffer,@offset)
    ? "# of fields...." + STR(dbfields,3)
    ?
   
    FOR b = 1 TO dbfields
       fld_name = UI_NEXT(buffer,@offset)
       fld_type = SUBSTR(buffer,offset,1)       && 1 character
       offset   = offset + 1
       fld_lnth = UI_INTGER(buffer,@offset)
       fld_deci = UI_INTGER(buffer,@offset)
       ? "Field descrip.." + fld_name +" " + fld_type + " "
       ?? STR(fld_lnth,8) 
       ?? STR(fld_deci,8)
       ? "Description...." + UI_NEXT(buffer,@offset)
       ? "Disp. formula.." + UI_NEXT(buffer,@offset)
       ? "Picture........" + UI_NEXT(buffer,@offset)
       ? "Valid clause..." + UI_NEXT(buffer,@offset)
       ? "Range clause..." + UI_NEXT(buffer,@offset)
       ? "Initial value.." + UI_NEXT(buffer,@offset)
       ? "Calc. formula.." + UI_NEXT(buffer,@offset)
       ? "Field slot 1..." + UI_NEXT(buffer,@offset)
       ? "Field slot 2..." + UI_NEXT(buffer,@offset)
       ? "Field slot 3..." + UI_NEXT(buffer,@offset)
       ? 
    NEXT 

    ntxs = UI_INTGER(buffer,@offset)
    IF ntxs > 0
       FOR c = 1 TO ntxs		&&loop while doing indexes
           ? "Index name....." + UI_NEXT(buffer,@offset)
           ? "Expression....." + UI_NEXT(buffer,@offset)
           ? "Description...." + UI_NEXT(buffer,@offset) 
 	   ? "Index slot 1..." + UI_NEXT(buffer,@offset)
           ? "Index slot 2..." + UI_NEXT(buffer,@offset)
           ? "Index slot 3..." + UI_NEXT(buffer,@offset)
       NEXT
    ENDIF 

    relats = UI_INTGER(buffer,@offset)
    IF relats > 0		     
       FOR c = 1 TO relats              &&loop while doing relations
 	   ? "Relation name.." + UI_NEXT(buffer,@offset)
           ? "Expression....." + UI_NEXT(buffer,@offset)
           ? "Description...." + UI_NEXT(buffer,@offset) 
 	   ? "Relation slt 1." + UI_NEXT(buffer,@offset)
           ? "Relation slt 2." + UI_NEXT(buffer,@offset)
           ? "Relation slt 3." + UI_NEXT(buffer,@offset)
       NEXT
    ENDIF

NEXT
EJECT

SET PRINT OFF
RETURN
**************************************************************************
FUNCTION UI_INTGER

PARAMETERS ibuffer, n_offset
PRIVATE two_byte, int

two_byte = SUBSTR(ibuffer,n_offset,2)
n_offset = n_offset + 2
intger   = BIN2I(two_byte)

RETURN intger

**************************************************************************
FUNCTION UI_NEXT

PARAMETERS ibuffer, n_offset
PRIVATE nextword, nextchr 

   nextword = ""
   DO WHILE .T.
      nextchr    = SUBSTR(ibuffer,n_offset,1)
      nextword   = nextword + nextchr
      n_offset   = n_offset + 1
      IF nextchr = CHR(0)
         EXIT
      ENDIF
   ENDDO

RETURN nextword

***************************************************************************

FUNCTION COUNTUDBFS

PARAMETERS d_handle

PRIVATE start, lilbuff, numdbfs, m, i

start   = FSEEK(d_handle,0,0)		  && rewind to beginning of the file
lilbuff = SPACE(8)
m       = FREAD(d_handle,@lilbuff,8)
numdbfs = SUBSTR(lilbuff,6,2)   	  && read the 6th, 7th chrs. in file
i       = BIN2I(numdbfs)
RETURN i
