clear
@ 02,02 SAY "Read a UI 2 dictionary file with clipper FOPEN() functions,etc."

dic_count = ADIR("*.dic")

DECLARE dic_files[dic_count], dic_size[dic_count]

ADIR("*.dic",dic_files,dic_size)

@ 05,20 SAY "Pick a dictionary file to read."

dic_open   = ACHOICE(07,25,12,40,dic_files)
if dic_open=0
   return
endi

do crea_dbfs

CLEAR
buffer     = ""
buffer     = SPACE(dic_size[dic_open] + 128)
dic_handle = FOPEN(dic_files[dic_open],0)      && open the file chosen above

bytes_read = FREAD(dic_handle,@buffer,dic_size[dic_open])

offset  = 8                      && first character of dic internal name

ndbfs   = COUNTUDBFS(dic_handle)

FCLOSE(dic_handle)

?  dic_files[dic_open]  + " as of " + DTOC(DATE()) + "  at: " + TIME()
?
? "Number of databases in this dictionary " + STR(ndbfs,3)
? "------------------------------------------------"

* a = number of dbfs (counter)
* b = number of fields in a dbf (counter)
* c = number of indexes for dbf (counter)
* d = number of relations defined

SELE 1
USE DBFLIST
SELE 2
USE DBFFIELD
SELE 3
USE DBFINDEX
SELE 4
USE DBFRELAT
FOR a = 1 TO ndbfs
   sele dbflist
   appe blan
   m_dbfname    = subs(UI_NEXT(buffer,@offset),1,20)
   m_alias      = subs(UI_NEXT(buffer,@offset),1,20)
   m_dbfdesc    = UI_NEXT(buffer,@offset)
   m_dbfslot1   = UI_NEXT(buffer,@offset)
   m_dbfslot2   = UI_NEXT(buffer,@offset)
   m_dbfslot3   = UI_NEXT(buffer,@offset)
   m_workarea   = UI_INTGER(buffer,@offset)
   m_dbffldcnt     = UI_INTGER(buffer,@offset)
   do replmvars
   
   SELE DBFFIELD
   FOR b = 1 TO m_dbffldcnt
      appe blank
      m_fldname    = UI_NEXT(buffer,@offset)
      m_fldtype    = SUBSTR(buffer,offset,1)       && 1 character
      offset       = offset + 1
      m_fldlength  = UI_INTGER(buffer,@offset)
      m_flddeci    = UI_INTGER(buffer,@offset)
      m_flddesc    = UI_NEXT(buffer,@offset)
      m_flddispfor = UI_NEXT(buffer,@offset)
      m_fldpict    = UI_NEXT(buffer,@offset)
      m_fldvalid   = UI_NEXT(buffer,@offset)
      m_fldrange   = UI_NEXT(buffer,@offset)
      m_fldinitval = UI_NEXT(buffer,@offset)
      m_fldcalc    = UI_NEXT(buffer,@offset)
      m_fldslot1   = UI_NEXT(buffer,@offset)
      m_fldslot2   = UI_NEXT(buffer,@offset)
      m_fldslot3   = UI_NEXT(buffer,@offset)
      do replmvars
   NEXT
   
   ntxs = UI_INTGER(buffer,@offset)
   IF ntxs > 0
      SELE DBFINDEX
      FOR c = 1 TO ntxs		&&loop while doing indexes
         APPE BLAN
         m_idxname    = UI_NEXT(buffer,@offset)
         m_idxexpr    = UI_NEXT(buffer,@offset)
         m_idxdesc    = UI_NEXT(buffer,@offset)
         m_idxslot1   = UI_NEXT(buffer,@offset)
         m_idxslot2   = UI_NEXT(buffer,@offset)
         m_idxslot3   = UI_NEXT(buffer,@offset)
         do replmvars
      NEXT
   ENDIF
   
   relats = UI_INTGER(buffer,@offset)
   IF relats > 0
      SELE DBFRELAT
      FOR c = 1 TO relats              &&loop while doing relations
         APPE BLAN
         m_relname    = UI_NEXT(buffer,@offset)
         m_relexpr    = UI_NEXT(buffer,@offset)
         m_reldesc    = UI_NEXT(buffer,@offset)
         m_relslot1   = UI_NEXT(buffer,@offset)
         m_relslot2   = UI_NEXT(buffer,@offset)
         m_relslot3   = UI_NEXT(buffer,@offset)
         do replmvars
      NEXT
   ENDIF
   
NEXT
RETURN
**************************************************************************
*!*********************************************************************
*!
*!       Function: UI_INTGER()
*!
*!      Called by: DIC2DBF.PRG                   
*!
*!*********************************************************************
FUNCTION UI_INTGER

PARAMETERS ibuffer, n_offset
PRIVATE two_byte, int

two_byte = SUBSTR(ibuffer,n_offset,2)
n_offset = n_offset + 2
intger   = BIN2I(two_byte)

RETURN intger

**************************************************************************
*!*********************************************************************
*!
*!       Function: UI_NEXT()
*!
*!      Called by: DIC2DBF.PRG                   
*!
*!*********************************************************************
FUNCTION UI_NEXT

PARAMETERS ibuffer, n_offset
PRIVATE nextword, nextchr

nextword = ""
DO WHILE .T.
   nextchr    = SUBSTR(ibuffer,n_offset,1)
   nextword   = nextword + nextchr
   n_offset   = n_offset + 1
   IF nextchr = CHR(0)
      nextword=left(nextword,len(nextword)-1)
      EXIT
   ENDIF
ENDDO

RETURN nextword

***************************************************************************

*!*********************************************************************
*!
*!       Function: COUNTUDBFS()
*!
*!      Called by: DIC2DBF.PRG                   
*!
*!*********************************************************************
FUNCTION COUNTUDBFS

PARAMETERS d_handle

PRIVATE start, lilbuff, numdbfs, m, i

start   = FSEEK(d_handle,0,0)		  && rewind to beginning of the file
lilbuff = SPACE(8)
m       = FREAD(d_handle,@lilbuff,8)
numdbfs = SUBSTR(lilbuff,6,2)   	  && read the 6th, 7th chrs. in file
i       = BIN2I(numdbfs)
RETURN i

*!*********************************************************************
*!
*!      Procedure: CREA_DBFS
*!
*!      Called by: DIC2DBF.PRG                   
*!
*!          Calls: MAKEDBF()      (function  in ?)
*!
*!*********************************************************************
proc crea_dbfs

* make DataBase DBF
*******************
PRIV dbffile[8]

dbffile[1]='DBFNAME,C,20,0'
dbffile[2]='ALIAS,C,20,0'
dbffile[3]='DBFDESC,M,10,0'
dbffile[4]='WORKAREA,N,3,0'
dbffile[5]='DBFFLDCNT,N,4,0'
dbffile[6]='DBFSLOT1,C,255,0'
dbffile[7]='DBFSLOT2,C,255,0'
dbffile[8]='DBFSLOT3,C,255,0'

MAKEDBF("DBFLIST",DBFFILE)


* Make Fields DBF
*****************
PRIV dbffields[15]

dbffields[1]='DBFNAME,C,20,0'
dbffields[2]='FLDNAME,C,10,0'
dbffields[3]='FLDTYPE,C,1,0'
dbffields[4]='FLDLENGTH,N,8,0'
dbffields[5]='FLDDECI,N,8,0'
dbffields[6]='FLDDESC,M,10,0'
dbffields[7]='FLDDISPFRM,C,255,0'
dbffields[8]='FLDPICT,C,255,0'
dbffields[9]='FLDVALID,C,255,0'
dbffields[10]='FLDRANGE,C,255,0'
dbffields[11]='FLDINITVAL,C,255,0'
dbffields[12]='FLDCALC,C,255,0'
dbffields[13]='FLDSLOT1,C,255,0'
dbffields[14]='FLDSLOT2,C,255,0'
dbffields[15]='FLDSLOT3,C,255,0'

MAKEDBF("DBFFIELD",DBFFIELDS)

* make Index DBF
*******************
PRIV dbfindex[7]

dbfindex[1]='DBFNAME,C,20,0'
dbfindex[2]='IDXNAME,C,20,0'
dbfindex[3]='IDXEXPR,C,255,0'
dbfindex[4]='IDXDESC,M,10,0'
dbfindex[5]='IDXSLOT1,C,255,0'
dbfindex[6]='IDXSLOT2,C,255,0'
dbfindex[7]='IDXSLOT3,C,255,0'

MAKEDBF("DBFINDEX",DBFINDEX)

* make Relation DBF
*******************
PRIV dbfrelation[7]

dbfrelation[1]='DBFNAME,C,20,0'
dbfrelation[2]='RELNAME,C,20,0'
dbfrelation[3]='RELEXPR,C,255,0'
dbfrelation[4]='RELDESC,M,10,0'
dbfrelation[5]='RELSLOT1,C,255,0'
dbfrelation[6]='RELSLOT2,C,255,0'
dbfrelation[7]='RELSLOT3,C,255,0'

MAKEDBF("DBFRELAT",DBFRELATION)

RETURN


*: EOF: DIC2DBF.PRG
