/*
** DG_UTIL - version 2.0
**
** The following routines are for monitoring the status of the portion of
** DGROUP which is allocated at run-time, which is known as the the Eval
** Stack and Memvar Table.
**
** Copyright(C) 1993, Robert G. Montgomery.  All Right Reserved.
** 
** You are hereby granted rights to include this function in your application
** programs, free of charge, and if deemed necessary, you may also distribute
** the source for the function with the source for any applications which use
** them, free of charge.
**
** The routines will only work with Clipper version 5.2, but may work with
** later versions as well.
**
** The routines are based on UNDOCUMENTED public variables defined in
** CLIPPER.LIB.  Therefore, they probably will not work in some future
** version of Clipper.  They are provided for use in helping to debug
** applications written in Clipper 5.2.  Do not write programs which depend
** on them, only use them for debugging programs.  It is very possible
** that these routines will work in future versions of Clipper, but it
** would be a bad idea to count on that.
**
** These functions will only work with Clipper 5.2 or later.
*/

#include "extend.api"
#include "item.api"
#include "vm.api"

/*
** declarations of Clipper internal variables defined in CLIPPER.LIB.
*/

extern ITEM _evalhigh; /* 1 - current high water mark for the Eval Stack  */
extern ITEM _estatlow; /* 2 - current low water mark for the Memvar Table */
extern ITEM _eval;     /* 3 - return value from last function call        */
extern ITEM _tos;      /* 4 - current top of Eval Stack                   */
extern ITEM _estat;    /* 5 - current low end of Memvar Table             */
extern ITEM _eextent;  /* 6 - current high end of Memvar Table            */
extern ITEM _lbase;    /* 7 - address of first local variable for current */
                       /*     function/procedure executing                */

/*
** DG_numbers() - returns a 7 element array containing the above DGROUP
** values.  The type ITEM is really a near pointer to a void.  This routine
** returns an array of 7 integers, each integer is the result of type-casting
** the above UNDOCUMENTED near pointer variables to an integer.  Therefore,
** each number is an offset from the beginning of DGROUP.  The numbers are
** inserted into the array in the order listed above.
*/

CLIPPER DG_numbers () {
  ITEM tmp, tmp_arr;
  tmp_arr = _itemArrayNew(7);
  tmp = _itemPutNL(NULL,(USHORT)_evalhigh);
  tmp_arr = _itemArrayPut(tmp_arr,1,tmp);
  tmp = _itemPutNL(tmp,(USHORT)_estatlow);
  tmp_arr = _itemArrayPut(tmp_arr,2,tmp);
  tmp = _itemPutNL(tmp,(USHORT)_eval);
  tmp_arr = _itemArrayPut(tmp_arr,3,tmp);
  tmp = _itemPutNL(tmp,(USHORT)_tos);
  tmp_arr = _itemArrayPut(tmp_arr,4,tmp);
  tmp = _itemPutNL(tmp,(USHORT)_estat);
  tmp_arr = _itemArrayPut(tmp_arr,5,tmp);
  tmp = _itemPutNL(tmp,(USHORT)_eextent);
  tmp_arr = _itemArrayPut(tmp_arr,6,tmp);
  tmp = _itemPutNL(tmp,(USHORT)_lbase);
  tmp_arr = _itemArrayPut(tmp_arr,7,tmp);
  _itemRelease(tmp);
  _itemRelease(_itemReturn(tmp_arr));
  }

/*
** DG_statics - returns an array holding the values all variables defined
** in the Memvar Table, which means all static variables and all values
** associated with all ITEMs defined through ITEM.API.  USE THIS ROUTINE
** ONLY FOR DEBUGGING PURPOSES, do not include it as part of your
** final run-time version of your program, except to use for on-site
** debugging.  This routine is based on UNDOCUMENTED internal information,
** therefore, it may not work in future releases of Clipper.
**
** Note that this routine creates its own static variables which will also
** appear in the list.  Also, there will be some empty slots in the list
** which contain nil values, as well as used slots which contain nil values.
** I have not determined how to tell if a slot is used or not.  I believe
** Clipper maintains a separate table for bookkeeping the allocations and
** deallocations of ITEMS.
*/

CLIPPER DG_statics () {
  ITEM arr;
  USHORT ii, jj = 1;
  ii = (USHORT)_eextent - (USHORT)_estat;
  arr = _itemArrayNew((ii/14)+1);
  for (ii=(USHORT)_eextent;ii>=(USHORT)_estat;ii-=14) {
    if (ii!=(USHORT)arr) 
      arr = _itemArrayPut(arr,jj,(ITEM)ii);
    jj++;
    }
  _itemRelease(_itemReturn(arr));
  }

/*
** DG_statHex - returns an array holding a HEX representation of the 14
** bytes which are stored in DGROUP for all static variables and ITEMs
** currently allocated to a program, which are defined in the Memvar Table.
** USE THIS ROUTINE ONLY FOR DEBUGGING PURPOSES, do not include it as part
** of your final run-time version of your program, except to use for on-site
** debugging.  The routine is based on UNDOCUMENTED 
**
** Note that this routine creates its own static variables which will also
** appear in the list.  Also, there will be some empty slots in the list
** which contain nil values, as well as used slots which contain nil values.
** I have not determined how to tell if a slot is used or not.  I believe
** Clipper maintains a separate table for bookkeeping the allocations and
** deallocations of ITEMS.
*/

unsigned char dg_hex(BYTE x) {
  if (x>=10)
    return 55+x;
  else
    return 48+x;
  }

CLIPPER DG_statHex () {
  ITEM arr, tmp, iptr;
  USHORT ii, jj = 1, kk;
  unsigned char _near * ptr;
  HANDLE buffhandl;
  BYTEP tmpbuff;
  ii = (USHORT)_eextent - (USHORT)_estat;
  arr = _itemArrayNew((ii/14)+1);
  tmp = _itemNew(NULL);
  buffhandl = _xvalloc(28,0);
  tmpbuff = _xvlock(buffhandl);
  for (iptr=_eextent;iptr>_estat;(unsigned char _near *)iptr-=14) {
    if (iptr!=arr&&iptr!=tmp) {
      ptr = (unsigned char _near *)iptr;
      for (kk=0;kk<14;kk++) {
        tmpbuff[kk*2]=dg_hex((*ptr)>>4);
        tmpbuff[kk*2+1]=dg_hex((*ptr++)&0xF);
        }
      arr = _itemArrayPut(arr,jj,tmp=_itemPutCL(tmp,tmpbuff,28));
      }
    jj++;
    }
  _itemRelease(_itemReturn(arr));
  _itemRelease(tmp);
  _xvunlock(buffhandl);
  _xvfree(buffhandl);
  }
