/*
 * display.c
 *
 * Copyright 1991 by Taylor Data Services
 *
 */


#include "extend.h"
#include "keys.h"
#include "display.ch"
#include "inkey.ch"


#define MK_FP(seg, ofs) ((void far *) (((unsigned long)(seg) << 16) | (unsigned)(ofs)))
#define FP_SEG(fp) (*((unsigned *)&(fp) + 1))   // copied from MSC 5.1
#define FP_OFF(fp) (*((unsigned *)&(fp)))       //  include file 'dos.h'

#define OFF 0
#define ON  (!OFF)
#define NO  0
#define YES (!NO)
#define OK  0

#define CR   ((char) 13)
#define LF   ((char) 10)
#define FEOF ((char) 26)

#define SEEK_END 2              // file seek directions
#define SEEK_CUR 1
#define SEEK_SET 0

long buffoffset;                // offset into buffer of current line
long fsize;                     // file size in bytes
long ftop;                      // top byte of file (=0 if rowlock = 0)
long bmark[9];                  // bookmark storage array
int  botbyte;                   // last byte of row lock buffer
int  bufftop, buffbot;          // first and last character in buffer
int  wintop, winbot;            // first and last character in window
int  winrow, wincol;            // row and column of window highlight
int  sline, eline;              // start and end line of window
int  scol, ecol;                // start and end col of window
int  height, width;             // height and width of window
int  swidth;                    // screen width
int  infile;                    // input file handle
int  maxlin;                    // line size
int  buffsize;                  // buffer size
int  collock;                   // number of columns to lock
int  rowlock;                   // number of rows at top of buffer to lock
int  hlight;                    // highlight color
int  norm;                      // normal color
int  colinc;                    // number of columns to increment for left/right
int  brows;                     // browse mode, YES means no highlight bar
int  scrollbar;                 // scroll bar mode
int  scrollback;                // scroll bar background
int  scrollchar;                // scroll bar character
int  scrollpos;                 // scroll bar pos
int  ctable[8];                 // color table for '^' switches
int  cflags[11];                // is color on or off

int  cstack[MAXCOLORS];
int  ctop;

char refresh;                   // YES means refresh screen

char far *buffer;               // file buffer pointer
char far *lbuff;                // line buffer pointer
char far *rbuff;                // locked rows buffer
char far *vseg;                 // video segment variable

int *sb;                        // array of line widths for scroll bar routines

    // prototypes


CLIPPER df_init(void);
CLIPPER df_exec(void);
CLIPPER df_extract(void);

int  pop_color(void);
void push_color(int);
void clr_color(void);

int  keyin(void);
void chattr(int x, int y, int len, int attr);
int  highlight(int x, int y, int len, int attr, int brows);
long getblock(long offset);
void buff_align(void);
void win_align(void);
void disp_update(int offset);
void disp_lines(char far * buff, int height, int offset, int sline, int bbot);
int  chk_attr(int c);
void windown(void);
void winup(void);
void linedown(void);
void lineup(void);
void filetop(void);
void filebot(void);
long getmark(void);
void gotomark(long);
void showbar(void);
void loadvars(void);
void savevars(void);

    // found in dispsub.asm

int        d_fileread(int handle, char far *buffer, int bytes);
long       d_fileseek(int handle, long offset, int direction);
long       d_filepos(int handle);
void       d_gotoxy(int x, int y);
char       d_getkey(void);
char far * d_vconfig(void);

    // this is defined because I found out that CLIPPER has a version
    //   strcpy linked in normally - this just shut's up the LINT check

extern char *strcpy(char far *, char far *);



CLIPPER df_extract()
{
    int i  = 0;
    int p  = 0;
    int r  = 0;
    int c  = 0;
    int wt = 0;
    int wb = 0;

    char far * b;


    r  = _parni(1);     // desired row
    b  = _parc(2);      // buffer pointer
    wt = _parni(3);     // window's first char position in buffer
    wb = _parni(4);     // window's last char position in buffer

    for (i = wt; i <= wb; i++)
    {
        if ( c == r )
        {
            if ( b[i] == LF )
               i += 1;

            for (p = i; p <= wb; p++)
                if ( b[p] == CR )
                    break;

            break;
        }
        else
        {
            if ( b[i] == CR )
                c += 1;
        }
    }

    i += 1;
    p += 1;

    _storni(i, 5, 1);
    _storni((p - i), 5, 2);
}





int pop_color()
{
    if ( ctop > 0 )
        return (cstack[ctop--]);
    else
        return (norm);
}





void push_color(int c)
{
   if ( ctop < MAXCOLORS )
   {
      cstack[ctop] = c;

      ctop += 1;
   }
}





void clr_color()
{
    int i;

    for (i = 0; i < MAXCOLORS; i++)
        cflags[i] = OFF;

    ctop = 0;
}





/*
 * chattr() replace the color attribute with a new one starting at
 * location x, y and going for length len.
 *
 */

void chattr(int x, int y, int len, int attr)
{
    int i;
    char far *vmem;

    vmem = vseg;

    FP_OFF(vmem) = (y * swidth) + (x * 2) + 1;     // calc the screen memory coord

    for (i = 0; i <= len; i++, vmem += 2)       // write the new attribute value
        *vmem = (char) attr;
}




/*
 * highlight() will show the highlight on the screen if brows mode is NO
 * it also save the current line's attributes so that it can de-highlight
 * it after it gets the user's key
 *
 */

int highlight(int x, int y, int len, int hlight, int brows)
{
    int  i;
    int  ch;
    char far *vmem;
    char far *p;

    vmem = vseg;

    FP_OFF(vmem) = (y * swidth) + (x * 2) + 1;
    p            = vmem;

    if ( brows == NO )
        for (i = 0; i <= len; i++, vmem += 2)
        {
            lbuff[i] = *vmem;

            *vmem = (char) hlight;
        }

    d_gotoxy(scol, winrow);

    ch = keyin();

    vmem = p;

    if ( brows == NO )
        for (i = 0; i <= len; i++, vmem += 2)
            *vmem = lbuff[i];

    return (ch);
}





/*
 *  keyin() gets the next key typed and does any translation needed.
 *  Some keys are converted to a common name - like the up arrow is
 *  converted to the UP value which also is the Ctrl-E value.  This
 *  allows the Wordstar-like control keys to be used.  Only extended
 *  keys are translated - the values of the defines were chosen to
 *  match up with the non-extended key codes.
 *
 */

int keyin()
{
    int  ch;
    char k;

    k = d_getkey();                        // get the next key

    if ( k == 0x00 )                       // check to see if it's extended
    {
        k = d_getkey();                    // if so, read the second part

        switch ( k )                       //  and convert it
        {
            case 75   : ch = K_LEFT;        break;
            case 77   : ch = K_RIGHT;       break;
            case 72   : ch = K_UP;          break;
            case 80   : ch = K_DOWN;        break;
            case 71   : ch = K_HOME;        break;
            case 79   : ch = K_END;         break;
            case 73   : ch = K_PGUP;        break;
            case 81   : ch = K_PGDN;        break;
            case 62   : ch = K_F4;          break;
            case 117  : ch = K_CTRL_END;    break;
            case 119  : ch = K_CTRL_HOME;   break;
            case 118  : ch = K_CTRL_PGDN;   break;
//          case 132  : ch = K_CTRL_PGUP;   break;
            case -124 : ch = K_CTRL_PGUP;   break;
            case 116  : ch = K_CTRL_RIGHT;  break;
            case 115  : ch = K_CTRL_LEFT;   break;
            case 82   : ch = K_INS;         break;
            case 83   : ch = K_DEL;         break;
            case 68   : ch = K_F10;         break;
            case 59   : ch = K_F1;          break;
            case 60   : ch = K_F2;          break;
            case 61   : ch = K_F3;          break;
            case 63   : ch = K_F5;          break;
            case 64   : ch = K_F6;          break;
            case 65   : ch = K_F7;          break;
            case 66   : ch = K_F8;          break;
            case 67   : ch = K_F9;          break;
            case 113  : ch = K_ALT_F10;     break;
            case 104  : ch = K_ALT_F1;      break;
            case 105  : ch = K_ALT_F2;      break;
            case 106  : ch = K_ALT_F3;      break;
            case 107  : ch = K_ALT_F4;      break;
            case 108  : ch = K_ALT_F5;      break;
            case 109  : ch = K_ALT_F6;      break;
            case 110  : ch = K_ALT_F7;      break;
            case 111  : ch = K_ALT_F8;      break;
            case 112  : ch = K_ALT_F9;      break;
            case 94   : ch = K_CTRL_F1;     break;
            case 95   : ch = K_CTRL_F2;     break;
            case 96   : ch = K_CTRL_F3;     break;
            case 97   : ch = K_CTRL_F4;     break;
            case 98   : ch = K_CTRL_F5;     break;
            case 99   : ch = K_CTRL_F6;     break;
            case 100  : ch = K_CTRL_F7;     break;
            case 101  : ch = K_CTRL_F8;     break;
            case 102  : ch = K_CTRL_F9;     break;
            case 103  : ch = K_CTRL_F10;    break;
            case 120  : ch = K_ALT_1;       break;
            case 121  : ch = K_ALT_2;       break;
            case 122  : ch = K_ALT_3;       break;
            case 123  : ch = K_ALT_4;       break;
            case 124  : ch = K_ALT_5;       break;
            case 125  : ch = K_ALT_6;       break;
            case 126  : ch = K_ALT_7;       break;
            case 127  : ch = K_ALT_8;       break;
//          case 128  : ch = K_ALT_9;       break;
            case -128 : ch = K_ALT_9;       break;
//          case 129  : ch = K_ALT_0;       break;
            case -127 : ch = K_ALT_0;       break;
            case 30   : ch = K_ALT_A;       break;
            case 48   : ch = K_ALT_B;       break;
            case 46   : ch = K_ALT_C;       break;
            case 32   : ch = K_ALT_D;       break;
            case 18   : ch = K_ALT_E;       break;
            case 33   : ch = K_ALT_F;       break;
            case 34   : ch = K_ALT_G;       break;
            case 35   : ch = K_ALT_H;       break;
            case 23   : ch = K_ALT_I;       break;
            case 36   : ch = K_ALT_J;       break;
            case 37   : ch = K_ALT_K;       break;
            case 38   : ch = K_ALT_L;       break;
            case 50   : ch = K_ALT_M;       break;
            case 49   : ch = K_ALT_N;       break;
            case 24   : ch = K_ALT_O;       break;
            case 25   : ch = K_ALT_P;       break;
            case 16   : ch = K_ALT_Q;       break;
            case 19   : ch = K_ALT_R;       break;
            case 31   : ch = K_ALT_S;       break;
            case 20   : ch = K_ALT_T;       break;
            case 22   : ch = K_ALT_U;       break;
            case 47   : ch = K_ALT_V;       break;
            case 17   : ch = K_ALT_W;       break;
            case 45   : ch = K_ALT_X;       break;
            case 21   : ch = K_ALT_Y;       break;
            case 44   : ch = K_ALT_Z;       break;
            default   : ch = 0;             break;
        }
    }
    else
        ch = k;

    return (ch);
}





/*
 * function getblock() reads the text file and returns the a block.
 *  the variables offset and buffsize tell it where to start reading and
 *  how many bytes to try to read.  if the block read in would not fill
 *  the buffer then the offset is adjusted so that the start or end of
 *  of the file is positioned at the head or tail of the buffer.
 *
 * it returns the offset into the file of the first byte of the buffer.
 *
 */

long getblock(long offset)
{

        // set the file pointer to the proper offset
        //  and if an error occured then check to see
        //  if a positive offset was requested, if so
        //  then set the pointer to the offset from
        //  the end of the file, otherwise set it from
        //  the beginning of the file.

    d_fileseek(infile, offset, SEEK_SET);

        // read in the file and set the buffer bottom variable equal
        //  to the number of bytes actually read in.

    buffbot = d_fileread(infile, buffer, buffsize);

        // if a full buffer's worth was not read in, make it full.

    if (( buffbot != buffsize ) && ( fsize > buffsize ))
    {
        if ( offset > 0 )
            d_fileseek(infile, (long) -buffsize, SEEK_END);
        else
            d_fileseek(infile, (long) buffsize, SEEK_SET);

        buffbot = d_fileread(infile, buffer, buffsize);
    }

        // return the actual file position */

    return (d_filepos(infile) - buffbot);
}





/*
 * buff_align makes sure the buffer top and bottom variables point
 * to actual complete lines of text.
 *
 */

void buff_align()
{
    int i;

    buffbot = buffsize;

    if ( buffoffset == ftop )       // if the buffoffset == top of file
    {
        bufftop = 0;
    }
    else
    {
        i = 0;                      // start at the top of the buffer and
                                    // scan forward until a CR is reached.

        while (( buffer[i] != CR ) && ( i < buffbot ))
            i++;

        bufftop = i + 2;            // skip past the CR/LF to the first char
    }


        // if the buffer offset is not a complete */
        // buffer's length away from the file end */

    if ( buffoffset + ((long) buffbot) != fsize )
    {
            // if the file position of the last byte
            //  of the buffer would end up past the
            //  end of the file, then the buffer does
            //  contain a complete buffer full and the
            //  buffer end pointer needs to be set to
            //  the last character of the file.

        if ( buffoffset + ((long) buffbot) > fsize )
            buffbot = (int) (fsize - buffoffset);

        i = buffbot;                // point the end of the buffer to a valid
                                    // complete text line.

        while (( buffer[i] != CR ) && ( i > bufftop ))
            i--;

        buffbot = i + 2;            // skip past the CR/LF to the first char
    }
}





/*
 * win_align takes the value for wintop and then figures out where
 * winbot would be.  if winbot would extend past the end of the
 * buffer, then the top of the window is adjusted to ensure that a full
 * screen of text will appear.  This simplifies the cursor routines.
 *
 */

void win_align()
{
    int i;

    winbot = wintop;                // find out if there is enough text for
    i      = 0;                     // full window.

    while (( winbot < buffbot ) && ( i < height ))
    {
        if ( buffer[winbot] == CR )
            i++;
        winbot++;
    }

    if ( i < height )                       // if there is not a full window,
    {
        while ( buffer[winbot] != LF )      // then retrofit winbot
            winbot--;                       // to the end of a line

        wintop = winbot;
        i        = 0;                       // and setup wintop

        while (( wintop > bufftop ) && ( i <= height ))
        {
            if ( buffer[wintop] == LF )
                i++;
            wintop--;
        }

        if ( wintop != bufftop )
            wintop += 2;
    }
}





/*
 * this routine displays the actual text in the window.  This is done
 * by taking each line and placing it in a string.  the screen line
 * is then taken from the appropriate group of characters in the string.
 * this allows a window to page left-right across the buffer without
 * having to use any complex algorithm to calc the needed chars.
 *
 * calls disp_lines() to do all of the dirty work.
 *
 */

void disp_update(int offset)
{
    refresh = NO;

    if ( rowlock != 0 )
        disp_lines(rbuff, rowlock, 0, sline - rowlock, botbyte);

    disp_lines(buffer, height, offset, sline, winbot);
}





/*
 * workhorse for disp_update()
 *
 */

void disp_lines(char far * buff, int height, int offset, int sline, int bbot)
{
    int line, i, j;
    int count;
    int attr;
    char c;
    char far *vmem;

    vmem  = vseg;
    line  = 0;
    count = 0;

    while ( line < height )
    {
            // calculate the initial position, this save execution
            // time because each column is considered as a offset
            // from the line start

        FP_OFF(vmem) = ((sline + line) * swidth) + (scol * 2);

        clr_color();    // clear color stack

        attr = norm;

        for (i = 0, j = 0; buff[offset] != CR && offset <= bbot; count++)
        {
            c = buff[offset++];

            switch (c)
            {
                case 15  :  push_color(attr);
                            attr = buff[offset++];
                            break;

                case 14  :  attr = pop_color();
                            break;

                case '^' :  if ( (c = buff[offset]) == '^' )
                                offset += 1;
                            else
                            {
                                switch (c)
                                {
                                    case 'N' :  attr = norm;
                                                offset += 1;
                                                break;

                                    case 'B' :  if ( cflags[BOLD] == ON )
                                                {
                                                    attr = pop_color();

                                                    cflags[BOLD] = !cflags[BOLD];
                                                }
                                                else
                                                {
                                                    push_color(attr);

                                                    attr = ctable[BOLD];

                                                    cflags[BOLD] = !cflags[BOLD];
                                                }
                                
                                                offset += 1;
                                                break;

                                    case 'U' :  if ( cflags[UNDER] == ON )
                                                {
                                                    attr = pop_color();

                                                    cflags[UNDER] = !cflags[UNDER];
                                                }
                                                else
                                                {
                                                    push_color(attr);

                                                    attr = ctable[UNDER];

                                                    cflags[UNDER] = !cflags[UNDER];
                                                }


                                                offset += 1;
                                                break;

                                    case '1' :  if ( cflags[G1] == ON )
                                                {
                                                    attr = pop_color();

                                                    cflags[G1] = !cflags[G1];
                                                }
                                                else
                                                {
                                                    push_color(attr);

                                                    attr = ctable[G1];

                                                    cflags[G1] = !cflags[G1];
                                                }
                                
                                                offset += 1;
                                                break;

                                    case '2' :  if ( cflags[G2] == ON )
                                                {
                                                    attr = pop_color();

                                                    cflags[G2] = !cflags[G2];
                                                }
                                                else
                                                {
                                                    push_color(attr);

                                                    attr = ctable[G2];

                                                    cflags[G2] = !cflags[G2];
                                                }
                                
                                                offset += 1;
                                                break;

                                    case '3' :  if ( cflags[G3] == ON )
                                                {
                                                    attr = pop_color();

                                                    cflags[G3] = !cflags[G3];
                                                }
                                                else
                                                {
                                                    push_color(attr);

                                                    attr = ctable[G3];

                                                    cflags[G3] = !cflags[G3];
                                                }
                                
                                                offset += 1;
                                                break;

                                    case '4' :  if ( cflags[G4] == ON )
                                                {
                                                    attr = pop_color();

                                                    cflags[G4] = !cflags[G4];
                                                }
                                                else
                                                {
                                                    push_color(attr);

                                                    attr = ctable[G4];

                                                    cflags[G4] = !cflags[G4];
                                                }
                                
                                                offset += 1;
                                                break;

                                    case '5' :  if ( cflags[G5] == ON )
                                                {
                                                    attr = pop_color();

                                                    cflags[G5] = !cflags[G5];
                                                }
                                                else
                                                {
                                                    push_color(attr);

                                                    attr = ctable[G5];

                                                    cflags[G5] = !cflags[G5];
                                                }
                                
                                                offset += 1;
                                                break;

                                    case 'I' :  if ( cflags[HIGH] == ON )
                                                    attr = pop_color();
                                                else
                                                {
                                                    push_color(attr);

                                                    attr = (attr | 8);
                                                }

                                                cflags[HIGH] = !cflags[HIGH];

                                                offset += 1;
                                                break;

                                    case 'F' :  if ( cflags[FLASH] == ON )
                                                    attr = pop_color();
                                                else
                                                {
                                                    push_color(attr);

                                                    attr = (attr | 128);
                                                }

                                                cflags[FLASH] = !cflags[FLASH];

                                                offset += 1;
                                                break;
                                }

                                break;
                            }
                            
                default  :  if (( collock != 0 && i < collock ) || 
                                ( i >= wincol && i <= wincol + width - collock ))
                            {
                                *vmem++ = c;
                                *vmem++ = (char) attr;
                                j      += 1;
                            }

                            i += 1;
            }
        }

        sb[line] = count;

        for (; j <= width; j++)
        {
            *vmem++ = ' ';
            *vmem++ = (char) attr;
        }

        line   += 1;
        offset += 2;
        count  += 2;
    }
}




void winup()
{
    int k;
    long i, j;

    refresh = YES;
    k       = wintop - 3;

    while (( buffer[k] != CR ) && ( k > bufftop ))
        k--;

    d_gotoxy(0, 44);

    if ( k >= bufftop )
    {
        if ( buffer[k] == CR )
            k += 2;

        wintop = k;
        k      = winbot - 3;

        while ( buffer[k] != CR )
            k--;

        winbot = k + 2;
    }
    else
        if ( ((long) bufftop) + buffoffset > ftop && fsize > buffsize )
        {
            i = buffoffset + wintop;
            j = buffoffset - ((long) (buffsize / 2));

            if ( j < ftop )
                j = ftop;

            buffoffset = getblock(j);
            wintop     = ((int) (i - buffoffset));

            buff_align();
            win_align();

            winup();
        }
        else
            wintop = 0;
}





void windown()
{
    int k;
    long i, j;

    refresh = YES;
    k       = winbot;

    while (( buffer[k] != CR ) && ( k <= buffbot ))
        k++;

    k += 2;

    if ( k <= buffbot )
    {
        winbot = k;
        k      = wintop;

        while ( buffer[k] != CR )
            k++;

        wintop = k + 2;
    }
    else
        if ( (((long) buffbot) + buffoffset) < fsize && fsize > buffsize)
        {
            i = buffoffset + wintop;
            j = i;

            if ( j > fsize )
                j = fsize - ((long) buffsize);

            buffoffset = getblock(j);

            if ( i < buffoffset )
                wintop = 0;
            else
                wintop = ((int) (i - buffoffset));

            buff_align();
            win_align();

            windown();
        }
}





/* move the cursor one lime down */

void linedown()
{
    if ( winrow < eline )       // if cursor not at last line
        winrow += 1;
    else                        // otherwise adjust the window top variable
        windown();
}





/* move the cursor one line up */

void lineup()
{
    if ( winrow > sline )
        winrow -= 1;
    else
        winup();
}





/* go to the top of the file */

void filetop()
{
    getblock(ftop);

    refresh    = YES;
    buffoffset = ftop;
    wintop     = 0;
    winrow     = sline;
    wincol     = collock;

    buff_align();
    win_align();
}





/* goto the bottom of the file */

void filebot()
{
    if ( (((long) buffbot) + buffoffset) < fsize && fsize > buffsize )
    {
        buffoffset = getblock(fsize + 1);

        buff_align();
    }

    refresh = YES;
    wintop  = buffbot - 3;
    winrow  = eline;
    wincol  = collock;

    win_align();
}




/*
void gotomark(long pos)
{
    if ( pos > (buffoffset + buffbot) || pos < buffoffset )
        buffoffset = getblock(pos);

    refresh = YES;
    bufftop = 0;
    buffbot = buffsize;
    winbot  = buffbot;
    winrow  = sline;
    wincol  = collock;

    if ( pos > buffoffset )
        wintop = ((int) (pos - buffoffset));
    else
        wintop = (int) ftop;

    buff_align();
    win_align();

    if ( wintop != bufftop && buffoffset == 0 )
        wintop -= 2;

    if ( scrollbar == YES )
        showbar();
}





long getmark()
{
    int i, l;

    for (i = wintop, l = sline; l < winrow; i++)
        if ( buffer[i] == CR )
            l++;

    if ( wintop == (int) ftop )
        i -= 1;

    return ( buffoffset + i + 1 );
}
*/




void showbar()
{
    int i;
    double d;

    if ( scrollpos >= 0 )
    {
        FP_OFF(vseg) = ((sline + scrollpos + 1) * swidth) + ((ecol + 1) * 2);

        *vseg = (char) scrollback;
    }

    d = (double) (buffoffset + (long) wintop + (long) sb[winrow - sline]);

    d = d / (double) fsize;

    d = (height - 2) * d;

    i = (int) d;

    if ( i > ( height - 3 ) )
        i = height - 3;

    FP_OFF(vseg) = ((sline + i + 1) * swidth) + ((ecol + 1) * 2);

    *vseg = (char) scrollchar;

    scrollpos = i;
}





void loadvars()
{
    int i;

    infile     = _parni(1, HANDLE);
    sline      = _parni(1, TOP);
    scol       = _parni(1, LEFT);
    eline      = _parni(1, BOTTOM);
    ecol       = _parni(1, RIGHT);
    height     = _parni(1, HEIGHT);
    width      = _parni(1, WIDTH);
    norm       = _parni(1, NORMAL);
    hlight     = _parni(1, HIGHLIGHT);
    colinc     = _parni(1, COLSKIP);
    maxlin     = _parni(1, RMARGIN);
    buffsize   = _parni(1, BUFFSIZE);
    collock    = _parni(1, COLLOCK);
    rowlock    = _parni(1, ROWLOCK);
    scrollback = _parni(1, SCROLLBACK);
    scrollchar = _parni(1, SCROLLCHAR);
    scrollpos  = _parni(1, SCROLLPOS);
    bufftop    = _parni(1, BUFFTOP);
    buffbot    = _parni(1, BUFFBOT);
    buffoffset = _parnl(1, BUFFOFFSET);
    winrow     = _parni(1, WINROW);
    wincol     = _parni(1, WINCOL);
    wintop     = _parni(1, WINTOP);
    winbot     = _parni(1, WINBOT);
    botbyte    = _parni(1, BOTBYTE);
    ftop       = _parnl(1, FTOP);
    fsize      = _parnl(1, FSIZE);

    scrollbar  = _parl(1, SCROLL);
    brows      = _parl(1, BROWSE);

    buffer     = _parc(1, BUFFER);
    lbuff      = _parc(1, LBUFFER);
    rbuff      = _parc(1, RBUFFER);

    swidth     = _parni(3) * 2;

    ctable[BOLD]  = _parni(1, CBOLD);
    ctable[UNDER] = _parni(1, CUNDER);

    cflags[BOLD]  = _parl(1, FBOLD);
    cflags[UNDER] = _parl(1, FUNDER);
    cflags[HIGH]  = _parl(1, FHIGH);
    cflags[FLASH] = _parl(1, FFLASH);
    cflags[G1]    = _parl(1, FG1);
    cflags[G2]    = _parl(1, FG2);
    cflags[G3]    = _parl(1, FG3);
    cflags[G4]    = _parl(1, FG4);
    cflags[G5]    = _parl(1, FG5);

    for (i = 1; i < 10; i++)
        bmark[i - 1] = _parnl(2, i);
}





void savevars()
{
    int i;

    _storni(bufftop,    1, BUFFTOP);
    _storni(buffbot,    1, BUFFBOT);
    _stornl(buffoffset, 1, BUFFOFFSET);
    _storni(winrow,     1, WINROW);
    _storni(wincol,     1, WINCOL);
    _storni(wintop,     1, WINTOP);
    _storni(winbot,     1, WINBOT);
    _storni(botbyte,    1, BOTBYTE);
    _storni(scrollpos,  1, SCROLLPOS);
    _stornl(ftop,       1, FTOP);

    _storl(cflags[BOLD],  1, FBOLD);
    _storl(cflags[UNDER], 1, FUNDER);
    _storl(cflags[G1],    1, FG1);
    _storl(cflags[G2],    1, FG2);
    _storl(cflags[G3],    1, FG3);
    _storl(cflags[G4],    1, FG4);
    _storl(cflags[G5],    1, FG5);
    _storl(cflags[HIGH],  1, FHIGH);
    _storl(cflags[FLASH], 1, FFLASH);

    for (i = 1; i < 10; i++)
        _stornl(bmark[i - 1], 2, i);
}





CLIPPER df_init()
{
    int i, j;

    loadvars();

    getblock(0L);

    if ( rowlock != 0 )
    {
        for (i = 0, j = 0; j < rowlock; i++)
        {
            rbuff[i] = buffer[i];

            if ( buffer[i] == LF )
                j++;
        }

        botbyte = i;
        ftop    = i;
    }

    getblock(ftop);

    buffoffset = ftop;

    buff_align();
    win_align();

    if ( rowlock != 0 )
        for (j = 0; j < rowlock; j++)
            linedown();

    _stornl(buffoffset, 1, BUFFOFFSET);
    _stornl(ftop,       1, FTOP);
    _storni(i,          1, BOTBYTE);
    _storni(bufftop,    1, BUFFTOP);
    _storni(buffbot,    1, BUFFBOT);
    _storni(winrow,     1, WINROW);
    _storni(wincol,     1, WINCOL);
    _storni(wintop,     1, WINTOP);
    _storni(winbot,     1, WINBOT);
}





CLIPPER df_exec()
{
    int i, done;
    int ch;

    vseg    = MK_FP(d_vconfig(), 0x0000);
    done    = NO;
    refresh = YES;
    ch      = 0;

    loadvars();

    sb = _xalloc((height + 1) * 2);

        // main processing loop -- terminated by user key press

    if ( _parni(4) == DRAWSCREEN )
    {
            // draw inside of window with normal color attribute

        for (i = sline - rowlock; i <= eline; i++)
            chattr(scol, i, width, norm);

            // draw initial text

        disp_update(wintop);

            // initialize scroll bar

        if ( scrollbar == YES )
        {
            for (i = 1; i < height - 1; i++)
            {
                FP_OFF(vseg) = ((sline + i) * swidth) + ((ecol + 1) * 2);

                *vseg = (char) scrollback;
            }

            showbar();
        }
    }
    else
    {
        do
        {
            if ( refresh == YES )
                disp_update(wintop);

                // highlight the current line and get the user's key

            ch = highlight(scol, winrow, width, hlight, brows);

                // figure out what the user wants to do

            switch ((char) ch)
            {
                case K_DOWN       : if ( brows == YES )
                                        winrow = eline;

                                    linedown();

                                    if ( scrollbar == YES )
                                        showbar();

                                    break;

                case K_UP         : if ( brows == YES )
                                        winrow = sline;

                                    lineup();

                                    if ( scrollbar == YES )
                                        showbar();

                                    break;

                case K_LEFT       : wincol -= colinc;
                                    refresh = YES;

                                    if ( wincol < collock )
                                        wincol = collock;

                                    break;

                case K_RIGHT      : wincol += colinc;
                                    refresh = YES;

                                    if ( wincol > (maxlin - width) )
                                        wincol = maxlin - width;

                                    break;

                case K_HOME       : wincol  = collock;
                                    refresh = YES;
                                    break;

                case K_END        : wincol  = maxlin - width;
                                    refresh = YES;
                                    break;

                case K_CTRL_LEFT  : wincol -= 16;
                                    refresh = YES;

                                    if ( wincol < collock )
                                        wincol = collock;

                                    break;

                case K_CTRL_RIGHT : wincol += 16;
                                    refresh = YES;

                                    if ( wincol > (maxlin - width) )
                                        wincol = maxlin - width;

                                    break;

                case K_PGUP       : for (i = 0; i < height; i++)
                                        winup();

                                    if ( scrollbar == YES )
                                        showbar();

                                    break;

                case K_PGDN       : for (i = 0; i < height; i++)
                                        windown();

                                    if ( scrollbar == YES )
                                        showbar();

                                    break;

                case K_CTRL_PGUP  : filetop();

                                    if ( scrollbar == YES )
                                        showbar();

                                    break;

                case K_CTRL_PGDN  : filebot();

                                    if ( scrollbar == YES )
                                        showbar();

                                    break;
/*
                case ALTM  : ch = (keyin() - 49);

                            if ( ch >= 0 && ch < 9 )
                                bmark[ch] = getmark();

                            break;

                case ALT1  : gotomark(bmark[0]);
                            break;

                case ALT2  : gotomark(bmark[1]);
                            break;

                case ALT3  : gotomark(bmark[2]);
                            break;

                case ALT4  : gotomark(bmark[3]);
                            break;

                case ALT5  : gotomark(bmark[4]);
                            break;

                case ALT6  : gotomark(bmark[5]);
                            break;

                case ALT7  : gotomark(bmark[6]);
                            break;

                case ALT8  : gotomark(bmark[7]);
                            break;

                case ALT9  : gotomark(bmark[8]);
                            break;
*/
                default    : done = YES;
            }
        } while ( done == NO );
    }

    savevars();

    _xfree(sb);

        // return key value to Clipper

    _retni(ch);
}
