/*
 * dispfile.prg
 *
 * Copyright 1991 by Taylor Data Services
 *
 */

#include "fileio.ch"
#include "display.ch"
#include "inkey.ch"

static aStack := {}




function DF_Setup(cInFile, nTop, nLeft, nBottom, nRight,;
                  nCNormal, nCHighlight, lBrowse,;
                  nColSkip, nRMargin, nBuffSize,;
                  nColLock, nRowLock, aColors,;
                  lScroll, xScrollBack, xScrollChar )

local rval  := 0
local i     := 0
local aTemp := Array(SLEN)


if ( (ValType(cInFile) == "C") .and. File(cInFile) )
//  aTemp[BOOKMARKS] := { 0, 0, 0, 0, 0, 0, 0, 0, 0 }
    aTemp[BOOKMARKS] := NIL

    aTemp[TOP]     := if(ValType(nTop)     == "N", nTop,           0)
    aTemp[LEFT]    := if(ValType(nLeft)    == "N", nLeft,          0)
    aTemp[BOTTOM]  := if(ValType(nBottom)  == "N", nBottom, MaxRow())
    aTemp[RIGHT]   := if(ValType(nRight)   == "N", nRight,  MaxCol())
    aTemp[COLSKIP] := if(ValType(nColSkip) == "N", nColSkip,       1)
    aTemp[BROWSE]  := if(ValType(lBrowse)  == "L", lBrowse,      .F.)
    aTemp[SCROLL]  := if(ValType(lScroll)  == "L", lScroll,      .F.)

    if ( ValType(nCNormal) == "C" )
        nCNormal := DF_Convert(nCNormal)
    else
        if ( ValType(nCNormal) != "N" )
            nCNormal := DF_Convert(SetColor())
        endif
    endif
            
    aTemp[NORMAL] := nCNormal

    if ( ValType(nCHighlight) == "C" )
        nCHighlight := DF_Convert(nCHighlight)
    else
        if ( ValType(nCHighlight) != "N" )
            nCHighlight := DF_Convert(SetColor())
        endif
    endif

    aTemp[HIGHLIGHT] := nCHighlight

    if ( ValType(xScrollBack) == "C" )
        aTemp[SCROLLBACK] := Asc(xScrollBack)
    else
        if ( ValType(xScrollBack) != "N" )
            aTemp[SCROLLBACK] := 176
        endif
    endif

    if ( ValType(xScrollChar) == "C" )
        aTemp[SCROLLCHAR] := Asc(xScrollChar)
    else
        if ( ValType(xScrollChar) != "N" )
            aTemp[SCROLLCHAR] := 177
        endif
    endif

    aTemp[SCROLLPOS] := -1

    aTemp[RMARGIN]  := if(ValType(nRMargin)  == "N", nRMargin, MAXLINE)
    aTemp[BUFFSIZE] := if(ValType(nBuffSize) == "N", nBuffSize, BUFFERSIZE)

    nColLock        := if(ValType(nColLock)  == "N", nColLock, 0)
    nRowLock        := if(ValType(nRowLock)  == "N", nRowLock, 0)

    aTemp[COLLOCK]  := MIN(nColLock, (aTemp[RIGHT] - aTemp[LEFT]))
    aTemp[ROWLOCK]  := MIN(nRowLock, (aTemp[BOTTOM] - aTemp[TOP]))

    if ( aTemp[ROWLOCK] != 0 )
        aTemp[TOP] += aTemp[ROWLOCK]
    endif

    aTemp[WIDTH]    := aTemp[RIGHT] - aTemp[LEFT]
    aTemp[HEIGHT]   := aTemp[BOTTOM] - aTemp[TOP] + 1

    aTemp[BUFFTOP]    := 0
    aTemp[BUFFBOT]    := aTemp[BUFFSIZE]
    aTemp[BUFFOFFSET] := 0
    aTemp[WINROW]     := aTemp[TOP] - aTemp[ROWLOCK]
    aTemp[WINCOL]     := aTemp[COLLOCK]
    aTemp[WINTOP]     := 0
    aTemp[WINBOT]     := 0
    aTemp[FTOP]       := 0

    if ( ValType(aColors) == "A" )
        for i := 1 to Min(Len(aColors), CLEN)
            if ( ValType(aColors[i]) == "C" )
                aTemp[COFFSET + i] := DF_Convert(aColors[i])
            else
                if ( ValType(aColors[i]) == "N" )
                    aTemp[COFFSET + i] := aColors[i]
                else
                    aTemp[COFFSET + i] := nCNormal
                endif
            endif
        next
    endif

    aTemp[FBOLD]  := .f.
    aTemp[FUNDER] := .f.
    aTemp[FG1]    := .f.
    aTemp[FG2]    := .f.
    aTemp[FG3]    := .f.
    aTemp[FG4]    := .f.
    aTemp[FG5]    := .f.
    aTemp[FHIGH]  := .f.
    aTemp[FFLASH] := .f.

    aTemp[HANDLE] := FOpen(cInFile)

    if ( FError() == 0 )
        aTemp[BUFFER]  := Space(aTemp[BUFFSIZE])
        aTemp[LBUFFER] := Space(aTemp[RMARGIN])

        if ( nRowLock > 0 )
            aTemp[RBUFFER] := Space(aTemp[ROWLOCK] * aTemp[RMARGIN])
        endif

        aTemp[FSIZE] := FSeek(aTemp[HANDLE], 0, FS_END) - 1

        FSeek(aTemp[HANDLE], 0, FS_SET)

        if ( aTemp[FSIZE] < aTemp[BUFFBOT] )
            aTemp[BUFFBOT] := aTemp[FSIZE]
        endif

        df_init(aTemp, aTemp[BOOKMARKS], MaxCol() + 1)

        AAdd(aStack, aTemp)

        rval := Len(aStack)
    endif
endif

return (rval)





function DF_Draw(nHandle)

if ( nHandle > 0 .and. nHandle <= Len(aStack) )
    df_exec(aStack[nHandle], aStack[nHandle, BOOKMARKS],;
            MaxCol() + 1, DRAWSCREEN)
endif

return (NIL)





function DispFile(nHandle)

local rval := NIL

if ( nHandle > 0 .and. nHandle <= Len(aStack) )

    rval := df_exec(aStack[nHandle], aStack[nHandle, BOOKMARKS],;
                    MaxCol() + 1, PROCESS)
endif

return (rval)





function DF_Close(nHandle)

local rval := .f.

if ( nHandle > 0 .and. nHandle <= Len(aStack) )
    if ( ValType(aStack[nHandle, HANDLE]) == "N" )
        FClose(aStack[nHandle, HANDLE])

        ADel(aStack, nHandle)

        ASize(aStack, Len(aStack) - 1)

        rval := (FError() == 0)
    endif
endif

return (rval)





function DF_Status(nHandle, nItem)

local rval := NIL

if ( nHandle > 0 .and. nHandle <= Len(aStack) ) .and.;
   ( nItem > 0 .and. nItem <= SLEN )

    rval := aStack[nHandle, nItem]
endif

return (rval)





function DF_WRow(nHandle)

local rval := 0

if ( nHandle > 0 .and. nHandle <= Len(aStack) )
    rval := aStack[nHandle, WINROW] - aStack[nHandle, TOP]
endif

return (rval)





function DF_WLine(nHandle, nRow)

local i    := 0
local c    := 0
local p    := 0
local rval := ""

local aTemp := { 0, 0 }


if ( nHandle > 0 .and. nHandle <= Len(aStack) )
    if ( ValType(nRow) != "N" )
        nRow := DF_WRow(nHandle)
    endif

    df_extract(nRow, aStack[nHandle, BUFFER],;
                     aStack[nHandle, WINTOP],;
                     aStack[nHandle, WINBOT], aTemp)

    if ( aTemp[2] != 0 )
        rval := SubStr(aStack[nHandle, BUFFER], aTemp[1], aTemp[2])
    endif
endif

return (rval)





function DF_Convert(cColor)

local aColors := { "N", "B", "G", "BG", "R", "RB", "GR", "W" }
local nFore   := -1
local nBack   := -1
local p, i
local t1, t2
local f1, f2

cColor := Upper(LTrim(RTrim(cColor)))

if ( (p := AT(",", cColor)) > 0 )
    cColor := SubStr(cColor, 1, p - 1)
endif

p := if((p := AT("/", cColor)) == 0, Len(cColor), p - 1)

t1 := LTrim(RTrim(SubStr(cColor, 1, p)))    // extract foreground

p += 2

t2 := LTrim(RTrim(SubStr(cColor, p)))       // extract background

f1 := ( AT("+", t1 + t2)!= 0 )
f2 := ( AT("*", t1 + t2) != 0 )

if ( f1 )
    t1 := StrTran(t1, "+", "")
    t2 := StrTran(t2, "+", "")
endif

if ( f2 )
    t1 := StrTran(t1, "*", "")
    t2 := StrTran(t2, "*", "")
endif

for i := 1 to 8
    if ( t1 == aColors[i] )
        nFore := i - 1
    endif

    if ( t2 == aColors[i] )
        nBack := i - 1
    endif
next

return (nFore + (nBack * 16) + if(f1, 8, 0) + if(f2, 128, 0))

