*COMMENTS***********************************************************************
/*
Copyright(C) Delcom-Deltranik International Software Engineering 1990-1993.

$owner: BILLW$

$version: 1.7$ $date: February 24, 1993$ $time: 03:20:13 PM$

$lgb$
1.0 October 22, 1992 BILLW
1.1 October 30, 1992 BILLW
1.2 November 13, 1992 BILLW
1.3 December 3, 1992 BILLW
1.4 December 3, 1992 BILLW
1.5 February 12, 1993 BILLW
1.6 February 19, 1993 BILLW
1.7 February 24, 1993 BILLW
$lge$
*/
********************************************************************************




*PROTOTYPES**********************************************************************
// Prototype Table

********************************************************************************




*PREPROCESSOR*******************************************************************
#INCLUDE "inkey.ch"
#INCLUDE "MOUSE.CH"
#INCLUDE "CUAClip.ch"
********************************************************************************



*GLOBAL STATICS*****************************************************************
STATIC id_string := "$id: ssvcid demo.prg 1.7 February 24, 1993 03:20:13 PM$"
// $nokeywords$
STATIC FirstLetter
STATIC lFRENCH
STATIC cInstruct
STATIC cAdd1
STATIC cAdd2
STATIC cCity
STATIC cProv
STATIC cPostalCode
STATIC cPhoneNum
STATIC dBirthDate
STATIC cLanguage
STATIC aLanguage := { { { "E", "English" }, { "F", "French" }, { "B", "Bilingual" } } }

********************************************************************************



*GLOBAL FUNCTIONS***************************************************************
//Ŀ
//  Description:                                                            
//       Author: Bill Wilson                                                
// Date created: 01-13-93                                                   
// Time created: 12:14:17pm                                                 
//    Copyright: Delcom International Software Engineering Inc.             
//Ĵ
//     Function: Main()                                                     
//                                                                          
//    Arguments:                                                            
//                                                                          
// Return Value:                                                            
//     See Also:                                                            
//                                                                          
//
FUNCTION Main()

  LOCAL PromptList:={}
  LOCAL answer:=3, x
  LOCAL cDosScreen
  LOCAL nRow := ROW()
  LOCAL nCol := COL()
  LOCAL lMore := TRUE
  LOCAL aData := { ;
  { "~Employee", "Enter the employee area...", {|| Demo( TRUE ), TRUE } }, ;
  { "~Instructor", "Enter the instructor area...", {|| Instruct() } } ;
  }

  LOCAL aFiles := { ;
  { "~Data", "Enter the employee or instructor areas...", aData }, ;
  { }, ;
  { "E~xit      <ALT-X>", "Quit and go back to DOS...", {|| lMore := FALSE } } }


  SET MESSAGE TO MAXROW() CENTER
  SET SCOREBOARD OFF
  SETCOLOR( "W/N*, B/W , , , W/B" )
  SetMenuColor( "N/W, N/W*, N+/W, W+/W, W*/W" )
  SetPullColor( "N/W, N/W*, N+/W, W+/W, W*/W" )
  SetMessColor( "W+/N*" )
  SetInterrupt( {|| ShowTime() } )
  SetMEvent( {| nKey | ;
				IIF( nKey == K_ALT_X, ( lMore := FALSE, TRUE ), FALSE ) } )

  WindowsComp( FALSE )
  SETCURSOR( 0 )
  SETBLINK( FALSE )

  cDosScreen := ShadowBox( 0, 0, MAXROW(), MAXCOL(), " ", "W/N*", FALSE )

  ALTD( 0 )

  SETCOLOR( "N/W, B/W, , , W/B" )

  @ 0, 0

  SETCOLOR( "W/N*, B/W, , , W/B" )

  FOR x := 1 TO MAXROW() - 1
    @ x, 0 SAY PADR( REPLICATE( CHR( 254 ), x ) + ;
    		" CUA-Clipper Interface Library Version 1.0 ", ;
    		80, CHR( 254 ) )
  NEXT x

  @ 0, 1 PROMPT "~Files" MESSAGE "Data entry stuff..." PULLDOWN aFiles
  @ 0, COL() + 2 PROMPT "~Nothing" MESSAGE "This does nothing..." ACTION TRUE
  @ 0, COL() + 2 PROMPT "~Empty" MESSAGE "This does nothing also..." ACTION TRUE
  @ 0, COL() + 2 PROMPT "~Help" MESSAGE "Help...( not implemented )..." ACTION TRUE

  WHILE lMore
    MENU TO answer SAVE USING LastMenu()
  END
  SETCURSOR( 1 )
  SETCOLOR( "" )

  KillBox( cDosScreen )
  SETPOS( nRow, nCol )

  QUIT

RETURN NIL
********************************************************************************




*STATIC FUNCTIONS****************************************************************
//Ŀ
//  Description:                                                            
//       Author: Bill Wilson                                                
// Date created: 01-13-93                                                   
// Time created: 12:14:17pm                                                 
//    Copyright: Delcom International Software Engineering Inc.             
//Ĵ
//     Function: Demo()                                                     
//                                                                          
//    Arguments:                                                            
//                                                                          
// Return Value:                                                            
//     See Also:                                                            
//                                                                          
//
STATIC FUNCTION Demo( lAppend )

  LOCAL GetList      := {}
  STATIC cName       := "                    "
  STATIC nSalutation := 0
  STATIC cCity       := "               "
  STATIC cPhone      := "          "
  STATIC lModem      := .F.
  STATIC nBaudRate   := 0
  LOCAL aSalutations := { { { 1, "Mr." }, { 2, "Mrs." }, { 3, "Miss" }, { 4, "Ms." } } }
  LOCAL aBaudRates   := { { {  3, "300  " }, { 12, "1200 " }, { 24, "2400 " }, { 48, "4800 " } }, ;
				              { { 96, "9600 " }, { 19, "19200" }, { 38, "38400" }, { 57, "57600" } } }

  LOCAL aCities      := { ;
  								  "Calgary        ", ;
  								  "Edmonton       ", ;
  								  "Halifax        ", ;
  								  "Hamilton       ", ;
  								  "Montreal       ", ;
								  "Ottawa         ", ;
  								  "Regina         ", ;
  								  "Saskatoon      ", ;
  								  "St. John's     ", ;
  								  "Toronto        ", ;
  								  "Vancouver      ", ;
  								  "Winnipeg       "  ;
						  		}

  LOCAL cOldColor    := SETCOLOR( "W/RB, RB/W, , , +W/RB" )
  LOCAL cOldMenu     := SetMenuColor( "+W/BG, B/BG, N+/BG, W/BG, R/BG" )
  LOCAL cOldGet      := SetGetColor( "+W/RB, RB/W, W/RB" )
  LOCAL cOldPop      := SetPopColor( "+W/R, R/W, W/R" )
  LOCAL cOldScreen   := ShadowBox( 9, 12, 22, 67, 2, "+W/RB" )
  LOCAL lOldUpdate   := Updated( FALSE )

  WindowsComp( FALSE )

  DEFAULT lAppend TO FALSE

  /* The radio button array structure is an array containing another array for
  each row of buttons to be displayed.  Each one of these "row" arrays
  contain an array for each button on that row.  Each one of the "button"
  arrays contain two elements, 1 - a value for the variable and
  2 - the corresponding character prompt for that value.  The vartype() of the
  first element must match that of the variable being represented by the radio
  button.
  {
  { <xValue1>, <cPrompt1> } [,{ <xValue#>, <cPrompt#> }, ... ] }
  [,{ <xValue#>, <cPrompt#> } [,{ <xValue#>, <cPrompt#> }, ... ] }, ... ]
  }
  */

  IF lAppend
    cName       := "                         "
    nSalutation := 0
    cCity       := "               "
    cPhone      := "          "
    lModem      := .F.
    nBaudRate   := 0
  ENDIF

  @ 10, 16 SAY "Name:  "     GET cName ;
  				 MESSAGE "What is the name of the person..." ;
  	          DBLIST { "instruct",{ || IIF( EMPTY( cCity ), "instruct", "instcity" ) }, ;
				 		  {|| IIF( EMPTY( cCity ), "", UPPER( cCity ) ) }, ;
						  {|| field->instruct },, ;
						  {|x| UPPER( IIF( EMPTY( cCity ), "", cCity ) + x ) } } ;
				 VALID ( AssignGet( "Save" ), AssignGet( "Save/Exit" ), ;
				        DBLookUp( UPPER( cName ), "instruct", "instruct", ;
						  {|| AssignGet( "cCity", field->city ), ;
						  AssignGet( "cPhone", field->phonenum), TRUE } ) )
  @ 11, 16 SAY "Salutation:" GET nSalutation USING Radio WITH aSalutations ;
  				 MESSAGE "Salutation please..." ;
				 VALID ( AssignGet( "Save" ), AssignGet( "Save/Exit" ), TRUE )
  @ 12, 16 SAY "City:  "     GET cCity LIST aCities ;
  				 MESSAGE "The city in which the person lives.." ;
  				 VALID ( AssignGet( "Save" ), AssignGet( "Save/Exit" ), TRUE )
  @ 13, 16 SAY "Phone: "     GET cPhone PICTURE "@R (999) 999-9999" ;
  				 WHEN !EMPTY(cName) HIDDEN MESSAGE "Telephone number please..." ;
				 VALID ( AssignGet( "Save" ), AssignGet( "Save/Exit" ), TRUE )
  @ 14, 16 SAY "Modem?:"     GET lModem USING Check ;
  				 VALID ( AssignGet( "nBaudRate" ), AssignGet( "Save" ), AssignGet( "Save/Exit" ), IIF( !lModem, ( nBaudRate := 0 ), NIL ), TRUE ) ;
  				 MESSAGE "Does the person have a modem?..."
	// Notice the trick to clear the baudrate field.
  @ 15, 16 TO 18, 63                             //draw a box to contain the baud rates
  @ 15, 16 SAY "Baud Rate"
  @ 16, 19 GET nBaudRate USING Radio WITH aBaudRates WHEN lModem ;
  				 MESSAGE "What baud rate does their modem function at?..." ;
				 VALID ( AssignGet( "Save" ), AssignGet( "Save/Exit" ), TRUE )

  @ 20, 26 BUTTON "~Save" WHEN UpDated() ACTION IIF( ValidGets() == 0, ( OrigChanged(), ResetOrigs(), AssignGet( "Save/Exit" ), FALSE ), FALSE) ;
  				 MESSAGE "Save the work and continue..."

  @ 20, COL() + 3 BUTTON "Save/E~xit" WHEN UpDated() ACTION IIF( ValidGets() == 0, !OrigChanged(), FALSE )  ;
  				 MESSAGE "Save the work and exit..."

  @ 20, COL() + 3 BUTTON "~Abort" ACTION UndoGets() ;
  				MESSAGE "Abort your work and exit..."

  READ

  SETCOLOR( cOldColor )
  SetMenuColor( cOldMenu )
  SetGetColor( cOldGet )
  SetPopColor( cOldPop )
  KillBox( cOldScreen )
  Updated( lOldUpdated )

RETURN NIL



//Ŀ
//  Description:                                                            
//       Author: Bill Wilson                                                
// Date created: 01-13-93                                                   
// Time created: 12:14:17pm                                                 
//    Copyright: Delcom International Software Engineering Inc.             
//Ĵ
//     Function: GetFirst()                                                 
//                                                                          
//    Arguments:                                                            
//                                                                          
// Return Value:                                                            
//     See Also:                                                            
//                                                                          
//
STATIC FUNCTION GetFirst( browse )

  LOCAL cOldScreen, GetList := {}, cOldColor := SETCOLOR( "W+/R, R/W, , , W/R"), x
  LOCAL nOldCursor := SETCURSOR( 1 )

  DEFAULT FirstLetter TO " "

  cOldScreen := ShadowBox( 6, 27, 8, 54, 2, "W+/R" )
  @ 7, 29 SAY "Letter For First Name:" GET FirstLetter PICTURE "@! A"
  READ

  SETCOLOR( cOldColor )
  SETCURSOR( nOldCursor )
  KillBox( cOldScreen )

  FOR x := 1 TO browse:colCount

    browse:GetColumn( x ):colorBlock := {| | IIF( EMPLOYEE->NAME = FirstLetter, ;
			    IIF( TB_OnData( browse ), { 7, 8 }, { 9, 10 } ),;
    			IIF( TB_OnData( browse ), { 3, 4 }, { 5, 6 } ) ) }

  NEXT x

  browse:RefreshAll()

RETURN TRUE



//Ŀ
//  Description:                                                            
//       Author: Bill Wilson                                                
// Date created: 01-13-93                                                   
// Time created: 12:14:17pm                                                 
//    Copyright: Delcom International Software Engineering Inc.             
//Ĵ
//     Function: GetFrench()                                                
//                                                                          
//    Arguments:                                                            
//                                                                          
// Return Value:                                                            
//     See Also:                                                            
//                                                                          
//
STATIC FUNCTION GetFrench( browse )

  LOCAL GetList := {},x

  DEFAULT lFRENCH TO .T.

  FOR x := 1 TO browse:colCount

    browse:GetColumn( x ):colorBlock :={| | IIF( EMPLOYEE->FRENCH, ;
    		IIF( TB_OnData( browse ), { 7, 8 }, { 9, 10 } ),;
    		IIF( TB_OnData( browse ), { 3, 4 }, { 5, 6 } ) ) }

  NEXT x

  browse:RefreshAll()

RETURN TRUE



//Ŀ
//  Description:                                                            
//       Author: Bill Wilson                                                
// Date created: 01-13-93                                                   
// Time created: 12:14:17pm                                                 
//    Copyright: Delcom International Software Engineering Inc.             
//Ĵ
//     Function: ShowTime()                                                 
//                                                                          
//    Arguments:                                                            
//                                                                          
// Return Value:                                                            
//     See Also:                                                            
//                                                                          
//
STATIC FUNCTION ShowTime()

  STATIC cTime := " "
  LOCAL nRow, nCol

  IF cTime <> TIME()

    cTime := TIME()
    nRow  := ROW()
    nCol  := COL()
    @ 0, MAXCOL() - 7 SAY cTime COLOR "N+/W"
    SETPOS( nRow, nCol )

  ENDIF

RETURN NIL



FUNCTION Instruct()

LOCAL nOldMouse := SetMouse( MOUSE_WAIT )
LOCAL cOldMessage := Message( "* * WAIT * *" )
LOCAL x
LOCAL nOldArea := SELECT()
LOCAL aFileMenu := { ;
	{ "~Add   <INSERT>","Add a new instructor...", { |browse| AddInstruct( browse ), TRUE }},;
	{ "~Delete   <DEL>", "Delete the current instructor...", { |browse| browse:cargo[ B_LMORE ] := DelInstruct( browse ), TRUE } }, ;
	{}, ;
	{ "E~xit   <ALT-X>", "Exit and go back to the menu...", {|browse| browse:cargo[ B_LMORE ] := FALSE, TRUE } } ;
	}
LOCAL aMenu := ;
		{ ;
		{"~Files", aFileMenu, ,"Add, Delete an instructor, EXIT..."} ;
		}
LOCAL cOldMenuColor := SetMenuColor("W/B,B/W,N+/B,W+/B,W+/W")
LOCAL cOldPullColor := SetPullColor("B/BG,B/W,N+/BG,W+/BG,W+/W")
LOCAL aHotKeys := { ;
	{ M_DOUBLE_CLICK, { | browse | IIF( TB_IsInData( browse ), EditInstruct( browse ), NIL ), TRUE  } }, ;
	{ K_RETURN, { | browse | EditInstruct( browse ),TRUE  } }, ;
	{ K_INS, { | BROWSE | IIF( TB_OnData( browse ), AddInstruct( BROWSE ), NIL ),TRUE } },;
	{ K_DEL, { | BROWSE | IIF( TB_OnData( browse ), DelInstruct( BROWSE ), TRUE ) } }, ;
	{ K_ALT_X, { || FALSE } } ;
	}
LOCAL aCols := { { "Instructor's Name", {|| Instruct->INSTRUCT } }, ;
                 { "Address1", {|| Instruct->ADD1 } }, ;
                 { "Address2", {|| Instruct->ADD2 } }, ;
                 { "City", {|| Instruct->CITY } }, ;
                 { "Province", {|| Instruct->PROVCODE } }, ;
                 { "Postal Code", {|| Instruct->POSTALCODE } }, ;
                 { "Phone", {|| Instruct->PHONENUM } } ;
					}
LOCAL aDim := Centered( MAXROW() - 11, MAXCOL() - 5 )
LOCAL bMenuEvent := SetMEvent( { | nKey, browse | CheckEvent( browse, nKey ) } )

BEGIN SEQUENCE

	NETUSE instruct INDEX instruct NEW ALIAS instruct

	Message( "" )

	SetMouse( MOUSE_ON )
	STDBrowse(aDim[ 1 ], aDim[ 2 ], aDim[ 3 ], aDim[ 4 ],aCols,"INSTRUCTORS", ;
   	       aHotKeys, ;
      	    "W+/B, B+/W*, W+/B, B+/W, W/B, B/W, W+/R, R+/W, W/R, R/W",;
         	 TRUE,aMenu,,,{ | browse, nKey | BrowseSkip( browse, nKey ) } ;
				 ,,,{| browse | NoData( browse ) } )

END

dbNetClose( "instruct" )

SELECT( nOldArea )

SetMenuColor( cOldMenuColor )
SetPullColor( cOldPullColor )
Message( cOldMessage )
SetMouse( nOldMouse )
SetMEvent( bMenuEvent )

RETURN TRUE


STATIC FUNCTION InstructScrn( lAppend, browse )

LOCAL GetList      := {}
LOCAL nOldMouse    := SetMouse( MOUSE_WAIT )
LOCAL cOldMessage  := Message( "* * WAIT * *" )
LOCAL cOldColor    := SETCOLOR("W/RB,RB/W,,,+W/RB")
LOCAL cOldMenu     := SetMenuColor("+W/BG,B/BG,N+/BG,R/BG,R/BG")
LOCAL cOldGet      := SetGetColor("+W/RB,RB/W,W/RB,+R/RB")
LOCAL cOldPop      := SetPopColor("+W/R,R/W,W/R")
LOCAL cOldScreen
LOCAL lOldUpdate   := Updated( FALSE )
LOCAL lChanged     := FALSE
LOCAL nRecno
LOCAL aDim         := Centered( 14, 64 )
LOCAL nSR          := aDim[ 1 ]
LOCAL nSC          := aDim[ 2 ]
LOCAL nER          := aDim[ 3 ]
LOCAL nEC          := aDim[ 4 ]

cOldScreen := ShadowBox( nSR, nSC, nER, nEC, 2, "+W/RB")

@ nSR, nSC + 1 SAY PADC( " INSTRUCTORS ", 62, CHR( 205 ) ) COLOR "W+/RB"

DEFAULT lAppend TO FALSE

IF lAppend
	GOTO BOTTOM
	SKIP
ELSE
	nRecno := RECNO()
	@ nSR + 9, nSC + 32 SAY PADR( LongDate( instruct->birthdate ), 30 )
ENDIF

cInstruct   := Instruct->instruct
cAdd1       := Instruct->add1
cAdd2       := Instruct->add2
cCity       := Instruct->city
cProv       := Instruct->provcode
cPostalCode := Instruct->postalcode
cPhoneNum   := Instruct->phonenum
dBirthDate  := instruct->birthdate
cLanguage   := instruct->language

@ nSR + 2, nSC + 3 SAY "Instructor       " GET cInstruct ;
	MASTERVAR field->instruct ;
	VALID !EMPTY( cInstruct ) ;
	MESSAGE "Enter the name of the instructor..."

@ nSR + 3, nSC + 3 SAY "Address:         " GET cAdd1 ;
	MASTERVAR field->add1 ;
	VALID IIF( EMPTY( cAdd1 ), AssignGet( "cAdd2", SPACE( 40 ) ), TRUE ) ;
	   .AND. !EMPTY( cAdd1 ) ;
	MESSAGE "Enter the instructor's address..."

@ nSR + 4, nSC + 21 GET cAdd2 WHEN !EMPTY( cAdd1 ) ;
	MASTERVAR field->add2 ;
	MESSAGE "Enter the instructor's address..."

@ nSR + 5, nSC + 3 SAY "City:            " GET cCity ;
	MASTERVAR field->city ;
	VALID !EMPTY( cCity ) ;
	MESSAGE "Enter the instructor's city..."

@ nSR + 6, nSC + 3 SAY "Province:        " GET cProv ;
	MASTERVAR field->provcode ;
	DBLIST { "province", "province",,{|| DEVPOS( nSR + 6, nSC + 25 ), ;
		DEVOUT( field->province ), field->provcode}, {|| field->province }, ;
		{|x| "F" + UPPER(x) } } ;
	PICTURE "@! AA" ;
	VALID DBLookUp( "F" + cProv, "province", "province", { || DEVPOS( nSR + 6, nSC + 25 ), ;
			DEVOUT( field->province ), TRUE } ) ;
	MESSAGE "Enter the instructor's province..."
DBLookUp( "F" + cProv, "province", "province", {|| DEVPOS( nSR + 6, nSC + 25 ), ;
						DEVOUT( field->province ), TRUE } )

@ nSR + 7, nSC + 3 SAY "Postal Code:     " GET cPostalCode ;
	MASTERVAR field->postalcode ;
	PICTURE "@!R A9A 9A9" ;
	MESSAGE "Enter the instructor's postal code..."

@ nSR + 8, nSC + 3 SAY "Phone Number:    " GET cPhoneNum ;
	MASTERVAR field->phonenum ;
	PICTURE "@R (999) 999-9999" ;
	VALID ( cPhoneNum := PADL( ALLTRIM( cPhoneNum ), 10 ), !EMPTY( cPhoneNum ) ) ;
	MESSAGE "Enter the instructor's phone number..."

@ nSR + 9, nSC + 3 SAY "Date of Birth:   " GET dBirthDate ;
	MASTERVAR field->birthdate ;
	MESSAGE "Enter the instructor's birth date (dd/mm/yyyy)..." ;
	VALID IIF( !EMPTY( dBirthDate ), ;
	( DEVPOS( nSR + 9, nSC + 32 ), DEVOUT( PADR( LongDate( dBirthDate ), 30 ) ), TRUE ), TRUE )

@ nSR + 10, nSC + 3 SAY "Language(s):     " GET cLanguage USING RADIO WITH aLanguage ;
	MASTERVAR field->language ;
	MESSAGE "Enter the instructor's language capabilities..." ;
	VALID !EMPTY( cLanguage )

@ nSR + 12, nSC + 23 BUTTON "~Okay" ACTION (lChanged := SaveIt( lAppend, browse ) ) ;
	MESSAGE "Save the work and exit..."

@ nSR + 12, COL() + 3 BUTTON "~Abort" ACTION UndoGets() ;
	MESSAGE "Abort your work and exit..."

READ

IF UpDated() .AND. !LastKill() .AND. !lChanged
	lChanged := SaveIt( lAppend, browse )
ENDIF

SETCOLOR( cOldColor )
SetMenuColor( cOldMenu )
SetGetColor( cOldGet )
SetPopColor( cOldPop )
KillBox( cOldScreen )
Updated( lOldUpdated )
Message( cOldMessage )
SetMouse( nOldMouse )

RETURN lChanged


STATIC FUNCTION SaveIt( lAppend, browse )

	LOCAL nOldMouse := SetMouse( MOUSE_WAIT )
	LOCAL cOldMessage := Message( "* * WAIT * *" )
	LOCAL lReturnVar := FALSE

	SELECT instruct

	IF ValidGets() == 0

		IF lAppend

			SET DELETED OFF
			SEEK "T"
			IF !FOUND()
				APPEND BLANK
			ELSE
				WHILE !RLOCK() ; END
				RECALL
			ENDIF
			SET DELETED ON

		ELSE

			WHILE !RLOCK() ; END

		ENDIF

		IF lAppend .OR. !(OrigChanged() .AND. ALERT("Someone else has modified this instruct record;" + ;
			"while you were editing it.;Overwrite their work?",{"Yes","No"},,TRUE) == 2)

			instruct->instruct   := cInstruct
			instruct->add1       := cAdd1
			instruct->add2       := cAdd2
			instruct->city       := cCity
			instruct->provcode   := cProv
			instruct->postalcode := cPostalCode
			instruct->phonenum   := cPhoneNum
			instruct->birthdate  := dBirthDate
			instruct->language   := cLanguage

			COMMIT
			ResetOrigs()

			lReturnVar := TRUE

		ENDIF

		UNLOCK

	ENDIF

	Message( cOldMessage )
	SetMouse( nOldMouse )

RETURN lReturnVar




STATIC FUNCTION AddInstruct( browse )
	LOCAL lReturnVal := FALSE
	LOCAL nOldRecord := RECNO()
	LOCAL cName

	SELECT instruct

	IF (lReturnVal := InstructScrn( TRUE, BROWSE ) )

		cName := UPPER( instruct->instruct )
		browse:rowpos := 1
		TB_Reset( browse, , {|| TRUE})
		TB_Seek( browse, "F" + cName )
		browse:refreshall()
	ELSE

		GOTO nOldRecord
		browse:refreshCurrent()

	ENDIF

RETURN lReturnVal



STATIC FUNCTION DelInstruct( browse )
	LOCAL lReturnVar := TRUE
	LOCAL cName

	IF ( Alert( "Delete " + TRIM( instruct->instruct ) + "?", { "~No", "~Yes" } ) == 2 )
		BEGIN SEQUENCE
			Message( "* * WAIT * *" )
			NETUSE location INDEX location ALIAS location NEW
			NETUSE crseschd INDEX csinst ALIAS crseschd NEW
			SET RELATION TO "F" + crseschd->location INTO location
			SEEK "F" + instruct->instruct
			Message( "" )
			IF FOUND()
				Alert( "There is a booking for;" + ;
					 	TRIM( instruct->instruct ) + ;
					 	";on " + LongDate( crseschd->coursedate ) + ;
					 	";at " + TRIM( location->desc ) + ;
					 	";;Therefor it can not be deleted!",,, TRUE )
				SELECT instruct
			ELSE
				SELECT instruct
				SKIP 1
				cName := UPPER(instruct->instruct)
				SKIP -1
				WHILE !RLOCK() ; END
				DELETE
				COMMIT
				UNLOCK
				browse:rowpos := 1
				TB_Reset( browse, , {|| TRUE } )
				TB_Seek( Browse, "F" + cName )
				browse:RefreshAll()
			ENDIF
		END
		dbNetClose( { "crseschd", "location" } )
		Message( "" )
	ENDIF

RETURN TRUE




STATIC FUNCTION EditInstruct( browse )
LOCAL nOldArea := SELECT()
LOCAL nOldRecord := RECNO()
LOCAL lReturnVal

SELECT instruct

lReturnVal := 	InstructScrn( , browse )
browse:refreshCurrent()

SELECT ( nOldArea )

RETURN TRUE


STATIC FUNCTION NoData()
RETURN FALSE

FUNCTION BrowseSkip( browse, nKey )
	TB_Seek( browse, UPPER( CHR( nKey ) ) )
RETURN TRUE

FUNCTION CheckEvent( browse, nKey )
   LOCAL nMLastRow := MLastRow()
   LOCAL nMLastCol := MLastCol()
   LOCAL lReturnVal := FALSE

   IF ( nKey == M_LEFT_BUTTON .OR. nKey == M_DOUBLE_CLICK ) .AND. ;
      nMLastRow >= browse:cargo[ B_NTOP ] .AND. ;
      nMLastRow <= browse:cargo[ B_NBOTTOM ] .AND. ;
      nMLastCol >= browse:cargo[ B_NLEFT ] .AND. ;
      nMLastCol <= browse:cargo[ B_NRIGHT ]

      TB_ForceKey( nKey )
      lReturnVal := TRUE

   ENDIF
RETURN lReturnVal
********************************************************************************
