/*****************************************************************************
 *                  Functions to read dBASE III+ files                       *
 *                                                                           *
 * dappend	- append a blank record to database file                     *
 * dopen	- open database, read header, fields, set up 'area' struct.  *
 * dclose	- close open database file                                   *
 * dgetrec	- read a record from the open database                       *
 * dputrec	- write a record to the open database                        *
 * dprtrec	- print a single record gotten by the dgetrec call           *
 * dprthdr	- print database header and data dictionary                  *
 * dgetfld	- retreive a database record field                           *
 * dputfld	- put user data into field                                   *
 * dprtfld	- print a single field                                       *
 *                                                                           *
 *****************************************************************************/

/* dBASE III/IV version identifier codes */
#define DB3_DB2 0x02        /* dBASE II (Not Supported */
#define DB3_DB3 0x03        /* dBASE III */
#define DB3_DBT 0x83        /* dBASE III with MEMO file */
#define DB4_DBT 0x8B        /* dBASE IV with MEMO file */
#define FOX_FPT 0xF5        /* FOXPRO FILE */

/* print options for db3info() */
#define DB3_HEAD	1		/* print database header data */
#define DB3_DATA	2		/* print database dictionary */

/* field attribute types */
#define DB3_TYPE_CHAR	'C'	/* character data type */
#define DB3_TYPE_NUM	'N'	/* numeric data type */
#define DB3_TYPE_LOGIC	'L'	/* logical data type */
#define DB3_TYPE_MEMO	'M'	/* memo data type */
#define DB3_TYPE_DATE	'D'	/* date data type */

/* db3 error indicators */
#define	DB3_NOERROR	0		/* no error condition */
#define	DB3_OPENERR	1		/* file open error */
#define	DB3_NOTFOUND	2	/* file not found */
#define	DB3_NOPRIOR	3		/* no prior record */
#define	DB3_ENDFILE	4		/* end of file */
#define	DB3_BEGFILE	5		/* beginning of file */
#define	DB3_NORECORD	6	/* invalid record number */
#define	DB3_NOMEMORY	7	/* not enough memory */
#define	DB3_BADINDEX	8	/* bad index file */
#define	DB3_IOERROR	9		/* file I/O error */
#define	DB3_NOFILE	10		/* no file exists */
#define DB3_VERSION	11		/* incorrect dbaseIII version */
#define DB3_FLDSIZE	12		/* data too large for field */
#define DB3_FLDFORM	13		/* data format error */
#define DB3_HDRFORM	14		/* header format error */

/* operating parameters */
#define DB3_MAXDBF	10					/* maximum # of data files open */
#define DB3_MAXFLD	128					/* maximum # of fields */
#define DB3_MAXCXR	4000				/* maximum # of chars/record */

/* dBASE III functions */
#define RECCOUNT	area->dbhead.count	/* dBASE III RECCOUNT */
#define RECSIZE		area->dbhead.lrecl	/* dBASE III RECSIZE */
#define RECNO		area->recno			/* dBASE III RECNO */
#define LUPDATE		area->lupdate		/* dBASE III LUPDATE */
#define VERSION		area->dbhead.version/* dBASE III VERSION */
#define DBF			area->dbfname		/* dBASE III DBF */
#define ERROR		area->error			/* dBASE III ERROR */
										/* FIELDS - return # fields */
#define FIELDS	((area->dbhead.header-1)/32-1)	/* (db3 Only) */

typedef  struct dbase_head {		/* database file header		*/
	unsigned char	version;		/* 03 without memo, 83 with memo file */
	unsigned char	l_update[3];	/* yymmdd for last update */
	unsigned long	count;			/* number of records in file */
	unsigned int	header;			/* header length including '\r' */
	unsigned int	lrecl;			/* record length plus delete byte */
	unsigned char	reserv[20];		/* reserved */
} DBHEAD;

typedef struct dbase_field {		/* database field structure */
	char	name[11];				/* field name */
	char	type;					/* field type */
	char	*data;					/* field data pointer */
	char	dummy1[2];				/* dummy fill bytes */
    unsigned char    length;        /* field length */
    unsigned char    dec_point;     /* field decimal point */
	char	network1[2];			/* reserved for network operation */
	char	area;					/* work area selected */
	char	network2[2];			/* reserved for network operation */
	char	setfields;				/* set fields flag */
	char	dummy2[8];				/* dummy fill bytes */
} DBFIELD;							/* structure of one database field */

typedef struct	field_list {		/* structure for field linked list */
	struct	field_list *next;		/* pointer to next field */
	DBFIELD	*field;					/* data area for field */
	char	*data;					/* pointer to data in field */
} DBFLIST;							/* linked list of fields */

typedef struct user {				/* user working structure */
	DBHEAD	dbhead;					/* database header */
	DBFLIST *dbfroot;				/* list of fields and descriptions */
	char	*delete;				/* delete byte */
	char	*buffer;				/* pointer to data buffer */
	char	dbfname[15];			/* active database file name */
	char	lupdate[9];				/* date of last update */
	int	dbfile;						/* dbase file descriptor */
	int	error;						/* current error number */
	int	modified;					/* current data file was modified */
	int	openmode;					/* database file open mode */
	unsigned long recno;			/* current record number */
} DBAREA;

#ifdef	DB3MAIN						/* define DB3MAIN in main routine */
DBFIELD *dgetfld();
DBAREA	*dopen();

void	dprtrec();
void	dprtfld();
void	dprthdr();

int	dclose();
int	dskip();
int	_listfld();
#endif

