***---FUNCTION dblclick

* This function waits for a keypress or mouse click.  If the event is
* a single mouse click it idles waiting for another event.  If the event
* is some other keypress it returns .F. (indicating that the event was 
* not a DOUBLECLICK and loads the variable nKeyPress with the value of
* the event key.
* nKeyPress must be initialized prior and passed to this function by
* reference.

FUNCTION dblclick
PARA nKeyPress
PRIVATE sy_talk, sy_esc
*
* Save environment and set some thing the way we want it
*
sy_talk = SET("TALK")
SET TALK OFF
sy_esc = SET("ESCAPE")
SET ESCAPE OFF

*
* Main program loop
* It will sit in this loop until a DOUBLECLICK or other key event
*

DO WHILE .T.

     *
     * Test shut off the cursor, test INKEY() for a key event or mouse click.
     * By default, INKEY() ignores the mouse therefore we have to put the
     * character M to watch the rodent too.
      
     nInval1 = INKEY(.06,'HM') 
     
     *
     * If no events, sit in the loop
     *
     
     IF nInval1 = 0            
          LOOP
     ENDIF
     
     *
     * As soon as there is an event, test and see if it was a mouse click.
     *    If it was go into another loop to test for the second click.
     *
     
     IF nInval1 = 151          
     
          *
          * See if the second click came within the parameters of what the
system
          * is set for a DOUBLECLICK event.
          * See _DBLCLICK in Foxhelp.
           
          nTimeLimit = SECONDS() + _DBLCLICK 
          nInval2 = 0
          DO WHILE SECONDS() < nTimeLimit
               nInval2 = INKEY('HM')
               
               *
               * If there was a second click within the acceptable time frame
return
               * .T. after restoring the environment to what it was when we
started.
               *
               
               IF nInval2 = 151 
                    SET TALK &sy_talk
                    SET ESCAPE &sy_esc
                    RETURN .T.
               ENDIF
          ENDDO
     ELSE
     
     * If the event wasn't a mouse click load the value of whatever key was
     * pressed into nKeyPress and return .F. (no DOUBLECLICK) after restoring
     * the environment to what it was when we started.
     *
     
          nKeyPress = nInval1
          SET TALK &sy_talk        
          SET ESCAPE &sy_esc       
          RETURN .F.
     ENDIF
ENDDO     

*- EOF dblclik
