/*******************************************************************************
* Program Id: dbeof.c
*    Version: 2.00
*   Comments: Robert V. Hannah III
*             Phoenix Systems, Inc.
*             2000 N. 15th Street
*             Suite 700
*             Arlington, Va  22201
*             703-522-0820      Voice
*             703-243-4820/1741 BBS
*             703-522-5407      FAX
********************************************************************************
*
*    Purpose: Clean out embedded eof markers in a dBASE III database.  Does not
*             affect .dbt - if using memos, be sure to copy the .dbt over.
*
********************************************************************************
* Date     Name Description
*
* 04/18/89 rvh  Original program
********************************************************************************/
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define USRBUFSIZ 0x8000

char buf[ USRBUFSIZ ];

void main( int argc, char *argv[] )
{
   char          *ptr;
   FILE          *in,
                 *out;
   int            amt,
                  cur,
                  curamt,
                  eofcount,
                  headsize,
                  loop,
                  recsize,
                  work;
   long           amtread,
                  reccnt;
   unsigned int   bufsize;

   _fmode = O_BINARY;

   printf( "DBEOF V2.0  Copyright 1989 Phoenix Systems\n" );

   if ( argc != 3 )
   {
      printf( "\nusage: DBEOF infile outfile\n" );
      printf( "Don't even think about using wildcards.\n" );
      exit( 1 );
   }

   if ( ! strcmpi( argv[ 1 ], argv[ 2 ] ) )
   {
      printf( "\nI don't like it when the infile is the outfile.\n" );
      printf( "Therefore, I have truncated the infile.  Just kidding.\n" );
      exit( 1 );
   }

   if ( ! ( in = fopen( argv[ 1 ], "r" ) ) )
   {
      printf( "\nI can't seem to open the input file.\n ");
      printf( "Shall I stand in the corner and rust, or just fall apart where I'm standing?\n ");
      exit( 1 );
   }

   if ( ! ( out = fopen( argv[ 2 ], "w+" ) ) )
   {
      printf( "\nI can't seem to open the output file.\n" );
      printf( "All this data and nowhere to put it.  How tragic.\n" );
      exit( 1 );
   }

   /* Disable double-buffering of data to speed things up */

   setbuf( in, NULL );
   setbuf( out, NULL );



   /* Get record count, header size, and record size. */

   fseek( in, 4L, SEEK_SET );
   fread( (char *) &reccnt, sizeof( long ), 1, in );
   fread( (char *) &headsize, sizeof( int ), 1, in );
   fread( (char *) &recsize, sizeof( int ), 1, in );

   /* Copy header to output */

   fseek( in, 0L, SEEK_SET );
   fread( buf, headsize, 1, in );
   fwrite( buf, headsize, 1, out );

   /* Determine bufsize ( multiple of recsize < USRBUFSIZ) and work */
   /* percentage marker. */

   bufsize = USRBUFSIZ - USRBUFSIZ % recsize;
   work    = (int) ( reccnt / 42L );
   if ( work < 1L )
      work = 1L;

   /* Print out pertinant information and status line. */

   printf( "\n      Header size = %d\n", headsize );
   printf(   "      Record size = %d\n", recsize );
   printf(   "Number of records = %ld\n", reccnt );
   printf( "\n Percentage complete Ĵ\n" );



   /* Main processing loop */

   amt      = fread( buf, 1, bufsize, in );
   amtread  = 0L;
   eofcount = loop = 0;
   while ( amt >= recsize )
   {
      curamt = 0;
      ptr    = buf;
      for ( cur = amt; cur >= recsize ; cur -= recsize, ptr += recsize )
      {
         amtread++;
         curamt += recsize;
         loop++;
         if ( loop == work )
         {
            putc( '.', stderr );
            loop = 0;
         }
         if ( *ptr == 0x1a )
         {
            *ptr = ' ';
            eofcount++;
         }
      }
      fwrite( buf, 1, curamt, out );
      amt = fread( buf, 1, bufsize, in );
      if ( ! amt )
         *buf = ( cur > 0 ) ? *ptr : ' ';
   }



   /* Insure trailing eof on output */

   if ( *buf != 0x1a )
   {
      printf( "\nTrailing EOF corrected." );
      *buf = 0x1a;
   }
   fwrite( buf, 1, 1, out );

   /* If amtread is different than reccnt, make corrections */

   if ( amtread != reccnt )
   {
      printf( "\nHmm.  It seems there are supposed to be %ld records.  Let me pencil it in...", amtread );
      fseek( out, 4L, SEEK_SET );
      fwrite( (char *) &amtread, sizeof( long ), 1, out );
   }

   /* Closeup and print final EOF count */

   fclose( in );
   fclose( out );
   printf( "\n%d EOFs corrected.", eofcount );
}
