/*Ŀ
 ݳ                                                                      
 ݳ Program Name: INIT.H            Copyright: Gallagher Computing Corp. 
 ݳ     Language: Clipper 5.0                                            
 ݳ       Author: Kevin S Gallagher                                      
 ݳ                                                                      
 Ĵ
 ݳ Comments:                                                            
 ݳ Simple header file for makezip program.                              
 ݳ                                                                      
 Ĵ
 ݳ History:                                                             
 ݳ                                                                      
 
            */

#include "fileio.ch"
#include "inkey.ch"
#include "error.ch"
#include "box.ch"

#define USING_VERSION52
#define Get_Colors "W+/RB,W+/N"
#define aPic_ { "@S48", "@!", "@!", "@S48@!", ;
                "@S48@!", "@S48@!", "@!", "@!", "@!" ;
              }

#define aBlock {|x,y| x[1] < y[1] }
#define bBlock {|x  | Showit(x[1])}
#define MR MAXROW()

// Pseudofunctions for opening/using/closing init file
#define OPEN_INIT_FILE()    oIni:= TIniFile():Use( xIniFile )
#define CLOSE_INIT_FILE()   oIni:Use()
#define WRITE_TO_INIT()     oIni:Save()

// default file types to loadup for compressing
#define MyLocalList         "PRG,BAT,CH,RMK,LNK,DBT,FPT,DBV,H,DOC"

// messages used in alert() routines in makezip.prg
#define ASK_USER_METHOD "UPDATE FILE;REMOVE FILE;EXIT PROGRAM"
#define ASK_OK_TO_DELETE "LAST CHANCE TO ABORT ERASING;"+ZIPFILE


// Pseudofunctions to retrieve values from initialiation file
#define GET_TITLE()         ReadInitFile( 1 )
#define GET_LIST_FILE()     ReadInitFile( 2 )
#define GET_ZIP_FILE()      ReadInitFile( 3 )
#define GET_LOCAL_FILES()   ReadInitFile( 4 )
#define GET_OBJ_FILE()      ReadInitFile( 5 )
#define GET_LIB_FILE()      ReadInitFile( 6 )
#define GET_ZIP_NAME()      ReadInitFile( 7 )
#define GET_UNZIP_NAME()    ReadInitFile( 8 )
#define GET_COMMENT_FILE()  ReadInitFile( 9 )

#xtranslate LSTRINT( <n> )                              => ;
            ltrim( str( int( <n> ) ) )

// Pseudofunction for working with gets
#xtranslate KSGREAD( <n> )                              => ;
            ( setcursor( 3 ), readmodal( getlist, <n> ),   ;
            setcursor(0),!( lastkey() = 27 )               )

#xtranslate StableOne( <o> )                            => ;
            <o>:refreshcurrent():forcestable()

#xtranslate ForceRefresh( <o> )                         => ;
            <o>:forcestable();<o>:refreshall()

#xcommand DEFAULT <param> TO <value>                    => ;
          IF <param> == NIL ; <param> := <value> ; END 

#xcommand FWriteLine( <h>, <s> )                        => ;
          FWrite( <h>, <s> + CHR(13) + CHR(10) )

// the following are from Steve Straley/reworked by Kevin S. Gallagher
#xcommand local <exp1>[,<exp2>][,<exp3>][,<exp4>][,<exp5>] as chars     => ;
          local <exp1>\:="";
              [,<exp2>\:=""];
              [,<exp3>\:=""];
              [,<exp4>\:=""];
              [,<exp5>\:=""]


#xcommand local <exp1>[,<exp2>][,<exp3>][,<exp4>][,<exp5>] as ints      => ;
          local <exp1>\:=0;
              [,<exp2>\:=0];
              [,<exp3>\:=0];
              [,<exp4>\:=0];
              [,<exp5>\:=0]

#xcommand local <exp1>[,<exp2>][,<exp3>][,<exp4>][,<exp5>] as arrays    => ;
          local <exp1>\:={};
              [,<exp2>\:={}];
              [,<exp3>\:={}];
              [,<exp4>\:={}];
              [,<exp5>\:={}]
// end of Steve Straley commands


#define SaveFullScreen() oldscrn := savescreen( 0, 0, maxrow(), maxcol() )
#define RestFullScreen() restscreen( 0, 0, maxrow(), maxcol(), oldscrn )


*****************************************************************************
* manifest constants for various code for TinitClass *
*****************************************************************************
#define MAIN_TITLE   "main"       , "title"     
#define LIST_FILE    "SetUpFiles" , "ListFile"  
#define ZIP_FILE     "SetUpFiles" , "ZipFile"   
#define EXT_LIST     "Backups"    , "filetypes" 
#define OBJ_LIST     "Backups"    , "xObj"      
#define LIB_LIST     "Backups"    , "xLib"      
#define ZIP_NAME     "ZipNames"   , "Packer"    
#define UNZIP_FILE   "ZipNames"   , "UnPacker"  
#define COMMENT_FILE "ZipNames"   , "NoteFile"  
