/*

   CONINDEX.CH -- Utility macros and commands for CONINDEX.PRG

*/


// General neatness for functions that have multiple RETURN() statments.
#command END FUNCTION => RETURN ( NIL )

// Compile test stub
#define TESTMAIN

// Foxpro Weenie Emulation Mode
#define FOXPRO_WEENIE

// Constants to make totalling code block easier to read
#define BUCKET 2
#define BLOCK  1

// Standard TRUE/FALSE stuff

#ifndef TRUE
   #define TRUE .T.
#endif

#ifndef FALSE
   #define FALSE .F.
#endif

#define UNIQUE_KEY "+str(recno(),8)"

// Variation on Greg Lief's MAKEBLOCK UDC.  Allows you to make macro
// compiled code blocks much more readable. Thanks Greg!
//

#xtranslate MACROBLOCK(<string>) =>  &("{ | | " + <string> + "}")

// ---------------------------------------------------------------------------
// Here it is, the moment we have all been waiting for!  The CONINDEX command!
// ---------------------------------------------------------------------------
#command CONDINDEX <index>      ;
         QUERY <query>          ;
         KEY <key>              ;
         [TOTAL <total> ]       ;
         [COUNTER <counter>]    ;
         [DISPLAY <dblock>] =>   ;
         conindex(<(index)>,<(query)>,<(key)>,<total>,@<counter>,<{dblock}>)

// ---------------------------------------------------------------------------
// For FOXPRO 2.0 Weenies only!  The Foxpro version of the same command!
// ---------------------------------------------------------------------------

#command INDEX ON <key>        ;
         FOR <query>           ;
         TO <(index)>          ;
         [TOTAL <total> ]      ;
         [COUNTER <counter>]   ;
         [DISPLAY <dblock>] => ;
         conindex(<(index)>,<(query)>,<(key)>,<total>,@<counter>,<{dblock}>)


// ---------------------------------------------------------------------------
// Yet another command to handle reopening the database file later on and
// "remembering" the original filtering condition, something that is necessary
// to keep that initial record from bleeding through...
// ---------------------------------------------------------------------------

#command SET INDEX TO [ <(index1)> [FILTERED BY <query1>]             ;
                      [, <(indexn)> [FILTERED BY <queryn>] ] ]        ;
                                                                      ;
      => dbClearIndex()                                               ;
      [; dbSetIndex( <(index1)> )   ]          ;
      [;dbSetFilter( <{query1}>, <(query1)> )] ;
      [; dbSetIndex( <(indexn)> )   ]          ;
      [;dbSetFilter( <{queryn}>, <(queryn)> )]                            
