**************************************************************************
* System....: Code 39 and Interleave 2 of 5 Barcode Printer
* Program...: COD3&2.PRG
* Version...: 2.0
* Function..: Prints Code39 Barcodes on HP LaserJet and Epson Printers.
*             Prints Interleave 2 of 5 Barcodes on HP LaserJet Printer.
*
* Source....: Clipper Summer '87
* Libraries.: CLIPPER.LIB  (c) 1985-1987 Nantucket Corporation (Summer '87)
*             EXTEND.LIB   (c) 1987 Nantucket Corporation (Summer '87)
*
* Author....: George T. Neill
*             2140 Main Street
*             La Crosse, WI  54601
*
* Created...: May 5, 1988  at 10:21 am
* Last modified: 04/04/90     13:04
*
* Copyright.: None, released to the public domain as is with no express
*             or implied warranty as to suitability or accuracy of this
*             program.  The author shall not be held liable for any
*             damages, either direct or non-direct, arising from the use
*             of this program.  This program may be modified and/or
*             included in any program without any consideration to the
*             author.

*  Procs & Fncts: SETUP_HP
*               : SETUP_EPSON
*               : DEF_CODE39
*               : DEF_I2OF5
*               : BARCODE()
*               : PRINTCODE()
*
*          Calls: SETUP_HP       (procedure in CODE32.PRG)
*               : SETUP_EPSON    (procedure in CODE32.PRG)
*               : DEF_CODE39     (procedure in CODE32.PRG)
*               : DEF_I2OF5      (procedure in CODE32.PRG)
*               : BARCODE()      (function  in CODE32.PRG)
*
*      Documented 04/04/90 at 13:12                SNAP!  version 4.00
*************************** ALL RIGHTS RESERVED **************************
* Revisions:
* Date        Time   Who   Change Description
* -
*	30-Mar-90  7:59am	GTN	Added Interleave 2 of 5 Barcode Functions.
*									This file is virtually the same as the
*									original CODE39 program except for the 2of5
*									additions.
*
**************************************************************************
**************************************************************************
*****                                                                *****
*****  This dBase code originated from a basic program written by    *****
*****  Bill Wood of Milwaukee, WI in May of 1985.  I have, of course,*****
*****  converted it to dBase and added support for the HP LaserJet.  *****
*****                                                                *****
*****  Because of the wide variety and quality of bar code readers   *****
*****  and barcode print quality when using a dot matrix printer, I  *****
*****  strongly recommend using a laser printer for your barcodes.   *****
*****  Also, the you will get 7 characters per inch on the laser as  *****
*****  opposed to 5.6 cpi on a dot matrix.                           *****
*****                                                                *****
*****  The LaserJet barcodes are generated using the pattern fill    *****
*****  functions and do not require the use of any font cartridges   *****
*****  or soft fonts.  The tricky part of using this method is       *****
*****  following the HP cusor location on the printed page.  Please  *****
*****  refer to the HP LaserJet Technical Reference Manual for a     *****
*****  thorough explanation of this.  Currently, the program is      *****
*****  setup to print at 6 lines per inch.  That is, a height of 1   *****
*****  is equal to one line.                                         *****
*****                                                                *****
*****  The program requires two functions, the printer setup, and    *****
*****  the barcode creation.  The printer setup defines the          *****
*****  components of the barcode and the barcode creation builds     *****
*****  the barcode from a passed character string.  Using this       *****
*****  program as an example you should be able to generate a        *****
*****  barcode routine for any printer or barcode symbology.         *****
*****                                                                *****
*****  Good Luck,                                                    *****
*****        George T. Neill                                         *****
**************************************************************************
**************************************************************************
**************************************************************************
*****                 CODE 3-of-9 BAR CODE  GENERATOR                *****
*****                 *******************************                *****
*****      This program will generate standard 3-of-9 bar code       *****
*****      on any dot matrix printer which is compatable with        *****
*****      an Epson/IBM graphics printer or HP LaserJet.             *****
*****                 ******************************                 *****
*****                      -  SPECIFICATIONS -                       *****
**                                                                      **
**                         W                                 N          **
**                |  Nominal Width  | Nominal Width  | Nominal Ratio    **
**     Density    |       of        |      of        |      of          **
**   (Characters/ | Narrow Bars and | Wide Bars and  | Wide to Narrow   **
**      Inch)     | Spaces (Inches) | Spaces (Inches)| Element Width    **
**   -------------+-----------------+----------------+----------------  **
**      5.730     |     0.0125      |     0.0315     |      2.52        **
**   -------------+-----------------+----------------+----------------  **
**                                                                      **
*****                 ******************************                 *****
*****  Code 3-of-9 was developed in 1974 by Dr. David C. Allais of   *****
*****  Interface Mechanisms, Inc.  It has been adopted as the        *****
*****  standard bar code symbology of the Department of Defence      *****
*****  (MIL-STD-1189) and is the most widely used alphanumeric bar   *****
*****  code in use.  Code 3-of-9 is so called because the original   *****
*****  concept provided for 39 data characters.  The name also       *****
*****  describes the structure of the code which has 3 wide elements *****
*****  out of a total of 9.                                          *****
*****                                                                *****
*****  This program was written solely for information purposes to   *****
*****  demonstrate the structure of code 3-of-9.  The author is      *****
*****  not responsible for any damages incurred through the use of   *****
*****  this program.                                                 *****
*****                                                                *****
*****                           Bill Wood  Milwaukee, WI   05/18/85  *****
**************************************************************************


*** Program Setup
*
clear screen
public ESC,NULL,PRN_TYPE,HEIGHT

ESC = chr(27)
NULL = ""

@ 01,01 say [Code 39/Interleave 2of5 Barcode Generator]

*** set defaults
*
CODE_TYPE = "C"               && (C)ode39 or (I)interleave 2of5
PRN_TYPE  = "L"               && (L)aserJet or (E)pson
ORIENT    = "P"               && (P)ortrait or (L)andscape
width     = 3                 && Size of narrow bar
HEIGHT    = 2                 && Number of lines of barcode @ 6 lpi

@ row()+2,01 say [Print (C)ode39 or (I)interleave 2of5?] ;
   get M->CODE_TYPE ;
   picture '@!' ;
   valid M->CODE_TYPE$'CI'

@ row()+1,01 say [Print on (E)pson or (L)aserJet?] ;
   get M->PRN_TYPE ;
   picture '@!';
   valid M->PRN_TYPE$'EL'

if PRN_TYPE = 'L'
   @ row()+1,01 say [Print in (P)ortrait or (L)andscape mode?] ;
      get M->ORIENT ;
      picture '@!' ;
      valid M->ORIENT$'PL'
   
   @ row()+1,01 say [Enter Width of Narrow Bar (2-20)] ;
      get M->WIDTH ;
      picture '99' ;
      range 1,20
   
endif

@ row()+1,01 say [Enter Height of Barcode (1-9)] ;
   get M->HEIGHT ;
   picture '9' ;
   range 1,9

row = row()+2

read

*** Setup Printer 
*
do case
case PRN_TYPE = "L"
   do SETUP_HP
case PRN_TYPE = "E"
   do SETUP_EPSON
endcase

*** Define Barcode Characer Set to be used
*
do case
case CODE_TYPE = 'C'
   do DEF_CODE39
case CODE_TYPE = 'I'
   do DEF_I2OF5
endcase


*** Get text to print and print barcode
*
STAY = .t.
do while STAY
   *** Create empty variable.  The length is arbitrary as there is
   *   no defined maximum length of a 3of9 barcode or Interleave 2of5.
   *
   MESSAGE = space(25)
   
   @ row,01 say [Enter text to print ] ;
      get M->MESSAGE ;
      picture if(CODE_TYPE = 'C','@K!','@9')
   read
   
   if empty(M->MESSAGE)
      *** exit on no message text
      STAY = .f.
      loop
   endif
   
   set device to print
   
   *** print barcoded m->MESSAGE
   *
   P_COL = pcol() +2
   @ prow() +if(ORIENT='P', HEIGHT, 0), if(PRN_TYPE="L", P_COL, 0) say BARCODE(@MESSAGE)
   
   *** Print message text below barcode
   *
   @ prow() +if(PRN_TYPE="L",HEIGHT,0), if(PRN_TYPE="L",if(CODE_TYPE='C', int(len(M->MESSAGE)/4), P_COL), 0) say  M->MESSAGE
   @ prow(), pcol()
   set device to screen
   
   *** Check for page eject
   *   (necessary to see what you've done on a laserjet)
   *
   FORM_FEED = .f.
   @ row+3,01 say [Eject?] get FORM_FEED picture [Y]
   read
   if FORM_FEED
      eject
   endif
   
enddo

return
*** End of File CODE32 ***

*****************
***
***   Function:  Barcode()
***    Purpose:  Creates barcode from character string
*** Parameters:  Character String
***    Returns:  String converted to barcode
***      Notes:  Requires the following variables:
***           :
***           :      All printers:
***           :         nb = narrow bar character
***           :         wb = wide bar character
***           :         ns = narrow space
***           :         ws = wide space
***           :
***           :      HP LaserJet:
***           :         top = Beginning cursor position adjustment
***           :         end = Ending cursor position adjustment
***           :
***           :      Epson/IBM Printers:
***           :         height  = height of barcode in lines
***           :         n1 & n2 = calculated dot graphics length
***           :
*****************
*!*********************************************************************
*!
*!       Function: BARCODE()
*!
*!      Called by: CODE32.PRG                    
*!
*!          Calls: PRINTCODE()    (function  in CODE32.PRG)
*!
*!*********************************************************************
function BARCODE
parameters BAR_TEXT
CODE = ""

do case
case PRN_TYPE = "L"
   *** read message character at a time and build barcode
   *
   do case
   case CODE_TYPE = 'C'
      *** code39
      *
      BAR_TEXT = START +trim(BAR_TEXT) +STOP
      LENGTH = len(BAR_TEXT)
      for I = 1 to LENGTH
         LETTER = substr(BAR_TEXT, I, 1)
         CODE = CODE + if(at(LETTER, VALIDCHARS)=0, LETTER, CHARRAY_[at(LETTER, VALIDCHARS)]) + NS
      next
      CODE = TOP +CODE +END
      
   case CODE_TYPE = 'I'
      *** Interleave 2 of 5
      *
      if mod(len(trim(BAR_TEXT)),2) != 0
         BAR_TEXT = "0"+BAR_TEXT
      endif
      LENGTH = len(trim(BAR_TEXT))
      for I = 1 to LENGTH step 2
         ODDCHAR  = substr(BAR_TEXT, I, 1)
         EVENCHAR = substr(BAR_TEXT, I+1, 1)
         for J = 1 to 5
            ODDCODE  = substr(ODD_CHAR[at(ODDCHAR, VALIDCHARS)], 2*J, 2)
            EVENCODE = substr(EVEN_CHAR[at(EVENCHAR, VALIDCHARS)], 2*J, 2)
            CODE = CODE +&ODDCODE. +&EVENCODE.
         next
      next
      CODE = TOP +START +CODE +STOP +END
      
   endcase
   
case PRN_TYPE = "E"
   do case
   case CODE_TYPE = 'C'
      BAR_TEXT = START +trim(BAR_TEXT) +STOP
      LENGTH = len(BAR_TEXT)
      for H = 1 to HEIGHT
         for I = 1 to LENGTH
            LETTER = substr(BAR_TEXT, I, 1)
            *** build barcoded string
            *
            CODE = if(at(LETTER, VALIDCHARS)=0, LETTER, CHARRAY_[at(LETTER, VALIDCHARS)]) + NS
            *** print barcode character at a time on Epson
            *
            PRINTCODE(ESC +chr(76) +chr(21) +chr(0) +CODE)
         next
         *** perform 21/216 line feed
         *
         PRINTCODE(ESC +chr(74) +chr(21) +chr(13))

         *** space over to beginning of barcode
         *
         @ prow(), 0

      next
      
      *** perform 5/216 line feed
      *
      PRINTCODE(ESC +chr(74) +chr(5) +chr(13))
      
      *** reset printer to turn off graphics and reset to 10cpi
      *
      PRINTCODE(ESC +"@")
      CODE = ""
      
   case CODE_TYPE = 'I'
      *** Interleave 2 of 5
      *
      if mod(len(trim(BAR_TEXT)),2) != 0
         BAR_TEXT = "0"+BAR_TEXT
      endif
      LENGTH = len(trim(BAR_TEXT))
      for H = 1 to HEIGHT
         PRINTCODE(ESC +chr(76) +chr(6) +chr(0) +START)
         for I = 1 to LENGTH step 2
            ODDCHAR  = substr(BAR_TEXT, I, 1)
            EVENCHAR = substr(BAR_TEXT, I+1, 1)
            for J = 1 to 5
               ODDCODE = substr(ODD_CHAR[at(ODDCHAR, VALIDCHARS)], 2*J, 2)
               EVENCODE = substr(EVEN_CHAR[at(EVENCHAR, VALIDCHARS)], 2*J, 2)
               CODE = CODE +&ODDCODE. +&EVENCODE.
            next
            *** print barcode character at a time on Epson
            *
            PRINTCODE(ESC +chr(76) +chr(23) +chr(0) +CODE)
            CODE = ""
         next
         PRINTCODE(ESC +chr(76) +chr(8) +chr(0) +STOP)
         *** perform 21/216 line feed
         *
         PRINTCODE(ESC +chr(74) +chr(21) +chr(13))
         *** space over to beginning of barcode
         *
         @ prow(), 0
      next
      *** perform 5/216 line feed
      *
      PRINTCODE(ESC +chr(74) +chr(5) +chr(13))
      PRINTCODE(ESC +"@")
      CODE = ""

   endcase
   
endcase

return CODE
*** End of Function(BARCODE) ***


*****************
***
***  Procedure:  Setup_HP
***    Purpose:  Defines characters for HP LaserJet
*** Parameters:  None
***    Returns:  Initialized Public variables
***
*****************

*!*********************************************************************
*!
*!      Procedure: SETUP_HP
*!
*!      Called by: CODE32.PRG                    
*!
*!*********************************************************************
procedure SETUP_HP
public NB,WB,NS,WS,TOP,END
*** define bars and spaces for HP LaserJet II
*
SMALL_BAR = WIDTH                             && number of points per bar
WIDE_BAR = round(SMALL_BAR * 2.25,0)          && 2.25 x small_bar
DPL = 50                                      && dots per line 300dpi/6lpi = 50dpl

if ORIENT = 'P'
   *** Portrait codes
   NB = ESC+"*c"+transform(SMALL_BAR,'99')+"a"+alltrim(str(HEIGHT*DPL))+"b0P"+ESC+"*p+"+transform(SMALL_BAR,'99')+"X"
   WB = ESC+"*c"+transform(WIDE_BAR,'99')+"a"+alltrim(str(HEIGHT*DPL))+"b0P"+ESC+"*p+"+transform(WIDE_BAR,'99')+"X"
   NS = ESC+"*p+"+transform(SMALL_BAR,'99')+"X"
   WS = ESC+"*p+"+transform(WIDE_BAR,'99')+"X"
   
   *** adjust cusor position to start at top of line and return to bottom of line
   *
   TOP = ESC+"*p-50Y"
   END = ESC+"*p+50Y"
   
elseif ORIENT = 'L'
   *** Landscape codes
   NB = ESC+"*c"+transform(SMALL_BAR,'99')+"b"+alltrim(str(HEIGHT*DPL))+"a0P"+ESC+"*p+"+transform(SMALL_BAR,'99')+"Y"
   WB = ESC+"*c"+transform(WIDE_BAR,'99')+"b"+alltrim(str(HEIGHT*DPL))+"a0P"+ESC+"*p+"+transform(WIDE_BAR,'99')+"Y"
   NS = ESC+"*p+"+transform(SMALL_BAR,'99')+"Y"
   WS = ESC+"*p+"+transform(WIDE_BAR,'99')+"Y"
   
   *** adjust cusor position to start at top of line and return to bottom of line
   *
   TOP = ESC+"*p-50X"
   END = ESC+"*p+50X"
endif
return
*** End of Procedure(SETUP_HP) ***

*****************
***
***  Procedure:  Setup_Epson
***    Purpose:  Defines characters for Espon or IBM Graphics printer
*** Parameters:  None
***    Returns:  Initialized Public variables
***
*****************

*!*********************************************************************
*!
*!      Procedure: SETUP_EPSON
*!
*!      Called by: CODE32.PRG                    
*!
*!          Calls: PRINTCODE()    (function  in CODE32.PRG)
*!
*!*********************************************************************
procedure SETUP_EPSON
public NB,WB,NS,WS,N1,N2
*** define Epson bars and spaces
*
NS = chr(0) +chr(0)
WS = chr(0) +chr(0) +chr(0) +chr(0)
NB = chr(255)
WB = chr(255) +chr(255) +chr(255)

*** set printer to 2/216 lines per inch
*
PRINTCODE(ESC +chr(51) +chr(2))

return
*** End of Procedure(SETUP_EPSON) *****


*****************
***
***  Procedure:  Def_Code39
***    Purpose:  Define character set for CODE39
*** Parameters:  None
***    Returns:  Initialized Public variables and array
***
*****************

*!*********************************************************************
*!
*!      Procedure: DEF_CODE39
*!
*!      Called by: CODE32.PRG                    
*!
*!*********************************************************************
procedure DEF_CODE39
public CHARRAY_[44], VALIDCHARS, START, STOP

VALIDCHARS = "1234567890ABCDEFGHIJKLMNOPQRSTUVWXYZ-. *$/+%"
CHARRAY_[01] = WB+NS+NB+WS+NB+NS+NB+NS+WB       && "1"
CHARRAY_[02] = NB+NS+WB+WS+NB+NS+NB+NS+WB       && "2"
CHARRAY_[03] = WB+NS+WB+WS+NB+NS+NB+NS+NB       && "3"
CHARRAY_[04] = NB+NS+NB+WS+WB+NS+NB+NS+WB       && "4"
CHARRAY_[05] = WB+NS+NB+WS+WB+NS+NB+NS+NB       && "5"
CHARRAY_[06] = NB+NS+WB+WS+WB+NS+NB+NS+NB       && "6"
CHARRAY_[07] = NB+NS+NB+WS+NB+NS+WB+NS+WB       && "7"
CHARRAY_[08] = WB+NS+NB+WS+NB+NS+WB+NS+NB       && "8"
CHARRAY_[09] = NB+NS+WB+WS+NB+NS+WB+NS+NB       && "9"
CHARRAY_[10] = NB+NS+NB+WS+WB+NS+WB+NS+NB       && "0"
CHARRAY_[11] = WB+NS+NB+NS+NB+WS+NB+NS+WB       && "A"
CHARRAY_[12] = NB+NS+WB+NS+NB+WS+NB+NS+WB       && "B"
CHARRAY_[13] = WB+NS+WB+NS+NB+WS+NB+NS+NB       && "C"
CHARRAY_[14] = NB+NS+NB+NS+WB+WS+NB+NS+WB       && "D"
CHARRAY_[15] = WB+NS+NB+NS+WB+WS+NB+NS+NB       && "E"
CHARRAY_[16] = NB+NS+WB+NS+WB+WS+NB+NS+NB       && "F"
CHARRAY_[17] = NB+NS+NB+NS+NB+WS+WB+NS+WB       && "G"
CHARRAY_[18] = WB+NS+NB+NS+NB+WS+WB+NS+NB       && "H"
CHARRAY_[19] = NB+NS+WB+NS+NB+WS+WB+NS+NB       && "I"
CHARRAY_[20] = NB+NS+NB+NS+WB+WS+WB+NS+NB       && "J"
CHARRAY_[21] = WB+NS+NB+NS+NB+NS+NB+WS+WB       && "K"
CHARRAY_[22] = NB+NS+WB+NS+NB+NS+NB+WS+WB       && "L"
CHARRAY_[23] = WB+NS+WB+NS+NB+NS+NB+WS+NB       && "M"
CHARRAY_[24] = NB+NS+NB+NS+WB+NS+NB+WS+WB       && "N"
CHARRAY_[25] = WB+NS+NB+NS+WB+NS+NB+WS+NB       && "O"
CHARRAY_[26] = NB+NS+WB+NS+WB+NS+NB+WS+NB       && "P"
CHARRAY_[27] = NB+NS+NB+NS+NB+NS+WB+WS+WB       && "Q"
CHARRAY_[28] = WB+NS+NB+NS+NB+NS+WB+WS+NB       && "R"
CHARRAY_[29] = NB+NS+WB+NS+NB+NS+WB+WS+NB       && "S"
CHARRAY_[30] = NB+NS+NB+NS+WB+NS+WB+WS+NB       && "T"
CHARRAY_[31] = WB+WS+NB+NS+NB+NS+NB+NS+WB       && "U"
CHARRAY_[32] = NB+WS+WB+NS+NB+NS+NB+NS+WB       && "V"
CHARRAY_[33] = WB+WS+WB+NS+NB+NS+NB+NS+NB       && "W"
CHARRAY_[34] = NB+WS+NB+NS+WB+NS+NB+NS+WB       && "X"
CHARRAY_[35] = WB+WS+NB+NS+WB+NS+NB+NS+NB       && "Y"
CHARRAY_[36] = NB+WS+WB+NS+WB+NS+NB+NS+NB       && "Z"
CHARRAY_[37] = NB+WS+NB+NS+NB+NS+WB+NS+WB       && "-"
CHARRAY_[38] = WB+WS+NB+NS+NB+NS+WB+NS+NB       && "."
CHARRAY_[39] = NB+WS+WB+NS+NB+NS+WB+NS+NB       && " "
CHARRAY_[40] = NB+WS+NB+NS+WB+NS+WB+NS+NB       && "*"
CHARRAY_[41] = NB+WS+NB+WS+NB+WS+NB+NS+NB       && "$"
CHARRAY_[42] = NB+WS+NB+WS+NB+NS+NB+WS+NB       && "/"
CHARRAY_[43] = NB+WS+NB+NS+NB+WS+NB+WS+NB       && "+"
CHARRAY_[44] = NB+NS+NB+WS+NB+WS+NB+WS+NB       && "%"

START = '*'
STOP  = '*'

return
*** End of Procedure(DEF_CODE39) *****

*****************
***
***  Procedure:  DEF_I2of5
***     Syntax:  Define character set for Interleave 2 of 5
*** Parameters:  None
***    Returns:  Initialized Public variables and array
***      Notes:  Interleave 2 of 5 differs from Code 39 in that it
***              only defines [0-9] and the numbers are printed in a series
***              of interleaved bars and spaces.  That is the barcode
***              character for a given number is made up of either bars
***              or spaces depending on its position in the string.  The
***              first number in a string (starting from the left) is an
***              odd digit, the next is even.  Odd digits are bars and even
***              digits are spaces.  Each character consists of 2 wide
***              elements out of 5 total elements (bars or spaces).
***
*****************

*!*********************************************************************
*!
*!      Procedure: DEF_I2OF5
*!
*!      Called by: CODE32.PRG                    
*!
*!*********************************************************************
procedure DEF_I2OF5
public ODD_CHAR[10], EVEN_CHAR[10], VALIDCHARS, START, STOP

VALIDCHARS = "0123456789"

*
ODD_CHAR[1]  =  " NBNBWBWBNB"    && "0"
ODD_CHAR[2]  =  " WBNBNBNBWB"    && "1"
ODD_CHAR[3]  =  " NBWBNBNBWB"    && "2"
ODD_CHAR[4]  =  " WBWBNBNBNB"    && "3"
ODD_CHAR[5]  =  " NBNBWBNBWB"    && "4"
ODD_CHAR[6]  =  " WBNBWBNBNB"    && "5"
ODD_CHAR[7]  =  " NBWBWBNBNB"    && "6"
ODD_CHAR[8]  =  " NBNBNBWBWB"    && "7"
ODD_CHAR[9]  =  " WBNBNBWBNB"    && "8"
ODD_CHAR[10] =  " NBWBNBWBNB"    && "9"

*
EVEN_CHAR[1]  = " NSNSWSWSNS"    && "0"
EVEN_CHAR[2]  = " WSNSNSNSWS"    && "1"
EVEN_CHAR[3]  = " NSWSNSNSWS"    && "2"
EVEN_CHAR[4]  = " WSWSNSNSNS"    && "3"
EVEN_CHAR[5]  = " NSNSWSNSWS"    && "4"
EVEN_CHAR[6]  = " WSNSWSNSNS"    && "5"
EVEN_CHAR[7]  = " NSWSWSNSNS"    && "6"
EVEN_CHAR[8]  = " NSNSNSWSWS"    && "7"
EVEN_CHAR[9]  = " WSNSNSWSNS"    && "8"
EVEN_CHAR[10] = " NSWSNSWSNS"    && "9"

START = NB+NS+NB+NS
STOP  = WB+NS+NB+NS

return

*****************
***
***   Function:  Printcode
***    Purpose:  Sends escape codes to printer
*** Parameters:  Character string or escape sequence
***    Returns:  Nothing
***
*****************

*!*********************************************************************
*!
*!       Function: PRINTCODE()
*!
*!      Called by: SETUP_EPSON    (procedure in CODE32.PRG)
*!               : BARCODE()      (function  in CODE32.PRG)
*!
*!*********************************************************************
function PRINTCODE
parameters CODE
set console off
set print on
?? CODE
set print off
set console on
return NULL
*** End of Function(PRINTCODE) *****

*: EOF: CODE32.PRG

