*********************************************
*********************************************
* Program: MOUSEDEM.PRG
* Purpose: To demonstrate the BMOUSE routine:
*               Using the mouse with Clipper
*
* Author:  Bao Hoang
*******************************

public cur_opt, flag1

*******************************
* Main routine
*******************************
CHOICE1 =SPACE(1)

set wrap on
set scoreboard off
flag1 = .t.

do while flag1
  do PULL_DOWN
enddo



*********************************************
* PULL DOWN menu routines
*********************************************
procedure PULL_DOWN

* menu initialization
flag = .t.

* display the menu screen
do while .t.
  SET COLOR TO W/N,w/n
  CLEAR

  if flag
    CSR_ON()
  endif

  mprompt(01,02,"1st Choice")
  mprompt(01,22,"2nd Choice")
  mprompt(01,43,"3rd Choice")
  mprompt(01,65,"4th Choice")

  menu to choice2

  if flag
    CSR_OFF()
  else
    flag = .t.
  endif


  * perform selected option
  do case
    case choice2 =1
      do PD with 1
    case choice2 =2
      do PD with 2
    case choice2 =3
      do PD with 3
    case choice2 =4
      flag1 = .f.
      return
  endcase

enddo

********
procedure PD
parameters cur_opt

set color to

declare parr[5]

parr[1] = 'AAAAA'
parr[2] = 'BBBBB'
parr[3] = 'CCCCC'
parr[4] = 'DDDDD'
parr[5] = 'EEEEE'

notes = "This is a sample memo and is not intended to provide "
notes = notes + " any stimulation other than what it has "
notes = notes + "already provided."

set key 4 to RGHT
set key 19 to LFT

M_SET_ON(10,10)

do case
  case cur_opt = 1
    @ 02,02 to 08,12 
    for i = 1 to 5
	@ i+2,05 prompt parr[i]
    next
    menu to choice3
  case cur_opt = 2
    @ 02,22 to 08,32 
    for i = 1 to 5
	@ i+2,25 prompt parr[i]
    next
    menu to choice3
  case cur_opt = 3
    @ 02,43 to 08,53 
    for i = 1 to 4
	@ i+2,46 prompt parr[i]
    next
    @ i+2,46 prompt 'MEMO '
    menu to choice3
    if choice3 = 5 
      M_SET_OFF()
      set key 4 to
      set key 19 to
      M_SET_ON(1,1)
      memoedit(notes,12,1,23,78,.t.)    
      cur_opt = 3
      flag = .t.
    endif
endcase

M_SET_OFF()

set key 4 to
set key 19 to 

return

**********
procedure RGHT
do case
  case cur_opt = 1
	keyboard chr(27)+"2"
  case cur_opt = 2
	keyboard chr(27)+"3"
  case cur_opt = 3
	keyboard chr(27)+"1"
endcase
set key 4 to
flag = .f.
return
**********
procedure LFT
do case
  case cur_opt = 1
	keyboard chr(27)+"3"
  case cur_opt = 2
	keyboard chr(27)+"1"
  case cur_opt = 3
	keyboard chr(27)+"2"
endcase
set key 19 to
flag = .f.
return

FUNCTION MPROMPT
  private t_off, f_char, f_len
  mretval = .F.
 if pcount() = 3
   parameters a, b, c
   t_off = (a * 80) + b
   f_len = len(c)
   fchar = asc(substr(c,1,1))
   @a,b prompt c
   do ld_scr with t_off, f_len, f_char
   mretval = .t.
 endif
return(mretval)

