/*=======================================================================*
*
* program:  c.c
*   dated:  02/23/90
*  author:  Steve Rice
*           3828 Country Creek Way
*           Eagan, MN  55122
*
*           Compuserve:  72427, 2777
*
*  notice:  Copyright (c) 1990 Steve Rice, All rights reserved
* purpose:  This Microsoft C 5.1 program contains functions called
*           from Clip.prg to demonstrate how to use C with Clipper.
*
*              The routines contained in this program file (c.c) 
*              are entered into the public domain.
*
* disclaimer:  These routines were developed solely for demonstration
*              purposes and are provided on an "as is" basis, with
*              no implied warranty regarding fitness for any particular
*              purpose.  I, Steve Rice (the author), will not be liable
*              for any damages, real, or imagined, direct or indirect 
*              resulting from the use of this software.
*
*=======================================================================*/

#include <string.h>
#include <malloc.h>
#include <stdio.h>
#include <stdlib.h>
#include <dos.h>

#include "c:\clipper\c\nandef.h"
#include "c:\clipper\c\extend.h"

/*======================================================================*/
/* function prototypes */

CLIPPER reverse_st(void);
CLIPPER ktom(void);
CLIPPER convdtoh(void);
CLIPPER filecr(void);
CLIPPER filedir(void);
int     numberoffiles(char *);

CLIPPER filedel(void);
int     del_it(char *filename);

CLIPPER ret_stack(void);
CLIPPER randfile(void);
CLIPPER getenvvar(void);
CLIPPER putenvvar(void);
CLIPPER memavail(void);
CLIPPER maxmem(void);
CLIPPER nearheap(void);
CLIPPER farheap(void);
char *  ret_val(int);

CLIPPER heapwalk(void);
CLIPPER expand(void);
CLIPPER change_dir(void);
CLIPPER on_exit(void);
void    del_temp(void);

CLIPPER exit_0(void);
CLIPPER month_txt(void);
CLIPPER c_ave(void);

/* end prototypes */
/*=======================================================================*
*
*   function:  reverse_st
*      dated:  02/23/90
*     author:  Steve Rice
*     notice:  Copyright (c) 1990 Steve Rice, All rights reserved
*    purpose:  this function will reverse the characters in a string
*              also a Clipper function is called from within C
*
* parameters:  _parc(1) - Clipper parameter - a string to be reversed
*
*    returns:  _retc()  - Clipper return value of reversed string
*
*=======================================================================*/

extern CLIPPER show_help();

CLIPPER reverse_st()
{
   char *string= _parc(1);

   show_help();   

   _retc(strrev(string));
}

/* end reverse_st */
/*======================================================================*
*
*   function:  ktom
*      dated:  02/23/90
*     author:  Steve Rice
*     notice:  Copyright (c) 1990 Steve Rice, All rights reserved
*    purpose:  this function return the miles converted from given
*              kilometers
*
* parameters:  _parnd(1) - Clipper parameter - a double repsenting 
*                          kilometers to be converted to miles
*
*    returns:  _retnd()  - Clipper return value miles as a double
*
*=======================================================================*/

CLIPPER ktom()
{
   double kilometers= 0.0;
   double miles= 0.0;
   
   if (PCOUNT == 1 && ISNUM(1)) {
      kilometers= _parnd(1);
      miles= (kilometers * .6);

   }
   _retnd(miles);
   
   return;
}

/* end ktom */
/*======================================================================*
*
*   function:  convdtoh
*      dated:  02/23/90
*     author:  Steve Rice
*     notice:  Copyright (c) 1990 Steve Rice, All rights reserved
*    purpose:  this function converts a Clipper integer to a string
*              representing the hexadecimal equivalent
*
* parameters:  _parni(1) - Clipper parameter - an integer repsenting 
*                          a number to be converted to hexadecimal
*
*    returns:  _retc()   - Clipper return value hexadecimal number as a
*                          string
*
*=======================================================================*/

CLIPPER convdtoh()
{
   int number;
   char string[128];

   if (PCOUNT == 1 && ISNUM(1)) {
      number= _parni(1);

      sprintf(string, "%x", (unsigned int) number);
      _retc(string);
   }
   else {
      _retc(NULL);
   }
   return;
}

/* end convdtoh */
/*======================================================================*
*
*   function:  filecr
*      dated:  02/23/90
*     author:  Steve Rice
*     notice:  Copyright (c) 1990 Steve Rice, All rights reserved
*    purpose:  this function creates a file
*
* parameters:  _parc(1) - Clipper parameter - file to be created as
*                          a string
*
*    returns:  _retc()  - Clipper return value - a message
*
*=======================================================================*/

CLIPPER filecr()
{
   FILE *newfile;
   int stringlen;
   char file[14];
   char message[128];
   
   if (PCOUNT == 1 && ISCHAR(1)) {
      
      strcpy(file, _parc(1));

      if ((newfile= fopen(file, "w+")) == NULL) {
         sprintf(message, "Could not create file %s.", file);
         _retc(message);
      }
      else {
         fclose(newfile);
      
         sprintf(message, "%s file created.", file);
         _retc(message);
      
      }
      
   }
   return;
}

/* end filecr */
/*======================================================================*
*
*   function:  filedir
*      dated:  02/23/90
*     author:  Steve Rice
*     notice:  Copyright (c) 1990 Steve Rice, All rights reserved
*    purpose:  this function finds the number of files matching the
*              mask passed as a parameter
*
* parameters:  _parc(1) - Clipper parameter - files to find as
*                          a string
*
*    returns:  _retni() - Clipper return value - number of files found
*
*=======================================================================*/

CLIPPER filedir()
{
   int stringlen;
   int  numberfound= 0;
   char file[14];
   
   if (PCOUNT == 1 && ISCHAR(1)) {

      strcpy(file, _parc(1));

      numberfound= numberoffiles(file);

   }
   _retni(numberfound);

   return;
}

/* end filedir */
/*======================================================================*
*
*   function:  numberoffiles
*      dated:  02/23/90
*     author:  Steve Rice
*     notice:  Copyright (c) 1990 Steve Rice, All rights reserved
*    purpose:  this function finds the number of files matching the
*              mask passed as a parameter
*
* parameters:  char *filename  - pointer to a string containing file mask
*
*    returns:  int numberfound - number of files matching the mask
*
*=======================================================================*/

int numberoffiles(char *filename)
{
   int numberfound= 0;
   struct find_t f;
   register int done;
   
   done= _dos_findfirst(filename, _A_NORMAL, &f);
   while (!done) {
      numberfound++;
      done= _dos_findnext(&f);
   }
   return (numberfound);
}

/* end numberoffiles */
/*======================================================================*
*
*   function:  filedel
*      dated:  02/23/90
*     author:  Steve Rice
*     notice:  Copyright (c) 1990 Steve Rice, All rights reserved
*    purpose:  this function deletes files matching a the mask passed
*
* parameters:  _parc(1) - Clipper parameter - files to delete
*                          a string
*
*    returns:  _retni() - Clipper return value - number of files deleted
*
*=======================================================================*/

CLIPPER filedel()
{
   int  stringlen;
   int  numberfound= 0;
   char file[14];
   
   if (PCOUNT == 1 && ISCHAR(1)) {

      strcpy(file, _parc(1));

      numberfound= del_it(file);

   }
   _retni(numberfound);

   return;

}

/* end filedel */
/*======================================================================*
*
*   function:  del_it
*      dated:  02/23/90
*     author:  Steve Rice
*     notice:  Copyright (c) 1990 Steve Rice, All rights reserved
*    purpose:  this function deletes files matching the mask passed
*
* parameters:  char *filename  - pointer to a string containing file mask
*
*    returns:  int numberfound - number of files matching the mask
*
*=======================================================================*/

int del_it(char *filename)
{
   int numberfound= 0;
   struct find_t f;
   register int done;

   done = _dos_findfirst(filename,_A_NORMAL, &f);
   while(!done)
   {
      if (remove(f.name) != 0)
      {
         return (-1);
      }
      numberfound++;
      done= _dos_findnext(&f);
   }
   return (numberfound);  /* normal termination */
}

/* end func del_it */
/*======================================================================*
*
*   function:  Ret_Stack
*      dated:  02/23/90
*     author:  Steve Rice
*     notice:  Copyright (c) 1990 Steve Rice, All rights reserved
*    purpose:  this function returns the amount of stack space available
*
* parameters:  none
*
*    returns:  _retni - a Clipper value for the stack space available
*
*=======================================================================*/

CLIPPER Ret_Stack()
{
   _retni(stackavail());

   return;
   
}

/* end Ret_Stack */
/*======================================================================*
*
*   function:  randfile
*      dated:  02/23/90
*     author:  Steve Rice
*     notice:  Copyright (c) 1990 Steve Rice, All rights reserved
*    purpose:  this function returns a random file name, either in the
*              directory specified by TMP or if TMP is not set, to the
*              the directory passed
*
* parameters:  _parc(1) - Clipper string for the directory to use
*              _parc(2) - Clipper string for prefix to use
*
*    returns:  _retc    - a Clipper string for the random filename
*
*=======================================================================*/

CLIPPER randfile()
{
   char dir[128];
   char prefix[5];
   char filename[128];

   if (PCOUNT == 2 && ISCHAR(1) && ISCHAR(2)) {
      strcpy(dir,    _parc(1));
      strcpy(prefix, _parc(2));
      strcpy(filename, tempnam(dir, prefix));
   }
   else {
      strcpy(filename, "");
   }
   _retc(filename);
   return;
}

/* end randfile */
/*======================================================================*
*
*   function:  getenvvar
*      dated:  02/23/90
*     author:  Steve Rice
*     notice:  Copyright (c) 1990 Steve Rice, All rights reserved
*    purpose:  this function returns a setting to a particular
*              environment variable
*
* parameters:  _parc(1) - Clipper string for an environment variable
*
*    returns:  _retc    - a Clipper string for the environment variables
*                         setting
*
*=======================================================================*/

CLIPPER getenvvar()
{
   char *var;
   
   if (PCOUNT == 1 && ISCHAR(1)) {
      if ((var= getenv(_parc(1))) == NULL)
         _retc("Environment variable not found");
      else
         _retc(var);
   }
   else {
      _retc("Error:  passing parameters");
   }
   
   return;
}

/* end getenvvar */
/*======================================================================*
*
*   function:  putenvvar
*      dated:  02/23/90
*     author:  Steve Rice
*     notice:  Copyright (c) 1990 Steve Rice, All rights reserved
*    purpose:  this function modifies the value of an environment
*              variable passed as a parameter
*
*       note:  this function works with a copy of your environment table
*              so that any changes will be lost when you exit to DOS,
*              however if you call another program with the spawn
*              functions, you can pass your altered environment on to
*              the called program
*
* parameters:  _parc(1) - Clipper string for an environment variable and
*                         new setting
*
*    returns:  _retc    - a message as a Clipper string
*
*=======================================================================*/

CLIPPER putenvvar()
{
   char *var;
   
   if (PCOUNT == 1 && ISCHAR(1)) {
      if ((putenv(_parc(1))) == -1)
         _retc("Error defining environment var");
      else
         _retc("Added to environment table");
   }
   else {
      _retc(NULL);
   }
   
   return;
}

/* end putenvvar */
/*======================================================================*
*
*   function:  memavail
*      dated:  02/23/90
*     author:  Steve Rice
*     notice:  Copyright (c) 1990 Steve Rice, All rights reserved
*    purpose:  this function returns the number of bytes that can be 
*              allocated in the default data segment.
*
* parameters:  none
*
*    returns:  _retni - a number representing number of bytes avaialbe
*
*=======================================================================*/

CLIPPER memavail()

{
   unsigned int memory;

   memory= _memavl();

   (char *) malloc(memory);

   _retni((int) memory);

   return;

}

/* end memavail */
/*======================================================================*
*
*   function:  maxmem
*      dated:  02/23/90
*     author:  Steve Rice
*     notice:  Copyright (c) 1990 Steve Rice, All rights reserved
*    purpose:  this function returns the maximum number of 
*              contiguous bytes that can be allocated in the default
*              data segment.
*
* parameters:  none
*
*    returns:  _retni - a number representing number of contiguous 
*                       bytes avaialbe
*
*=======================================================================*/

CLIPPER maxmem()
{
   unsigned int memory;

   memory= _memmax();

   _retni((int) memory);

   return;

}

/* end maxmem */
/*======================================================================*
*
*   function:  nearheap
*      dated:  02/23/90
*     author:  Steve Rice
*     notice:  Copyright (c) 1990 Steve Rice, All rights reserved
*    purpose:  this function returns the status of the near heap
*
* parameters:  none
*
*    returns:  _retc - a message containing the status of the near heap
*
*=======================================================================*/

CLIPPER nearheap()
{
   char near *buffer;
   int heapstatus;

   buffer= (char near *) _nmalloc(500);
   _nmalloc(800);
   _nfree((void near *) buffer);

   heapstatus= _nheapchk();
   _retc(ret_val(heapstatus));
   return;

}

/* end nearheap */
/*======================================================================*
*
*   function:  farheap
*      dated:  02/23/90
*     author:  Steve Rice
*     notice:  Copyright (c) 1990 Steve Rice, All rights reserved
*    purpose:  this function returns the status of the far heap
*
* parameters:  none
*
*    returns:  _retc - a message containing the status of the far heap
*
*=======================================================================*/

CLIPPER farheap()
{
   char far *buffer;
   int heapstatus;

   buffer= (char far *) _fmalloc(500);
   _fmalloc(800);
   _ffree((void far *) buffer);

   heapstatus= _fheapchk();
   _retc(ret_val(heapstatus));
   return;


}

/* end farheap */
/*======================================================================*
*
*   function:  ret_val
*      dated:  02/23/90
*     author:  Steve Rice
*     notice:  Copyright (c) 1990 Steve Rice, All rights reserved
*    purpose:  this function returns a status message from a check of
*              the near or far heap
*
* parameters:  int status - the status returned from the heap checking
*                           routine
*
*    returns:  char *     - a pointer to a string containing a message
*
*=======================================================================*/

char *ret_val(int status)
{

   switch(status) {
      case _HEAPOK:
         return("Heap OK             ");
      case _HEAPEMPTY:
         return("Heap not initialized");
      case _HEAPBADBEGIN:
         return("Heap header bad     ");
      case _HEAPBADNODE:
         return("Heap has bad node   ");

   }

   return("No return message   ");
}

/* end ret_val */
/*======================================================================*
*
*   function:  heapwalk
*      dated:  02/23/90
*     author:  Steve Rice
*     notice:  Copyright (c) 1990 Steve Rice, All rights reserved
*    purpose:  this function will traverse the entries in the default
*              heap, each call will return the address of the next block
*              of memory in the heap, whether it is free or in use, and
*              its size
*
* parameters:  none
*
*    returns:  _retc - a message containing the status of the next heap
*                      entry
*
*=======================================================================*/

CLIPPER heapwalk()
{
   char string[60];
   static int temp= 0;
   static int heapstatus;
   static struct _heapinfo heapentry;

   if (temp == 0) {
      temp++;
      heapentry._pentry= NULL;
   }
   while ((heapstatus= _heapwalk(&heapentry)) == _HEAPOK) {
      sprintf(string, "Addr: %p  Stat: %6s  Size: %5u",
               heapentry._pentry, 
               (heapentry._useflag == _FREEENTRY ? "FREE" : "USED"),
               heapentry._size);
      _retc(string);
      return;
   }
   _retc("Finished                     ");

   return;
}

/* end heapwalk */
/*======================================================================*
*
*   function:  expand
*      dated:  02/23/90
*     author:  Steve Rice
*     notice:  Copyright (c) 1990 Steve Rice, All rights reserved
*    purpose:  this function will attempt to expand the size of an
*              allocated block of memory
*
* parameters:  none
*
*    returns:  _retni - 0 if malloc(80) fails
*                      -1 if _expand()  fails
*                      size of new block if _expand is successfull
*
*=======================================================================*/

CLIPPER expand()
{
   size_t max_bytes= 65000;
   char *buffer;

   if ((buffer= (char *) malloc(80)) == NULL) {
      _retni(0);
      return;
   }
   if (_expand((void *) buffer, max_bytes) == NULL) {
      /* _expand failed */
      _retni(-1);
      free(buffer);
      return;
   }
   max_bytes= _msize(buffer);
   _retni((int) max_bytes);
   free(buffer);
   return;
}

/* end expand */
/*======================================================================*
*
*   function:  change_dir
*      dated:  02/23/90
*     author:  Steve Rice
*     notice:  Copyright (c) 1990 Steve Rice, All rights reserved
*    purpose:  this function will change the current directory
*
* parameters:  _parc(1) - Clipper string containing directory to change to
*
*    returns:  _retl()  - true  - if change was successful
*                         false - if change directory failed
*
*=======================================================================*/

CLIPPER change_dir()
{
   if (PCOUNT == 1 && ISCHAR(1)) {
      _retl(chdir(_parc(1)) ? 0 : 1);
   }
   else{
      _retl(0);
   }
}

/* end change_dir */
/*======================================================================*
*
*   function:  on_exit
*      dated:  02/23/90
*     author:  Steve Rice
*     notice:  Copyright (c) 1990 Steve Rice, All rights reserved
*    purpose:  this function will register a function (or functions) that
*              will execute when the program terminates normally (exit(0))
*
* parameters:  none
*
*    returns:  _retl    - true  - if pointer to function was added to
*                                 terminating stack
*                         false - if pointer to function was not added to
*                                 terminating stack
*
*=======================================================================*/

void del_temp(void);

CLIPPER on_exit()
{

   _retl(atexit(del_temp) ? 0 : 1);

}

/* end on_exit */
/*======================================================================*
*
*   function:  first
*      dated:  02/23/90
*     author:  Steve Rice
*     notice:  Copyright (c) 1990 Steve Rice, All rights reserved
*    purpose:  this function will delete all files with the mask "TEMP*.*"
*              (used as a demostration of the on_exit function)
*
* parameters:  none
*
*    returns:  nothing
*
*=======================================================================*/

void del_temp()
{
	/* this will delete all files with the file mask of "_ZT*.*"
	   you might want to use this function to delete temporary files
		when you exit your Clipper program */

   del_it("_ZT*.*");
}

/* end del_temp */
/*======================================================================*
*
*   function:  exit_0
*      dated:  02/23/90
*     author:  Steve Rice
*     notice:  Copyright (c) 1990 Steve Rice, All rights reserved
*    purpose:  quits to dos with the exit code of 0 (normal termination
*
* parameters:  none
*
*    returns:  nothing
*
*=======================================================================*/

CLIPPER exit_0()
{
   exit(0);
}

/* end exit_0 */
/*======================================================================*
*
*   function:  month_txt
*      dated:  02/23/90
*     author:  Steve Rice
*     notice:  Copyright (c) 1990 Steve Rice, All rights reserved
*    purpose:  returns the text for a given month passed as an integer
*
* parameters:  _parni(1) - integer for a given month
*
*    returns:  _retc()   - character for passed month
*
*=======================================================================*/

char *months[]= {
   "January",
   "February",
   "March",
   "April",
   "May",
   "June",
   "July",
   "August",
   "September",
   "October",
   "November",
   "December",
};

CLIPPER month_txt()

{
   char *error= "Error";
   int imonth;
   
   if(ISNUM(1)) {
      imonth= _parni(1);
      imonth--;
      if (imonth >= 0 && imonth <= 11)
         _retc
         (months[imonth]);
      else
         _retc(error);
   }
   else {
      _retc(error);
   }
}

/* end month_txt */
/*======================================================================*
*
*   function:  c_ave
*      dated:  02/23/90
*     author:  Steve Rice
*     notice:  Copyright (c) 1990 Steve Rice, All rights reserved
*    purpose:  returns the average of numbers in an array
*
* parameters:  _parnfa(1,x) - numbers within an array
*              _parnfa(1,0) - total elements in array
*
*    returns:  _retnd()     - average of numbers within the array
*
*=======================================================================*/

CLIPPER c_ave()
{
   double total= 0.0;
   double avg=   0.0;
   int num_items;
   register int x;

   if (ISARRAY(1)) {
      num_items= _parinfa(1,0);
      for(x= 1; x <= num_items; ++x) {
         if (_parinfa(1,x) == NUMERIC)
            total += _parnd(1,x);
      }
      avg= total/num_items;
      _retnd(avg);
   }
   else 
      _retnd(-1.0);
}

/* end c_ave */
/*======================================================================*/
/* eof c.c */
