/*=======================================================================
    Program : testmsg.prg
    (c) 1994 BERNATH COMPUTER all rights reserved
       Date : Fri  06-03-1994   15:33:06
     System : CLIX SAMPLES
    Compile : /m/n

      Notes : shows use of various messaging functions
=======================================================================*/

#include "clxcmd.ch"

FUNCTION Main(WithMsg)
LOCAL cName:=space(30)
LOCAL cAddr:=space(48)
LOCAL cCity:=space(24)
LOCAL cState:="  "
LOCAL cZip:=space(9)
LOCAL bMsg:={|m| UserMsg(m)}

    set confirm on
    set scoreboard off
    set cursor on
    ClixSet("SYSTITLE", "CLIX MESSAGE ROUTINES DEMO")

    //-------------------------------------------------------
    setcolor("W/R,R/W,,,,+GR/R")
    // set up a 'bottom line' message style
    SET MESSAGE TO 24 CENTER COLOR "+W/R" STYLE _MT_BLINE
    ScrHead("FULL LINE Message Style",{"w/r","+gr/r","+w/b","w/r"},3)
    @ 5,10 say "Name:   " get cName ;
           message "Enter your name in Last~First format"
    @ 6,10 say "Address:" get cAddr message "Enter your address"
    @ 7,10 say "City:" get cCity message "Enter your City"
    @ 7,42 say "State:" get cState pict "!!" message "Enter your State"
    @ 7,52 say "Zip:" get cZip pict "@R 99999-9999" message "Enter your zip code"
    read

    //-------------------------------------------------------
    cName:=space(30)
    cAddr:=space(48)
    cCity:=space(24)
    cState:="  "
    cZip:=space(9)
    setcolor("N/BG,+W/N,,,,+GR/BG")
    // set up a 'StatWin()' message style
    SET MESSAGE TO 24 CENTER STYLE _MT_SWIN
    ScrHead("STATWIN Message Style",{"n/bg","+bg/bg","+w/bg","n/bg"},2)

    @ 5,10 say "Name:   " get cName ;
           message "Enter your name in Last~First format"
    @ 6,10 say "Address:" get cAddr message "Enter your address"
    @ 7,10 say "City:" get cCity message "Enter your City"
    @ 7,42 say "State:" get cState pict "!!" message "Enter your State"
    @ 7,52 say "Zip:" get cZip pict "@R 99999-9999" message "Enter your zip code"
    read


    //-------------------------------------------------------
    cName:=space(30)
    cAddr:=space(48)
    cCity:=space(24)
    cState:="  "
    cZip:=space(9)
    setcolor("W/B,+W/N,,,,+GR/B")
    // User Defined message style. Note that we use ClixSet() to load the
    // codeblock for the message function
    ClixSet("MSGUSERB", bMsg)
    SET MESSAGE TO 24 CENTER COLOR "+BG/B" STYLE _MT_USER
    ScrHead("User Defined Message Style",{"+w/b","+r/b","+gr/b","w/b"},1)

    @ 5,10 say "Name:   " get cName ;
           message "Enter your name in Last~First format"
    @ 6,10 say "Address:" get cAddr message "Enter your address"
    @ 7,10 say "City:" get cCity message "Enter your City"
    @ 7,42 say "State:" get cState pict "!!" message "Enter your State"
    @ 7,52 say "Zip:" get cZip pict "@R 99999-9999" message "Enter your zip code"
    read


    //-------------------------------------------------------
    ScrHead("Various Messaging Routines", {"w/b","+gr/b","+w/r","n/w"},1,.t.)

    MsgBox({"This is an example of a self sizing",;
            "message box (MsgBox()). Lines can be centered",;
            "or left justified, with optional",;
            "beeps and pause prompts."},;
            "+w/br",{|| blip()},.t.,.t.)

    StatMsg("StatMsg() function of up to two lines at bottom.",;
            "Will disappear in 4 seconds!",.f.,4,"+w/n")

    ch := StatPrompt("HTE","Statprompt() looks like StatMsg(), but pauses for a keystroke from an",;
                     "acceptable list: H)ere  T)here  E)verywhere",.t.,"+gr/g")

    ErrMsg("This is the ErrMsg() function")

    Confirm("Confirm prompts for Y/N and returns a logical")

    ACQ("w/b")

RETURN nil

/*-----------------------------------------------------------------------
   Function: UserMsg(cMsg)
 Parameters: cMsg - message from GET MESSAGE clause
      Notes: user defined message display function displays the message
             vertically along the left side of the screen (hey, it's just
             for illustration purposes!)
-----------------------------------------------------------------------*/
FUNCTION UserMsg(cMsg)
LOCAL cKolor:=ClixSet("MSGCOLOR"),i,nR,nC

    pushcolor(cKolor)
    for nR:=4 to 24
        devpos(nR,0)
        devout("  ")
    next
    if len(cMsg) > 0
        for i:=1 to len(cMsg)
            nR:=4+i-19*int((i-1)/19)
            nC:=int((i-1)/19)
            devpos(nR,nC)
            devout(substr(cMsg,i,1))
        next
    endif
    popcolor()
RETURN nil

