/*=======================================================================
    Program : testbr.prg
    (c) 1994 BERNATH COMPUTER all rights reserved
       Date : Wed  05-11-1994   17:35:08
     System : CLIX
    Compile : /m/n
              Use CLX testbr

      Notes : Sample program demonstrating the BROWSE command

=======================================================================*/
#include "clxcmd.ch"
#include "inkey.ch"
#include "clxbox.ch"
#include "samples.ch"

FUNCTION Main()

LOCAL aFlds:= {"KEY","NAME","COMPANY","ADDRESS1","ADDRESS2","CITY","STATE","ZIP","PHONE", "HISTORY", "SALES", "OTHERCHG", "PAYMENTS", {|| SALES+OTHERCHG+PAYMENTS} }
LOCAL aHdrs:={"Key","Contact","Company","Address","Address","City","State","Zip","Phone", "History", "Sales", "Other","Payments", "Net"}
LOCAL aPics:={"@!",NIL,NIL,NIL,NIL,NIL,"!!","99999-9999","(999)999-9999",NIL,"99999.99","99999.99","99999.99","99999.99"}
LOCAL aEdit,cKolor,nButtons,cW,dLoDate,dHiDate,GetList:={}
LOCAL aaHot,lSetMouse
LOCAL aKeys:={  {K_ALT_A, {|| alert("You pressed Alt-A")} },;
                {K_ALT_B, {|| alert("You pressed Alt-B")} }   }
#ifndef NO_MOUSE
    MouseInit(@nButtons)
    MouseOn()
    lSetMouse:=SetMouse()
#else
    lSetMouse:=.f.
#endif
    set key K_INS to keyinsert
    set scoreboard off
    setblink(.f.)

    setcolor("w/n,n/w")
    aEdit:=array(len(aFlds))
    afill(aEdit,.t.)
    aEdit[1]:=.f.
    aEdit[2]:=.f.
    aEdit[len(aEdit)]:=.f.
    cKolor := "B/W,W/B,B/W,+W/R,R/W"
    // array for browse hotspots
    aaHot:={"+W/*B,W/B",;
            {"Current Field", {|b,c| c:=b:getColumn(b:colPos), alert("Current field is "+CargoGet(c, "FNAME")+";"+;
                            Any2Str(eval(c:block)))} },;
            {"Go Top", {|b| b:goTop()} },;
            {"Go Bottom", {|b| b:goBottom()} } ;
           }
    cls
    OpenDbf("CUSTOMER","CUSTKEY",,,_DATAPATH)
    @ 0,1 say "Example1: Fields, headers, pictures specified. Edit, delete OK. Incremental Search"
    @ 2,1 say "BROWSE FROM 5,5 TO 19,75 FIELDS aFlds HEADERS aHdrs PICTURE aPics ;"
    @ 3,1 say "       COLORS cKolor EDIT aEdit DELOK LOCK 1 INCREMENTAL KEYS aKeys"
    @ 4,1 say '       HOTSPOTS aaHot TITLE "Hotspots and Editing"'
    BROWSE FROM 6,5 TO 19,75 FIELDS aFlds HEADERS aHdrs PICTURE aPics ;
           COLORS cKolor EDIT aEdit DELOK LOCK 1 INCREMENTAL ;
           HOTSPOTS aaHot TITLE "Hotspots and Editing"

    cls
    @ 0,1 say "Example2: default fields and headers. No edit, longbar"
    @ 2,1 say "BROWSE FROM 5,5 TO 18,75 COLORS cKolor LOCK 1 LONGBAR ;"
    @ 3,1 say '  TITLE "Longbar and HotKeys" KEYS aKeys '
    @ 4,1 say '  CAPTION "Alt-A  Alt-B"'
    cKolor:="BG/B,B/BG"
    BROWSE FROM 6,5 TO 18,75 COLORS cKolor LOCK 1 LONGBAR KEYS aKeys ;
           TITLE "Longbar and HotKeys" CAPTION "Alt-A   Alt-B"

    close data
    cls
    OpenDbf("INVOICE","INVCUST",,,_DATAPATH)
    @ 0,1 say "Example3: Filtered to customer JOYERO. Limited edits."
    @ 2,1 say 'BROWSE FROM 5,5 TO 18,75 FIELDS aFlds HEADERS aHdrs COLORS cKolor ;'
    @ 3,1 say '       EDIT aEdit LOCK 1 MATCH "JOYERO" TITLE "Filtered"'
    cKolor:="R/W,W/R,R/W,+GR/R"
    aFlds:={"KEY","INV_NO","ITEM_NO","TRAN_DESC","TRAN_DATE","AMOUNT"}
    aHdrs:={"Key","Inv#","Item#","Description","Date","Amount"}

    aEdit:=array(len(aFlds))
    afill(aEdit, .t.)
    aEdit[1]:=.f.
    aEdit[2]:=.f.
    aEdit[3]:=.f.
    BROWSE FROM 5,5 TO 18,75 FIELDS aFlds HEADERS aHdrs COLORS cKolor ;
           EDIT aEdit LOCK 1 MATCH "JOYERO" TITLE "Filtered"

    cls
    @ 0,1 say "Example4: Both MATCH and FOR clauses."
    @ 2,1 say 'BROWSE FROM 5,5 TO 18,75 FIELDS aFlds HEADERS aHdrs COLORS cKolor ;'
    @ 3,1 say '       LOCK 1 MATCH "JOYERO" FOR year(TRAN_DATE)=1992 ;'
    @ 4,1 say '       SEPS {"","  ",""}'
    cKolor:="N/BG,+BG/N,N/BG"
    BROWSE FROM 6,5 TO 18,75 FIELDS aFlds HEADERS aHdrs COLORS cKolor ;
           LOCK 1 MATCH "JOYERO" FOR year(TRAN_DATE)=1992 BOX B_NOBOX ;
                SEPS {"","  ",""}


    close data
    cls
    MakeDates()
    OpenDBF("DATES","DATES")
    @ 0,1 say "Example 6: RANGE filtered."
    @ 2,1 say 'BROWSE FROM 5,15 TO 18,65 RANGE {dtos(dLoDate), dtos(dHiDate)} ;'
    @ 3,1 say '       COLORS cKolor LONGBAR BOX B_SINGLE_DOUBLE SHADOW'
    do while .t.
        cW:=PopWind(7,20,10,50,"+w/g",B_SINGLE_DOUBLE,.t.,"Choose date range:")
        dLoDate:=ctod("03/01/93")
        dHiDate:=ctod("06/13/93")
        pushcolor("+w/g,+w/n")
        set cursor on
        @ 8,22 say " Low date:" get dLoDate
        @ 9,22 say "High date:" get dHiDate
        read
        popcolor()
        Unpop(cW)
        if lastkey() == K_ESC
            exit
        endif
        cKolor:="+W/G,+W/N"
        SetMouse(lSetMouse)
        BROWSE FROM 5,15 TO 18,65 RANGE {dtos(dLoDate), dtos(dHiDate)} ;
               TITLE "Range Filtered" ;
               COLORS cKolor LONGBAR BOX B_SINGLE_DOUBLE SHADOW
    enddo
    SetMouse(lSetMouse)
    close data
    erase dates.dbf
    erase ("DATES"+indexext())
RETURN NIL


STATIC FUNCTION MakeDates()
LOCAL aD:={  {"DATEF","D",8,0},;
             {"DATEC","C",32,0} }
LOCAL i,dDate:=ctod("01/01/93")
    if !file("DATES.DBF")
        dbCreate("DATES", aD)
        use DATES exclusive
        for i:=0 to 364
            append blank
            replace DATEF with dDate+i,;
                    DATEC with cdow(dDate+i)+", "+MDY(dDate+i)
        next

        index on dtos(DATEF) to DATES
        use
    endif
RETURN nil
