/*=======================================================================
    Program : dmopalet.prg
    (c) 1993 BERNATH COMPUTER all rights reserved
       Date : Mon  12-06-1993   05:44:47
     System : CLIX DEMO
    Compile : /m/n

      Notes : Palette() demo
=======================================================================*/
#include "clxcmd.ch"
#include "fades.ch"

/*-----------------------------------------------------------------------
   Function: DoPalette()
-----------------------------------------------------------------------*/
function DoPalette()
local cScr,cImg,lSetMouse
    save screen to cScr
    ResetPal()
    ScrHead("Set EGA 64 color Palette",{"n/bg","+w/bg","+w/b","n/bg"},3,.t.)
    pushcolor("+w/bg")
    @ 7,15 say " Palette(aPalSet) - set EGA palette colors "
    @ 8,15 say " ResetPal() - reset palette to standard    "
    setcolor("n/bg")
    @ 10,5 say "The IBM EGA/VGA adapter can display 16 colors out of a palette of 64."
    @ 11,5 say "The Palette() function can be used to map one or more of the 16 text "
    @ 12,5 say "mode colors into the palette of 64.                                  "
    @ 14,5 say "For example, we can change brown (G/R, color 6) to orange:           "
    @ 16,20 say " Here is Brown " color "+gr/gr"
    inkey(6)
    Palette({ {6,38} })
    @ 16,36 say " And now it's orange! " color "b/gr"
    Pause()
    @ 16,20 say repl("",35)
    @ 16,5 say "By cycling through the color palette, you can similate animation"
    @ 17,5 say "effects.                                                        "
    cImg := ReadScrn("wheel.img")
    inkey(3)
    Fade(F_CURTAIN,cImg,F_RIGHT)
    @ 23,28 say "Press ESC to exit" color "+w/n"
    #ifndef NO_MOUSE
      lSetMouse:=SetMouse(.f.)
    #endif
    do while inkey()<>27

Palette({{1,62},{2,46},{3,52},{4,4},{5,53},{6,47},{7,5},{8,13},{9,1},{10,3},{11,6},{12,10},{13,22}})
Palette({{1,22},{2,62},{3,46},{4,52},{5,4},{6,53},{7,47},{8,5},{9,13},{10,1},{11,3},{12,6},{10,10}})
Palette({{1,10},{2,22},{3,62},{4,46},{5,52},{6,4},{7,53},{8,47},{9,5},{10,13},{11,1},{12,3},{10,6}})
Palette({{1,6},{2,10},{3,22},{4,62},{5,46},{6,52},{7,4},{8,53},{9,47},{10,5},{11,13},{12,1},{10,3}})
Palette({{1,3},{2,6},{3,10},{4,22},{5,62},{6,46},{7,52},{8,4},{9,53},{10,47},{11,5},{12,13},{10,1}})
Palette({{1,1},{2,3},{3,6},{4,10},{5,22},{6,62},{7,46},{8,52},{9,4},{10,53},{11,47},{12,5},{10,13}})
Palette({{1,13},{2,1},{3,3},{4,6},{5,10},{6,22},{7,62},{8,46},{9,52},{10,4},{11,53},{12,47},{10,5}})
Palette({{1,5},{2,13},{3,1},{4,3},{5,6},{6,10},{7,22},{8,62},{9,46},{10,52},{11,4},{12,53},{10,47}})
Palette({{1,47},{2,5},{3,13},{4,1},{5,3},{6,6},{7,10},{8,22},{9,62},{10,46},{11,52},{12,4},{10,53}})
Palette({{1,53},{2,47},{3,5},{4,13},{5,1},{6,3},{7,6},{8,10},{9,22},{10,62},{11,46},{12,52},{10,4}})
Palette({{1,4},{2,53},{3,47},{4,5},{5,13},{6,1},{7,3},{8,6},{9,10},{10,22},{11,62},{12,46},{10,52}})
Palette({{1,52},{2,4},{3,53},{4,47},{5,5},{6,13},{7,1},{8,3},{9,6},{10,10},{11,22},{12,62},{10,46}})
Palette({{1,46},{2,52},{3,4},{4,53},{5,47},{6,5},{7,13},{8,1},{9,3},{10,6},{11,10},{12,22},{10,62}})
    enddo
    ResetPal()
    ScrHead("Set EGA 64 color Palette",{"n/bg","+w/bg","+w/b","n/bg"},3,.t.)
    @ 7,15 say "Here are the 64 EGA palette colors:"
    setcolor("n/gr")
    @ 10,15 clear to 16,48
    for i:=0 to 63
        Palette({ {6,i} })
        @ 11,20 say " COLOR "+str(i,2)+" " color "n/w"
        Delay(6)
    next
    Delay(18)
    ResetPal()
    popcolor()
    restore screen from cScr
    #ifndef NO_MOUSE
      SetMouse(lSetMouse)
    #endif
return NIL



