/*=======================================================================
    Program : dmono.prg
    (c) 1993 BERNATH COMPUTER all rights reserved
       Date : Tue  08-02-1994   21:55:31
     System : CLIX DEMO
    Compile : /m/n

      Notes :


    Contains: DoNet(), DoDbfOpen()
=======================================================================*/
#include "clxcmd.ch"
#include "clxbox.ch"

/*-----------------------------------------------------------------------
   Function: DoDbfOpen()
      Notes:

-----------------------------------------------------------------------*/
FUNCTION DoDbfOpen()
LOCAL cScr
    save screen to cScr
    ScrHead("Intelligent Database Open",{"b/*bg","n/*bg","+bg/b","n/bg"},3,.t.)
    pushcolor("n/*bg")
    DrawBox(6,5,19,72,"b/*bg",B_DOUBLE_SINGLE,.t.,,pDB_SPARKLE)
    @  7,7 say "The OpenDbf() function opens a database with index(es), checking"
    @  8,7 say "for the existence of all files and optionally giving the user"
    @  9,7 say "diagnostic error messages, else returning error codes."
    @ 10,12 say "OpenDbf(cDbfName [,aIndexes] [,lShareMode] [,lDispErr] ;" color "r/*bg"
    @ 11,12 say "        [,lIsTag] [,cDriver])" color "r/*bg"
    setcolor("b/*bg")
    @ 13,12 say "    cDbfName   - name of datafile to open"
    @ 14,12 say "    aIndexes   - array of index names to open"
    @ 15,12 say "    lShareMode - open exclusively if .t."
    @ 16,12 say "    lDispErr   - display diagnostic error messages"
    @ 17,12 say "    lIsTag     - if .t., index is a tag to set"
    @ 18,12 say "    cDriver    - RDD to use"
    Pause(,,"n/*bg")
    @ 10,7 clear to 18,70
    @ 11, 7 say "Return codes:" color "r/*bg"
    @ 12,12 say " 0 if opening of dbf and indexes successful, and dbf was"
    @ 13,12 say "   not previously open"
    @ 14,12 say " 1 if opening of dbfs & indexes succesful, and dbf was"
    @ 15,12 say "   already open"
    @ 16,12 say "-1 if dbf not exist"
    @ 17,12 say "-2 if index(es) not exist"
    @ 18,12 say "-3 if network access denied"

    Pause(,,"n/*bg")
    popcolor()
    restore screen from cScr
RETURN nil

/*-----------------------------------------------------------------------
   Function: DoNet()
      Notes:

-----------------------------------------------------------------------*/
FUNCTION DoNet()
LOCAL cScr
    save screen to cScr
    ScrHead("Network Functions",{"b/*bg","n/*bg","+bg/b","n/bg"},3,.t.)
    pushcolor("n/*bg")
    DrawBox(6,5,19,72,"b/*bg",B_DOUBLE_SINGLE,.t.,"Locking Functions",pDB_SPARKLE)
    @  7, 7 say "The CLIX network locking functions are modified versions of the"
    @  8, 7 say "routines found in LOCKS.PRG provided with the Clipper package:"
    pushcolor("b/*bg")
    @ 10,12 say "AddRec()  - append blank and lock record"
    @ 11,12 say "RecLock() - lock record"
    @ 12,12 say "FilLock() - lock file"
    @ 13,12 say "NetUse()  - open file in shared or exclusive mode"
    popcolor()
    @ 15, 7 say "All of the locking functions will attempt repeatedly to obtain"
    @ 16, 7 say "the lock up to the specified time limit, and then alert the user"
    @ 17, 7 say "that the lock has failed. Depending on the lAskUser parameter,"
    @ 18, 7 say "the user will be asked if they want to try the lock again."
    Pause()
    ScrollBox(7,6,18,71,-1)
    @  7, 7 say "Clipper 5.2 has the ability to support multiple record locks"
    @  8, 7 say "with the dbrlock() function. CLIX provides the MULTILOCK command"
    @  9, 7 say "which allows you to lock multiple records based on a WHILE or"
    @ 10, 7 say "FOR scope, a RANGE of record numbers, or a list of record num-"
    @ 11, 7 say "bers (available in registered version only)."
    pushcolor("r/*bg")
    @ 8,54 say "MULTILOCK"
    @ 12,7 say "Command:" color "b/*bg"
    @ 12,20 say "MULTILOCK TO <lAllLocked>      ;"
    @ 13,20 say "   [LIST <aList>]              ;"
    @ 14,20 say "   [WHILE <WHILE expr>]        ;"
    @ 15,20 say "   [FOR <FOR expr>]            ;"
    @ 16,20 say "   [RANGE <nStart> TO <nEnd>]"
    @ 18,7 say "Function:" color "b/*bg"
    @ 18,20 say "lAllLocked:=GroupLock(aList,bWhile,bFor,aRange)"
    popcolor()
    Pause()
    popcolor()
    restore screen from cScr
RETURN nil
