/*=======================================================================
    Program : dmohotsp.prg
    (c) 1993 BERNATH COMPUTER all rights reserved
       Date : Tue  07-20-1993   12:51:10
     System : CLIX DEMO
    Compile : /m/n

      Notes : demo of mouseable hot spots / buttons


    Contains: DoHotSpot()
=======================================================================*/
#include "clxcmd.ch"
#include "events.ch"
#include "hotspot.ch"
#include "clxbox.ch"


/*-----------------------------------------------------------------------
   Function: DoHotSpot()
-----------------------------------------------------------------------*/
FUNCTION DoHotSpot()
LOCAL sScr,aEvent
LOCAL nTButton1,nTButton2,nTButton3
LOCAL n3D1,n3D2,n3D3
PRIVATE lExitRequest:=.f.
    save screen to cScr
    ScrHead("Hot Spots",{"+w/r","+gr/r","+w/b","w/r"},3,.t.)
    pushcolor("+w/r")
    @  7,5 clear to 16,75
    @  7,7 say "Hotspots are areas on the screen defined to be mouse aware. When"
    @  8,7 say "the mouse is clicked, a stack is examined to see if the mouse"
    @  9,7 say "coordinates fall within one of these defined areas. If so, a code"
    @ 10,7 say "block associated with the area is evaluated. The examination starts"
    @ 11,7 say "at the top of the stack, so if there are overlapping areas, the top"
    @ 12,7 say "most level will be executed."
    @ 14,7 say "Command buttons are implementations of hotspots. They can come in"
    @ 15,7 say "a bar style like a menu bar, or as a 3D button."

    Pause(,,,"Press any key for a demonstation....")
    NewSpotStak()

    @  7,5 clear to 16,75
    @  7,7 say "Text Bar Style:"
    nTButton1 := NewButton(BTN_TEXTBAR,8,7," TextBar Button 1 ",{|| MsgBox("You pressed Text Button 1"),"w/b,b/w"},"+gr/gr")
    nTButton2 := NewButton(BTN_TEXTBAR,8,30," Sound alarm ",{|| Alarm()},"+gr/b")
    nTButton3 := NewButton(BTN_TEXTBAR,8,48," Say Howdy ",{|| MsgBox("Howdy!","+w/g")},"+gr/rb")

    setcolor("+w/w")
    DrawBox(12,5,17,75,IN,B_3D,.f.)
    @ 13,7 say "3D style"
    n3D1 := NewButton(BTN_3D,14,12," Play Mary ",{|| MaryHad()})
    n3D2 := NewButton(BTN_3D,14,29," Decisions ",{|| Dialog("Pardon me, do you have any Grey Poupon?",{"Yup","Nope","Get outta my face!"},"+gr/rb,+gr/n")})
    n3D3 := NewButton(BTN_3D,14,47," Exit ",{|| lExitRequest := .t.})

    do while !lExitRequest
        aEvent := WaitEvent()
        if aEvent[EV_TYPE] == EV_KEY .and. aEvent[EV_KEY_VAL] == 27
            exit
        endif
    enddo
    KillSpotStak()
    popcolor()
    restore screen from cScr
RETURN nil


STATIC FUNCTION WO(nT,nL,nB,nR,cKolor)
LOCAL nWH,aSpot:=array(HS_ELEMS),nNextID
    nT:=9
    nL:=26
    nB:=14
    nR:=55
    cKolor:="+gr/b"
    pushcolor(cKolor)
    nWH:=MakeWind(nT,nL,nB,nR,cKolor,B_DOUBLE,.f.)
    aSpot:={nT,nL,nB,nR,.f.,{|| Win2Top(nWH)},"",.t.}
    @ nT,nL say repl("",nR-nL+1)
    @ nT,nL say ""
    @ nB,nR say ""
    AddHotSpot(@nNextID, aSpot)
    AddHotSpot(@nNextID,{nT,nL,nT,nL,.f.,{|| MaximMin()},{.f.,nWH},.t.})
    AddHotSpot(@nNextID,{nB,nR,nB,nR,.f.,{|| SizeWin()},nWH,.t.})

    Pause()
RETURN nil

STATIC FUNCTION MaximMin()
return NIL

STATIC FUNCTION SizeWin()
RETURN nil

STATIC FUNCTION MaryHad()
  #include "notes.ch"
  Play({ {E2,_q},{D2,_q},{C2,_q},{D2,_q},{E2,_q},{E2,_q},{E2,_q},{_rest,_q}, ;
       {D2,_q},{D2,_q},{D2,_q},{_rest,_q},{E2,_q},{G2,_q},{G2,_q},{_rest,_q} })

  Play({ {E2,_q},{D2,_q},{C2,_q},{D2,_q},{E2,_q},{E2,_q},{E2,_q},{E2,_q}, ;
         {D2,_q},{D2,_q},{E2,_q},{D2,_q},{C2,_w} })
RETURN nil
