/*=======================================================================
    Program : dmoget.prg
    (c) 1993 BERNATH COMPUTER all rights reserved
       Date : Sat  09-24-1994   11:37:50
     System : CLIX DEMO
    Compile : /m/n

      Notes : Demo of enhancements to GET System

=======================================================================*/
#include "clxcmd.ch"
#include "clxbox.ch"
#include "inkey.ch"

/*-----------------------------------------------------------------------
   Function: DoGetDemo()
-----------------------------------------------------------------------*/
FUNCTION DoGetDemo()
LOCAL cScr,cW,nOpt:=1,lSetMouse:=SetMouse()
    save screen to cScr
    setblink(.f.)
    Palette({ {6,38} })
    ScrHead("GET System Enhancements",{"+w/gr","+gr/gr","gr/r","n/gr"},1,.t.)
    DrawBox(8,5,16,75,"n/*gr",,.t.)
    pushcolor("n/*gr")
    @  9,7 say "The CLIX get system is contained in a replacement GETSYSPP.PRG and"
    @ 10,7 say "the CLXCMD.CH header file. It provides GET mouseability, jump to a"
    @ 11,7 say "GET, updating of GET fields that don't have focus, and access to a"
    @ 12,7 say "number of the GET system internals which make it easier to add your"
    @ 13,7 say "own user interface objects."
    Pause(15,,"n/*gr")

    cW:=PopWind(7,5,21,75,"n/*gr",,.t.,,pDB_EXPLODE)
    setcolor("r/*gr")
    @  8,6 say "ReadPos() - get/set the ordinal position of the get object that has"
    @  9,6 say "  focus."
    @ 10,6 say "GetOrdinal() - given the name of a variable in a GetList, returns the"
    @ 11,6 say "  ordinal position in the GetList array."
    @ 12,6 say "PutGet() - puts a value into a GET variable and displays it, even"
    @ 13,6 say "  when it is not in focus."
    @ 14,6 say "Jmp2Get() - jump to a get based on mouse click."
    @ 15,6 say "ReadGetList() - returns the GetList array for the current READ layer."
    @ 16,6 say "ReadModal(GetList, bInKey, bPreGet, bPostGet) - READ can use other"
    @ 17,6 say "  than inkey(0) to access keystrokes (such as WaitEvent()), execute a"
    @ 18,6 say "  codeblock prior to executing the GET reader, execute a codeblock"
    @ 19,6 say "  upon exiting the GET reader."
    Pause(20,,"n/*gr")
    Unpop(cW)
    DrawBox(8,5,16,75,"n/gr",,.t.,,pDB_SLIDER)
    do while .t.
        SetMouse(lSetMouse)
        @ 12,27 prompt "~Updating GETS not in focus"
        @ 13,27 prompt "~Jump to a GET             "
        @ 14,27 prompt "~Post-Validating all GETS  "
        menu to nOpt colors {"n/gr","gr/n","r/gr","gr/gr","+w/gr"}
        do case
            case nOpt == 0
                exit
            case nOpt == 1
                GetUp()
            case nOpt == 2
                JumpGet()
            case nOpt == 3
                PostValGet()
        endcase
    enddo

    popcolor()

    restore screen from cScr
RETURN nil

#define _QTD1   13
#define _QTD2   14
#define _QTD3   15
#define _QTD4   16
#define _YTD    17

STATIC FUNCTION GetUp()
LOCAL GetList:={},cS,aM:=array(17)
    cS:=PopWind(6,5,18,75,"gr/r",,.t.)
    pushcolor("gr/r,n/gr")
    afill(aM, 0)
    aM[2]:=25
    aM[8]:=10
    aM[_QTD1]:=25
    aM[_QTD3]:=10
    aM[_YTD]:=35
    @ 7,8 say "This example uses PutGet() in a VALID statement on the months"
    @ 8,8 say "to automatically update the QTD and YTD totals."

    @ 10,8 say "JAN" get aM[1] pict "9999999.99" ;
      VALID UpdQ(aM,_QTD1,{1,2,3})
    @ 11,8 say "FEB" get aM[2] pict "9999999.99" ;
      VALID UpdQ(aM,_QTD1,{1,2,3})
    @ 12,8 say "MAR" get aM[3] pict "9999999.99" ;
      VALID UpdQ(aM,_QTD1,{1,2,3})

    @ 10,25 say "APR" get aM[4] pict "9999999.99" ;
      VALID UpdQ(aM,_QTD2,{4,5,6})
    @ 11,25 say "MAY" get aM[5] pict "9999999.99" ;
      VALID UpdQ(aM,_QTD2,{4,5,6})
    @ 12,25 say "JUN" get aM[6] pict "9999999.99" ;
      VALID UpdQ(aM,_QTD2,{4,5,6})


    @ 10,43 say "JUL" get aM[7] pict "9999999.99" ;
      VALID UpdQ(aM,_QTD3,{7,8,9})
    @ 11,43 say "AUG" get aM[8] pict "9999999.99" ;
      VALID UpdQ(aM,_QTD3,{7,8,9})
    @ 12,43 say "SEP" get aM[9] pict "9999999.99" ;
      VALID UpdQ(aM,_QTD3,{7,8,9})

    @ 10,60 say "OCT" get aM[10] pict "9999999.99" ;
      VALID UpdQ(aM,_QTD4,{10,11,12})
    @ 11,60 say "NOV" get aM[11] pict "9999999.99" ;
      VALID UpdQ(aM,_QTD4,{10,11,12})
    @ 12,60 say "DEC" get aM[12] pict "9999999.99" ;
      VALID UpdQ(aM,_QTD4,{10,11,12})

    @ 14, 7 say "1stQ" get aM[_QTD1] pict "9999999.99" when .f. color "+gr/r,+gr/r"
    @ 14,24 say "2ndQ" get aM[_QTD2] pict "9999999.99" when .f. color "+gr/r,+gr/r"
    @ 14,42 say "3rdQ" get aM[_QTD3] pict "9999999.99" when .f. color "+gr/r,+gr/r"
    @ 14,59 say "4thQ" get aM[_QTD4] pict "9999999.99" when .f. color "+gr/r,+gr/r"

    @ 16,30 say "YTD" get aM[_YTD] pict "9999999.99" when .f. color "+gr/r,+gr/r"
    READ
    Pause(17)


    popcolor()
    UnPop(cS)
RETURN nil


STATIC FUNCTION UpdQ(aM, nDest, aSum)
LOCAL aList:=ReadGetList(),nValue:=0
    aeval(aSum, {|e| nValue += aList[e]:varGet()})
    aList[nDest]:varPut(nValue)
    aList[nDest]:display()
    nValue:=aList[_QTD1]:varGet()+aList[_QTD2]:varGet()+aList[_QTD3]:varGet()+aList[_QTD4]:varGet()
    aList[_YTD]:varPut(nValue)
    aList[_YTD]:display()
RETURN(.t.)

#define _FIRST      1
#define _LAST       2
#define _ADDR1      3
#define _ADDR2      4
#define _CITY       5
#define _STATE      6
#define _ZIP        7
#define _PHONE      8



STATIC FUNCTION JumpGet()
LOCAL cW
LOCAL aF:={"Scott      ",;
           "Bernardi      ",;
           "P.O. Box 2387            ",;
           "                         ",;
           "Antioch          ",;
           "CA",;
           "94531",;
           "(510)778-4423" }

    cW:=PopWind(8,3,20,75,"gr/n",,.t.,,pDB_SPARKLE)
    pushcolor("gr/n,n/gr")
    VertLine(43,8,20)
    @  9,45 say "The ReadPos() function allows"
    @ 10,45 say "you to jump to any GET in the"
    @ 11,45 say "current READ layer."

    pushcolor("+gr/n")
    @ 18,5 say "F5 - First   F8 - Last "
    @ 19,5 say "F6 - Up two  F7 - down two"
    popcolor()
    set key K_F5 to ToFirst
    set key K_F6 to UpTwo
    set key K_F7 to DownTwo
    set key K_F8 to ToLast


    @  9,5 say "First Name:" get aF[_FIRST]
    @ 10,5 say " Last Name:" get aF[_LAST]
    @ 11,5 say "   Address:" get aF[_ADDR1]
    @ 12,5 say "           " get aF[_ADDR2]
    @ 13,5 say "      City:" get aF[_CITY]
    @ 14,5 say "     State:" get aF[_STATE] pict "@!"
    @ 15,5 say "       Zip:" get aF[_ZIP] pict "99999-999"
    @ 16,5 say "     Phone:" get aF[_PHONE] pict "(999)999-9999"
    READ
    Unpop(cW)
    popcolor()
    set key K_F5 to
    set key K_F6 to
    set key K_F7 to
    set key K_F8 to
RETURN nil

STATIC FUNCTION ToFirst
    ReadPos(1)
RETURN nil

STATIC FUNCTION UpTwo
LOCAL nPos:=max(ReadPos()-2,1)
    ReadPos(nPos)
RETURN nil

STATIC FUNCTION DownTwo
LOCAL nPos,nLen
    nLen:=len(ReadGetList())
    nPos:=min(ReadPos()+2, nLen)
    ReadPos(nPos)
RETURN nil

STATIC FUNCTION ToLast
LOCAL nLen
    nLen:=len(ReadGetList())
    ReadPos(nLen)
RETURN nil

#define _FIRSTN     1
#define _LASTN      2
#define _EMPNO      3
#define _HS         4
#define _HIREDATE   5
#define _SSN        6
#define _RATE       7

STATIC FUNCTION PostValGet()
LOCAL cW:=PopWind(8,3,20,75,"gr/r",B_SINGLE_DOUBLE,.t.,,pDB_SPARKLE)
LOCAL GetList:={},lSetMous:=SetMouse()
LOCAL aF:={"Scott      ","Bernardi       ","    ","H",ctod("08/11/90"),"           ",0}
    pushcolor("gr/r,r/gr")
    VertLine(43,8,20)
    @  9,45 say "Since using the mouse or"
    @ 10,45 say "ReadPos() allows you to skip"
    @ 11,45 say "over GET fields, it is a good"
    @ 12,45 say "thing to validate all the"
    @ 13,45 say "GETS after terminating the"
    @ 14,45 say "READ to make sure no required"
    @ 15,45 say "fields were left empty."

    @  9,5 say "Employee #:" get aF[_EMPNO] pict "9999" ;
      valid NotEmpty(aF[_EMPNO])
    @ 10,5 say "First Name:" get aF[_FIRSTN] ;
      valid NotEmpty(aF[_FIRSTN])
    @ 11,5 say " Last Name:" get aF[_LASTN] ;
      valid NotEmpty(aF[_LASTN])
    @ 13,5 say " Hire Date:" get aF[_HIREDATE] pict "@!"
    @ 14,5 say "Hourly/Salary:" get aF[_HS] pict "!" ;
      message "H for Hourly, S for Salaried" ;
      valid ValMsg(aF[_HS] $"HS", "Must be H or S")
    @ 15,5 say "       SSN:" get aF[_SSN] pict "999-99-9999" ;
      valid NotEmpty(strtran(aF[_SSN],"-",""))
    @ 16,5 say "      Rate:" get aF[_RATE] pict "99.99" ;
        valid ValMsg(aF[_RATE] > 0,"Whatsa matter, too cheap to pay a salary?")

    READ VALIDALL

    popcolor()
    Unpop(cW)
    SetMouse(lSetMous)

RETURN nil

