/*=======================================================================
    Program : dmogened.prg
    (c) 1993 BERNATH COMPUTER all rights reserved
       Date : Wed  06-01-1994   11:35:47
     System : CLIX DEMO
    Compile : /m/n

      Notes : demo of generic edit



    Contains:
=======================================================================*/
#include "clxcmd.ch"
#include "set.ch"

//      File CUSTOMER.DBF

#define CU_KEY                1
#define CU_NAME               2
#define CU_ADDRESS1           3
#define CU_ADDRESS2           4
#define CU_CITY               5
#define CU_STATE              6
#define CU_ZIP                7
#define CU_PHONE              8
#define CU_EXT                9
#define CU_COMPANY           10
#define CU_DIALECT           11
#define CU_SETUP             12
#define CU_SALES             13
#define CU_OTHERCHG          14
#define CU_PAYMENTS          15
#define CU_CODES             16
#define CU_HISTORY           17
#define CU_MAIL_ADDR         18
#define CU_FIRST_INV         19



/*-----------------------------------------------------------------------
   Function: DoGened()
-----------------------------------------------------------------------*/
FUNCTION DoGened()
LOCAL lSetDel:=set(_SET_DELETED, .t.)
LOCAL bEB:={|aF, nEDMode| EdCust(aF, nEDMode) }
LOCAL aSRCH:={ {"Customer Key",space(8),"@!",{|| KEY } } }
LOCAL aKolors:={"n/bg","+w/n","+w/bg","w/bg","+gr/bg"}
LOCAL aaOpt:={{"~More", "More Options Menu"},;
              { ;
                {"+w/r","+r/w","+gr/r","gr/r","+gr/bg"},;
                {"Total ~Sales" ,"Calculate Total Sales", {|| CalcSales()}, .t.},;
                {"~List" ,"List Customers", {|| ListCust()}, .t.} ;
              } ;
             }

    select 0
    OpenDbf("CUSTOMER", "CUSTKEY")                  // open CUSTOMER file
    go top

    // use command format for invoking GenericEd()
    EDIT WITH bEB ;
         TITLE "Customer File Maintenance" ;
         COLORS aKolors ;
         OPTIONS aaOpt  ;
         LOCK 1         ;
         SEARCH aSRCH
    close data
    set(_SET_DELETED, lSetDel)
RETURN nil


/*-----------------------------------------------------------------------
   Function: EdCust(aF, nEDMode)
 Parameters: aF - scatter() array of fields
             nEdMode - 0=view, 1=add, 2=edit
    Returns: Key to the record
      Notes: UDF to define screen layout and GETS for CUSTOMER.DBF as
             called by GenericEd()

-----------------------------------------------------------------------*/
FUNCTION EdCust(aF, nEDMode)
LOCAL cKey:=NIL,GetList:={}
    @  5,3 say "Key    :" get aF[CU_KEY] pict "@!" ;
      message "Key = 1st 5 letters of last name + 1st 2 letters of 1st name" ;
      valid NotEmpty(aF[CU_KEY],,"+gr/bg")

    @  5,30 say "Name:" get aF[CU_NAME] ;
      message "Contact Name"

    @  7,3 say "Address:" get aF[CU_ADDRESS1] ;
       message "Enter Address"

    @  8,3 say "        " get aF[CU_ADDRESS2] ;
       message "Enter Address"

    @  9,3 say "City   :" get aF[CU_CITY] ;
       message "Enter City"

    @  9,35 say "State:" get aF[CU_STATE] pict "@!" ;
       message "Enter State"

    @  9,45 say "Zip:" get aF[CU_ZIP] pict "99999-9999" ;
       message "Enter Zip Code"

    @ 10,3 say "Phone  :" get aF[CU_PHONE] pict "(999)999-9999" ;
      message "Enter Phone"

    @ 10,35 say "Ext:" get aF[CU_EXT] pict "9999" ;
      message "Enter Phone Extension"

    @ 12,3 say "Company:" get aF[CU_COMPANY] ;
      message "Enter Company Name, if applicable"

    @ 14, 3 say "      SALES         OTHER        PAYMENTS"

    @ 15, 6 get aF[CU_SALES] pict "99999.99" ;
      valid DispNet(aF)

    @ 15,20 get aF[CU_OTHERCHG] pict "99999.99" ;
      valid DispNet(aF)

    @ 15,36 get aF[CU_PAYMENTS] pict "99999.99" ;
      valid DispNet(aF)

    @ 15,50 say "Net: "+transform(aF[CU_SALES]+aF[CU_OTHERCHG]+aF[CU_PAYMENTS],"99999.99")


    if nEDMode>0
        read
        if lastkey() <> 27
            cKey:=aF[CU_KEY]
        endif
    else
        clear gets
    endif
return(cKey)

// ======================================================================
//  Below are support functions called by the Options menu
// ======================================================================

/*-----------------------------------------------------------------------
   Function: CalcSales()
    Returns: nil
      Notes: sums the CUSTOMER->SALES field to get the total sales, and
             displays it in an Alert() box.
-----------------------------------------------------------------------*/
STATIC FUNCTION CalcSales()
LOCAL nRecNo:=recno(),nSales:=0
    go top
    SUM SALES to nSales
    Dialog("Total sales are "+Currency(nSales))
    go nRecNo
RETURN nil

STATIC FUNCTION ListCust()
    Dialog("List Customers")
RETURN nil

STATIC FUNCTION DispNet(aF)
    @ 15,50 say "Net: "+transform(aF[CU_SALES]+aF[CU_OTHERCHG]+aF[CU_PAYMENTS],"99999.99")
RETURN(.t.)


