/*=======================================================================
    Program : testsky.prg
    (c) 1994 BERNATH COMPUTER all rights reserved
       Date : Sat  05-14-1994   06:43:37
     System : CLIX SAMPLES
    Compile : Clx testsky

      Notes : The following code implements a fully functional tbrowse,
              with the ability to specify a locate expression by pressing
              Alt-L, editing the highlighted cell by pressing ENTER, or
              popup a help screen by pressing F1, in addition to the
              standard tbrowse keys.

=======================================================================*/
#include "inkey.ch"
#include "clxcmd.ch"
#include "samples.ch"

#define HEADSEP  ""       // 205, 209, 205
#define COLSEP   "  "       // 179
#define FOOTSEP  ""       // 205, 207, 205

FUNCTION Main()
local aKeys:={}, nKey, oTB, i, lExitReq:=.f., lHandled

    aKeys := {   {K_F1,      {|b| tbhelp(b)}     }, ;
                 {K_ALT_L,   {|b| LocateRec(b)}  }  ;
             }
    OpenDbf("CUSTOMER", "CUSTKEY",,,_DATAPATH)
    oTB:=tbrowsedb(2,5,19,75)
    // load columns into tbrowse object
    for i:=1 to fcount()
        oTB:AddColumn(TBColumnNew(field(i), fieldblock(field(i))))
    next
    // load separator characters into tbrowse object
    oTB:HeadSep := HEADSEP
    oTB:ColSep  := COLSEP
    oTB:FootSep := FOOTSEP

    cls
    SetUpKeys(aKeys)    // load key definitions for tbrowse
    @ 0,5 say "F1 Help   Alt-L Search   ENTER to Edit   ESC to Exit"

    do while !lExitReq
        while !oTB:stabilize()          // stabilize loop
        enddo
        if oTB:stable
            nKey := inkey(0)            // get a keystroke
            // standard keystroke processing
            lHandled := BrowKeys(nKey, oTB)
            if !lHandled         // key not handled in SetupKeys()
                do case
                    case nKey == K_ESC          // exit browse
                        lExitReq := .t.
                    case nKey == K_ENTER
                        EditCell(oTB)
                endcase
            endif
        endif
    enddo
    close data
    return

// A 'Help Screen'. Just to show that it works
STATIC FUNCTION tbhelp(b)
LOCAL cScr:=savescreen(0,0,maxrow(),maxcol())
    pushcolor("n/bg")
    cls
TEXT

    TBROWSE HELP SCREEN

    F1:    This help screen.

    Alt-L  Locate:
        Enter a valid expression that evaluates to a logical.

        Example:  "PRO" $(CODES)
          This will search for the first record that has the string "PRO"
          somewhere in the CODES field.

        The second time you press Alt-L, you will be prompted with CONTINUE
        or NEW LOCATE.  Selectine CONTINUE will serch for the NEXT match
        for the locate expression, and so on.

    ENTER:
        Pressing ENTER on a field allows you to edit it.
ENDTEXT
    inkey(0)
    popcolor()
    restscreen(0,0,maxrow(),maxcol(),cScr)
RETURN nil

/*
   Function to accept a locate expression, compile it to a code
   block, execute it, display an error message if no matching
   records, and redraw the tbrowse if a record found.
*/
STATIC FUNCTION LocateRec(b)
LOCAL bLocBlock, nRecNo, nOpt
STATIC cLocExp:=NIL
    cLocExp:=if(cLocExp==NIL,space(50),padr(cLocExp,50))
    @ 23,0 clear
    if !empty(cLocExp)
        nOpt:=1
        @ 23,5 prompt '~Continue'
        @ 23,15 prompt '~New Locate'
        menu to nOpt colors {"W/N","N/W","+W/N",NIL,NIL}
        @ 23,0 clear
    else
        nOpt:=2
    endif
    @ 23,0 clear
    if nOpt==2
        set cursor on
        do while .t.
            @ 23,1 say "Locate expression:" get cLocExp picture "@!@K"
            read
            if !empty(cLocExp)
                bLocBlock := COMPILE(cLocExp)
                if valtype(eval(bLocBlock)) != "L"
                    ?? chr(7)
                    @ 23,0 clear
                    @ 23,1 say "Invalid expression."
                    inkey(2)
                    @ 23,0 clear
                else
                    exit
                endif
            else
                exit
            endif
        enddo
        set cursor off
        if !empty(cLocExp)
            nRecNo := recno()
            __dbLocate(bLocBlock)
            if eof()
                blip()
                @ 23,1 say "No matching records."
                inkey(2)
                @ 23,0 clear
                go nRecNo
            else
                b:refreshall()
            endif
        endif
    else
        continue
        b:refreshAll()
    endif
    @ 23,0 clear
RETURN nil


//  Edit the currently highlighted tbrowse cell
STATIC FUNCTION EditCell(b)
LOCAL c, nKey, xvar, lreadexit, oget
    while !b:stabilize()
    enddo
    // get column object from browse
    c := b:getColumn(b:colPos)
    // evaluate column block to get value of cell
    xVar := eval(c:block)
    lreadexit := readexit(.t.)
    set cursor on

    @ row(),col() get xvar color "n/bg"     // get the cell
    read

    set cursor off
    readexit(lreadexit)
    nKey := LastKey()
    if nKey != K_ESC .and. updated()
        RecLock()
        eval(c:block, xvar )        // save the cell
        unlock
    elseif nKey == K_UP .or. nKey == K_DOWN .or. nKey == K_PGUP .or. nKey == K_PGDN
       keyboard chr(nKey)
    endif
    b:refreshAll()
RETURN nil
