/*
  VGAFUNC.PRG

  Author .... D.B. McDonald  [ CIS 76334,3521 ]
  Update .... February 17, 1992
  Version ... 1.00.00
  Compiler .. CLIPPER 5.01 using options /M /N /W

  VGA palette conversion routines

*/
#include "vgacolor.ch"

#translate  .Attr  => \[ 1 ]
#xtranslate .Red   => \[ 2 ]
#xtranslate .Green => \[ 3 ]
#xtranslate .Blue  => \[ 4 ]


* --------------------------------------------------------------------------- *
* ARRVGAFILE()    
*    - convert a 16 X 4 VGA array to a 48 byte VGA palette file.
*    - If the array being converted is not valid, the current VGA palette
*      is saved.
Function ArrVgaFile( aVgaPal, cFile )
* --------------------------------------------------------------------------- *
   local cVgaPal := ArrVgaStr( aVgaPal )

Return StrFile( cVgaPal, cFile )


* --------------------------------------------------------------------------- *
* ARRVGAPAL()
*    - Set the VGA palette using the 16 X 4 VGA array
*    - The array may be less than 16 elements long, as long as the 4 members
*      of each element are correct.
Function ArrVgaPal( aVga )
* --------------------------------------------------------------------------- *
  local lVga := ValType( aVga ) == 'A' 

  if lVga 
     aeval( aVga, ;
            { |Color| ;
              VgaPalette( Color.attr, Color.Red, Color.Green, Color.Blue ) } )
  endif

return lVga


* --------------------------------------------------------------------------- *
* ARRVGASTR()
*    - convert a 16 X 4 VGA array to a 48 byte VGA palette string
*    - If the array is not valid, use the current VGA palette setting
Function ArrVgaStr( aVgaPal )
* --------------------------------------------------------------------------- *
   local cVgaPal := []

   if ! ( ValType( aVgaPal ) == 'A' .and. len( aVgaPal ) == 16 )
     aVgaPal := VgaPalArr()
   endif
   aeval( aVgaPal, { |Color| cVgaPal += chr( Color.Red ) + chr( color.Green ) + chr( Color.Blue ) } )

Return cVgaPal

* --------------------------------------------------------------------------- *
* VGAFILEARR()
*    - convert a 48 byte VGA palette file to a 16 X 4 VGA array
*    - if the file is not valid, a NIL array is returned
Function VgaFileArr( cFile )
* --------------------------------------------------------------------------- *
   local aVgaPal := {}
   local cVgaStr := []

   if cFile # NIL .and. file( cFile )
      cVgaStr := filestr( cFile )   
      aVgaPal := VgaStrArr( cVgaStr )
   endif

Return aVgaPal


* --------------------------------------------------------------------------- *
* VGAPALARR()
*    - Convert the current VGA palette to a 16 X 4 VGA array
Function VgaPalArr()
* --------------------------------------------------------------------------- *
   local i
   local aVgaPal := {}

   FOR i = 0 TO 15

      aAdd( aVgaPal, { i, ;
                       GetVgaPal( i, RED   ), ;
                       GetVgaPal( i, GREEN ), ;
                       GetVgaPal( i, BLUE  )  ;
                     } )

   NEXT i


Return aVgaPal


* --------------------------------------------------------------------------- *
* VGASTRARR()
*    - Convert a 48 byte VGA palette string to a 16 X 4 VGA array
*    - If no string is passed, return the current VGA palette settings
Function VgaStrArr( cVgaStr )
* --------------------------------------------------------------------------- *
   local i
   local aVgaPal := {}
   
   if ValType( cVgaStr ) == 'C' .and. len( cVgaStr ) ==  48 

      FOR i = 0 TO 15

         aAdd( aVgaPal, { i, ;
                          ascpos( cVgaStr, i * 3 + 1 ), ;
                          ascpos( cVgaStr, i * 3 + 2 ), ;
                          ascpos( cVgaStr, i * 3 + 3 )  ;
                        } )

      NEXT i

   else
      aVgaPal := VgaPalArr()
   ENDIF

Return aVgaPal


* --------------------------------------------------------------------------- *
* FILEVGAPAL()
*    - Convert a 48 byte VGA text file to active VGA Palette
Function FileVgaPal( cFile )
* --------------------------------------------------------------------------- *
  local aVgaArr := {}

  if cFile # NIL .and. file( cFile )
     aVgaArr := VgaFileArr( cFile )
     ArrVgaPal( aVgaArr )
  endif

Return aVgaArr


* --------------------------------------------------------------------------- *
* VGAPALFILE()
*    - convert active VGA palette to 48 byte VGA test file
Function VgaPalFile( cFile )
* --------------------------------------------------------------------------- *
  local aVgaArr := {}
  if cFile # NIL
     aVgaArr := VgaPalArr()
     ArrVgaFile( aVgaArr, cFile )
  endif

return aVgaArr

* --------------------------------------------------------------------------- *
* EOF: VGAFUNC.PRG				February 17, 1992 at 14:57:33
* --------------------------------------------------------------------------- *



