/*
  VGAFILE.PRG

  Author .... D.B. McDonald  [ CIS 76334,3521 ]
  Update .... February 17, 1992
  Version ... 1.00.00
  Compiler .. CLIPPER 5.01 using options /M /N /W

  Load/Save 48 byte VGA text files

*/
#include "vgacolor.ch"

* --------------------------------------------------------------------------- *
Function LoadVga( cFile, xClr )
*    Load a 48 byte VGA text file into the VGA palette
* --------------------------------------------------------------------------- *
  GetVgaName( 'Load a VGA palette file', @cFile, xClr )

  if lastkey() # K_ESC
     FileVgaPal( cFile )
  endif

Return NIL

* --------------------------------------------------------------------------- *
Function SaveVga( cFile, xClr )
*    Save the VGA palette to a 48 byte VGA file
* --------------------------------------------------------------------------- *
  GetVgaName( 'Save a VGA palette file', @cFile, xClr )

  if lastkey() # K_ESC
     VgaPalFile( cFile )
  endif

Return NIL


* --------------------------------------------------------------------------- *
Function GetVgaName( cTxt, cFile, xClr )
*    Enter the name of a file for use by LoadVga() and SaveVga()
* --------------------------------------------------------------------------- *
  local nWin    := wSelect()
  local nCursor := SetCursor()
  local nShadow := wSetShadow( nToColor( SHADOW_COLOR ) )
  local nTop    := Int( ( MaxRow( .T. ) - 5 ) / 2  )
  local nLeft   := Int( ( MaxCol( .T. ) - 30 ) / 2 )

  default cFile to "_palette.vga"
  cFile := padr( cFile, 12 )

  //... Paint Entry Window
  wOpen( nTop, nLeft, nTop + 5, nLeft + 30 )
  SetColor( iif( Valtype( xClr ) == 'N', nToColor( xClr ), xClr ) )
  wBox( THICK_LINE )
  wSay( 1,2, cTxt )      

  //... Input name of file
  SetCursor( SC_NORMAL )
  cFile := GetInput( cFile, 2, 2, .T., "File name:" )
  SetCursor( nCursor )

  //.. Remove entry window from display screen
  wClose()
  wSetShadow( nShadow )
  wSelect( nWin )

Return NIL

* --------------------------------------------------------------------------- *
* EOF: VGAFILE.PRG				February 17, 1992 at 14:57:19
* --------------------------------------------------------------------------- *

