/*
  NT2FUNC.PRG

  Author .... D.B. McDonald  [ CIS 76334,3521 ]
  Update .... February 17, 1992
  Version ... 1.00.00
  Compiler .. CLIPPER 5.01 using options /M /N /W

  General purpose add on functions using NT250.LIB

*/
#include "vgacolor.ch"

* --------------------------------------------------------------------------- *
FUNCTION wSay( nR, nC, cTxt, xClr )
*    Display text in a window
* --------------------------------------------------------------------------- *
  DispBegin()
  SetPos( nR, nC )
  DispOut( cTxt, iif( ValType( xClr ) == 'N', nToColor( xClr, .T. ), xClr ) )
  DispEnd()
Return []


* -------------------------------------------------------------------------- *
FUNCTION NumFix( n, nLen, nDec )
*    Return a number converted to a string with leading zeroes instead
*    of spaces.
* -------------------------------------------------------------------------- *
  //... Create an array of code blocks containing number to string conversion
  //... routines for all parameter count possibilities.
  local bCode := { {|| chr( 241 ) }, ;
                   {|| ltrim( str( abs( n ) ) ) }, ;
                   {|| str( abs( n ), nLen - iif( n < 0, 1, 0 ) ) }, ;
                   {|| str( abs( n ), nLen - iif( n < 0, 1, 0 ), nDec ) } ;
                 }

//... Execute the appropriate code block, replace all leading spaces with
//... zeroes, and add a "-" sign to negative numbers.
return iif( iif( n == NIL, 0, n ) < 0, '-', '' ) + ;
            ReplLeft( eval( bCode[ pcount() + 1 ] ), '0' )


* --------------------------------------------------------------------------- *
FUNCTION CenterPos( cStr, nWid )
*    Return the center position of a string for a window
* --------------------------------------------------------------------------- *
  local nRet := 0

  //... Return the window center position of a string
  if cStr # NIL
     nRet := Int( ( iif( nWid == NIL, MaxCol() + 1, nWid ) - len( cStr ) ) / 2 )
  endif 

Return nRet


* --------------------------------------------------------------------------- *
FUNCTION aLength( Array )
*    Return the length of the longest element in an array of strings
* --------------------------------------------------------------------------- *
local nMaxLen := 0

//...if not an array, return a NIL to calling function
if ValType( Array ) != 'A'
   Return NIL
endif

//...scan single dimension array for largest element size
aeval( Array, { |Elem| nMaxLen := Max( nMaxLen, Len( Elem ) ) } )

//...return the length of the largest element in the array
Return nMaxLen


*-----------------------------------------------------------------------------
Function GetColor( n, idAttr )
*    Return the individual color attribute from the CLIPPER color string
*-----------------------------------------------------------------------------

  //... 'n' must be in the range of 1 to 5
  default n to STANDARD
  n := max( min( n, UNSELECT ), STANDARD )

Return { |clr| iif( idAttr == NIL, ColorToN( Clr ), Clr ) }:eval( Token( SetColor(), ',', n ) )
           

* --------------------------------------------------------------------------- *
* EOF: NT2FUNC.PRG				February 17, 1992 at 14:56:56
* --------------------------------------------------------------------------- *

