%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

*   Description: test of TCP/IP functions                                   
*     File Name: TEST.PRG                                                   
*        Author: Kent Walker                                         
*  Date created: 07-23-94              Date updated: 07-25-94        
*  Time created: 02:55:14pm            Time updated: 04:54:03pm        
*     Copyright: (c) 1994 by Space Systems/Loral                            

// This program is a simple test of a socket interface to a 
// custom server daemon.
// The server simply echoes the string sent to it.
// The return string is displayed.

#INCLUDE "InKey.CH"

CLEAR

HostName := SPACE(60)

@ 5,5 SAY "Host Name: " GET HostName

READ

IF LASTKEY() = K_ESC

  QUIT

ENDIF

HostName := ALLTRIM( HostName )

HostAddr := GETHOSTADR( HostName )

@  8, 5                                          // clear bottom of screen

@  8, 5 SAY "The IP Address of: " + HostName + " is: " + HostAddr

@ 10, 5 SAY "Sending 'MAKE MONEY FAST' to " + HostName

SockHandle := SOCKOPEN( HostName )

SockWrite( SockHandle, "MAKE MONEY FAST" + CHR( 13 ) + CHR( 10 ) )

@ 12, 5 SAY GetIpRec( SockHandle )

RETURN( NIL )

//--------------------------------------------------------------------

FUNCTION GetIpRec( SockHandle )

  LOCAL GetStr := ""

  LOCAL StartTime := SECONDS() + 10

  DO WHILE SECONDS() < StartTime

    GetStr += SockRead( SockHandle )

    IF CHR( 10 ) $ GetStr                        // look for CR (terminator) in string

      EXIT

    ENDIF

  ENDDO

RETURN( GetStr )
