/*** 
*
* file CLTCP.C
*
***/

/***
*
* These routines are for calling PC-FTP socket functions from Clipper
* Should be compiled with Large model of MicroSoft C, v. 5.1 for
* compatability with Clipper 5.x.  FTP library v. 2.3
*
***/

/***
* clmalloc.c
*
* Function to handle memory managment via Clipper library.
* These routines simply redefine malloc & free to call
* the Clipper equivalents.
* Ref. Clipper extended system documents info on memory managment.
*
***/

#include "extend.h"
#include "fm.api"
#include <dos.h>

void far * _CDECL malloc(qty)

unsigned int qty;

{
        return _xgrab(qty);
}

void _CDECL free(ptr)

void far *ptr;

{
        _xfree(ptr);
}

/*** Function to test getting IP address
*
* Makes use of the gethostbyname() function
* PC/TCP Development Kit, Socket Reference v.2.3, pp. 3-21
*
***/

#include <stdio.h>

#include <stdlib.h>
#include <errno.h>
#include <4bsddefs.h>
#include <arpa/inet.h>
#include <netinet/in.h>
#include <sys/socket.h>

#include <netdb.h>
#include <errno.h>

#include <string.h>

/***
*
* GETHOSTADR( <cString> )   -> <cIpAddr>
*
*  Returns the IP Address of host <cString>
*
***/

void gethostaddr( char *hostname );

CLIPPER GETHOSTADR(void)
{
  char *hostname ;
  char *hostaddr ;

  struct sockaddr_in Addr;              /* Sockets Address Structure */
  struct hostent *Host;                  /* Ptr to Sockets Host Structure */

  /* get host name from Clipper */

  hostname = _parc(1);

  /* Resolve hostname by local host table -or- Domain Name Server */
  Host = gethostbyname(hostname);

  /* Assign Echo Port (translate from host to network order first) */

  Addr.sin_port         = htons(7);
  Addr.sin_family       = AF_INET;
  Addr.sin_addr.s_net   = (char) *(Host->h_addr);
  Addr.sin_addr.s_host  = (char) *((Host->h_addr)+1);
  Addr.sin_addr.s_lh    = (char) *((Host->h_addr)+2);
  Addr.sin_addr.s_impno = (char) *((Host->h_addr)+3);

  /* return the address string to Clipper */

  hostaddr = inet_ntoa(Addr.sin_addr);

  _retc( hostaddr );

}


void sockopen( char *hostname );

CLIPPER SOCKOPEN(void)
{
  char *hostname ;
  char *hostaddr ;
  int  TcpSock   ;


  struct sockaddr_in serv_addr;              /* Sockets Address Structure */
  struct hostent *Host;                  /* Ptr to Sockets Host Structure */

  /* get host name from Clipper */

  hostname = _parc(1);

  /* get a socket */

  TcpSock = socket( PF_INET, SOCK_STREAM, 0 );

  /* Resolve hostname by local host table -or- Domain Name Server */
  Host = gethostbyname(hostname);

  /* Assign Echo Port (translate from host to network order first) */

  serv_addr.sin_port         = htons(5000);     /* NOTE: port for Pyramid interface */
  serv_addr.sin_family       = AF_INET;
  serv_addr.sin_addr.s_net   = (char) *(Host->h_addr);
  serv_addr.sin_addr.s_host  = (char) *((Host->h_addr)+1);
  serv_addr.sin_addr.s_lh    = (char) *((Host->h_addr)+2);
  serv_addr.sin_addr.s_impno = (char) *((Host->h_addr)+3);

  connect( TcpSock, (struct sockaddr * ) &serv_addr, sizeof(serv_addr));

  _retni( TcpSock );

}


#include <4bsddefs.h>

void sockclose( int TcpSock );

CLIPPER SOCKCLOSE(void)
{

  int    TcpSock        ;
  int    RetVal         ;
  struct linger   ling  ;

  TcpSock = _parni(1);

  ling.l_onoff  = 1;
  ling.l_linger = 0;

  /* don't understand exactly why this socket option has to be set,
   * but without it, the computer hangs when attempting to close
   * the socket
   ***/

  /* printf( "\nSetting Socket Option in C\n" ); */

  setsockopt( TcpSock, SOL_SOCKET, SO_LINGER, (char *)&ling, sizeof(struct linger) );

  /* printf( "\nStarting socket close in C\n" ); */

  RetVal = close( TcpSock );

  /* printf("\nClose Return: %n", RetVal ); */

  _retni( RetVal );


}


void sockwrite( int TcpSock, char *sendstr );

CLIPPER SOCKWRITE(void)
{

  int  TcpSock  ;
  char *sendstr ;
  int  RetVal   ;

  TcpSock = _parni(1);
  sendstr = _parc(2);

  /* get a socket */

  RetVal = write( TcpSock, sendstr, strlen( sendstr ) );

  _retni( RetVal );

}


#define BUFLEN 1024

void sockread( int TcpSock );

CLIPPER SOCKREAD(void)
{

  int  TcpSock          ;
  int  RetVal           ;
  int  InLen            ;
  char getstr[BUFLEN+1] ;

  TcpSock = _parni(1);

  /* get a socket */

  InLen = read( TcpSock, getstr, BUFLEN );
  getstr [InLen] = '\0' ;               /* add EOS */

  _retc( getstr );

}
