
;=============================================================================
;
; Filename: CLIPSCRL.ASM
; Author..: Tim Shriver; Softech International, Inc. (301) 890-4054
; Address.:              14241 Ballinger Terrace
;                        Laurel, MD  20707
; Date....: November 18, 1986
; Notice..: This program is donated as Shareware.  ClipScrl works and I'm 
;           sure it could be written better.  I am not an assembly programmer
;           and would like to here any suggestions for improving the code.  
;           If you find these routines to be helpful please send $5.00 to 
;           the address shown above.  Look for other clipper utilities on this
;           BBS from Softech in the near future.  Thank you for your support. 
; Notes...: User-defined dBASE functions in 8086 assembly for Clipper.  
;
;
;   Procedures not in dBASE III or Clipper:
;      SCRLUP() ::= Scroll Active Display Page Up
;      SCRLDOWN () ::= Scroll Active Display Page Down

NAME    CLIPSCRL

EXTRN   _PARNI:far
EXTRN   _RETNI:far

DGROUP  GROUP   datasg
datasg  SEGMENT PUBLIC  'DATA'
        HOLDbh   db      0
        HOLDch   db      0
        HOLDcl   db      0
        HOLDdh   db      0
        HOLDdl   db      0
datasg  ends

_PROG   SEGMENT BYTE
        ASSUME  CS:_PROG,DS:DGROUP,ES:DGROUP

        PUBLIC  SCRLUP
        PUBLIC  SCRLDOWN

;------------------------------------------------------------------------------
;  Syntax: SCRLUP (<expN1>,<expN2>,<expN3>,<expN4>,<expN5>,<expN6>)
;  Parms : expN1: Number of lines to scroll up
;          expN2: Row of upper left corner of scroll 
;          expN3: Col of upper left corner of scroll 
;          expN4: Row of lower right corner of scroll 
;          expN5: Col of lower right corner of scroll 
;          expN6: Attribute to be used on blank lines at bottom of scroll

SCRLUP        proc    far
              push    bp          ; save bp
              mov     bp,sp       ; get  stack/parameter pointer
              push    ds          ; save ds
              push    es          ; save es

              mov     ax,6        ; get address of parameter
              push    ax          ; put parameter on stack
              call    _PARNI      ; put integer in ax
              add     sp,2        ; fix up stack
              mov     HOLDbh,al   ; save integer to data
 
              mov     ax,5        ; get address of parameter
              push    ax          ; put parameter on stack
              call    _PARNI      ; put integer in ax
              add     sp,2        ; fix up stack
              mov     HOLDdl,al   ; save integer to data
 
              mov     ax,4        ; get address of parameter
              push    ax          ; put request parm on stack
              call    _PARNI      ; get integer an put in ax
              add     sp,2        ; fix up stack
              mov     HOLDdh,al   ; save integer to data
  
              mov     ax,3        ; get address of parameter
              push    ax          ; put requested parm on stack
              call    _PARNI      ; get integer and put in ax
              add     sp,2        ; fix up stack
              mov     HOLDcl,al   ; save integer to data
 
              mov     ax,2        ; get address of parameter
              push    ax          ; put requested parm on stack
              call    _PARNI      ; get integer and put in ax
              add     sp,2        ; fix up stack
              mov     HOLDch,al   ; get parameter value

              mov     ax,1        ; get address of parameter
              push    ax          ; put requested parm on stack
              call    _PARNI      ; get integer and put in ax
              add     sp,2        ; fix up stack

              mov     bh,HOLDbh
              mov     ch,HOLDch
              mov     cl,HOLDcl 
              mov     dh,HOLDdh
              mov     dl,HOLDdl 

              mov     ah,06       ; service code
              int     16          ; interrupt  - request service
              pop     es          ; restore es
              pop     ds          ; restore ds
              pop     bp          ; restore bp
              ret                 ; return to caller
 
SCRLUP  endp
 
;------------------------------------------------------------------------------
;  Syntax: SCRLDOWN (<expN1>,<expN2>,<expN3>,<expN4>,<expN5>,<expN6>)
;  Parms : expN1: Number of lines to scroll up
;          expN2: Row of upper left corner of scroll 
;          expN3: Col of upper left corner of scroll 
;          expN4: Row of lower right corner of scroll 
;          expN5: Col of lower right corner of scroll 
;          expN6: Attribute to be used on blank lines at bottom of scroll
 
SCRLDOWN      proc    far
              push    bp          ; save bp
              mov     bp,sp       ; get  stack/parameter pointer
              push    ds          ; save ds
              push    es          ; save es

              mov     ax,6        ; get address of parameter
              push    ax          ; put parameter on stack
              call    _PARNI      ; put integer in ax
              add     sp,2        ; fix up stack
              mov     HOLDbh,al   ; save integer to data
 
              mov     ax,5        ; get address of parameter
              push    ax          ; put parameter on stack
              call    _PARNI      ; put integer in ax
              add     sp,2        ; fix up stack
              mov     HOLDdl,al   ; save integer to data
 
              mov     ax,4        ; get address of parameter
              push    ax          ; put request parm on stack
              call    _PARNI      ; get integer an put in ax
              add     sp,2        ; fix up stack
              mov     HOLDdh,al   ; save integer to data
  
              mov     ax,3        ; get address of parameter
              push    ax          ; put requested parm on stack
              call    _PARNI      ; get integer and put in ax
              add     sp,2        ; fix up stack
              mov     HOLDcl,al   ; save integer to data
 
              mov     ax,2        ; get address of parameter
              push    ax          ; put requested parm on stack
              call    _PARNI      ; get integer and put in ax
              add     sp,2        ; fix up stack
              mov     HOLDch,al   ; get parameter value

              mov     ax,1        ; get address of parameter
              push    ax          ; put requested parm on stack
              call    _PARNI      ; get integer and put in ax
              add     sp,2        ; fix up stack

              mov     bh,HOLDbh
              mov     ch,HOLDch
              mov     cl,HOLDcl 
              mov     dh,HOLDdh
              mov     dl,HOLDdl 

              mov     ah,07       ; service code
              int     16          ; interrupt  - request service
              pop     es          ; restore es
              pop     ds          ; restore ds
              pop     bp          ; restore bp
              ret                 ; return to caller
 
SCRLDOWN  endp
 
_PROG ENDS

         END

; EOF CLIPSCRL.asm ------------------------------------------------------------