* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
*  File: Up.prg
*
*  Author: Mark Pfeifer
*
*  Compiler:  Clipper (tm), Summer '87
*
*  Revision:
*     6-Jul-87    initial coding in Autumn '86
*     2-Mar-88    optimization for Summer '87
*
*  Copyright: none, placed in the public domain by author
* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
* func UpEq
*
*   syntax:   UpEq(<exp-C1>,<exp-C2>[,<exp-C3>,...,<exp-C11>])
*      where:
*         <exp-C1>              primary string
*         <exp-C2>...<exp-C11>  secondary strings
*   returns:
*       logical .T. if any of the secondary strings are equal to the
*       primary string, logical .F. otherwise.  Note: both primary and
*       secondary strings are converted to uppercase before comparison.
*       In addition, secondary strings are Trimmed.
*
*       Examples
*          UpEq("Hello","Hel")      .T.
*          UpEq("Hello","hel")      .T.
*          UpEq("Hello","hEL    ")  .T.
*          UpEq("Hello","GoodBye","Hi")        .F.
*          UpEq("Hello","GoodBye","Hi","H")    .T.
*

func UpEq
para pStr,p0,p1,p2,p3,p4,p5,p6,p7,p8,p9


   priv mMax        && Max # of secondary parameter
   mMax=PCount()-2  && max number of secondary strings

   priv mRet      && value to be returned
   mRet=.F.

   pStr=Upper(pStr)  && note that this won't change the passed parameter

   priv mCnt,;    && loop counter
        mPar      && secondary parameter being processed

   for mCnt = 0 to mMax

      mPar=AlphaN(mCnt)

      if pStr=Upper(Trim(p&mPar))
         mRet=.T.
         exit
      endif

   next mCnt

retu mRet

* end of func UpEq
* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
