* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
*  File: AlphN.prg
*
*  Author: Mark Pfeifer
*
*  Revision:
*     2-Mar-88    initial coding
*
*  Copyright: none, placed in the public domain by author
* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
* func AlphaN
*
*   syntax:   AlphaN(<exp-N>)
*      where <exp-N> is number from 0 to 35 to be converted to an Alpha
*   returns:  string of 1 char
*
*   This function comes in handy when accessing multiple parameters,
*   for example, see the UpEq function.
*
*   AlphaN converts a number from 0 to 35 to an Alpha as follows:
*
*              <exp-N>  return value
*                 0        '0'
*                 1        '1'
*                     ...
*                 9        '9'
*                10        'A'
*                11        'B'
*                     ...
*                34        'Y'
*                35        'Z'
*

func AlphaN
para pN

   priv mRet

   mRet=Substr("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ",pN+1,1)

return mRet

* end of func AlphaN
* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
