/* $modname$   $version$      $date$  $time$
**
**	Purpose:
**
**	Revision history:
**	$log$
** $nokeywords$
*/

/* make sure extend.h definitions are available */
#include <extend.h>

/* macros to break C "far" pointers into their segment and offset components */

#define FP_SEG(fp) (*((unsigned _far *)&(fp)+1))
#define FP_OFF(fp) (*((unsigned _far *)&(fp)))

/* Logical values */
typedef int BOOL;

/* dos get disk free structure for _dspace() function */
struct diskfree_t {
	unsigned avail_clusters;			/* Number of available clusters				*/
	unsigned sectors_per_cluster;		/* Number of sectors per cluster				*/
	unsigned total_clusters;			/* Total number of clusters on disk			*/
	unsigned bytes_per_sector;			/* Number of bytes per sector					*/
};



/* dos find first structure */

struct find_t {
	char 				reserved[21];		/* 21 bytes reserved to DOS internal use	*/
	unsigned char	attrib;				/* DOS file attribute							*/
	unsigned 		wr_time;				/* DOS file last write time					*/
	unsigned			wr_date;				/* DOS file last write date					*/
	unsigned long	size;					/* File size in bytes							*/
	unsigned char	name[13];			/* DOS file name with extension w/o path	*/
};


/* dos extended error related information */

extern int _txerror;
extern char _txclass;
extern char _txaction;


/* File attribute constants */

#define _A_NORMAL		0x00			/* Normal file - No read/write restrictions	*/
#define _A_RDONLY		0x01			/* Read only file										*/
#define _A_HIDDEN		0x02			/* Hidden file											*/
#define _A_SYSTEM		0x04			/* System file											*/
#define _A_VOLID		0x08			/* Volume ID file										*/
#define _A_SUBDIR		0x10			/* Subdirectory										*/
#define _A_ARCH 		0x20			/* Archive file										*/


/* file control options used by the System V like  _topen()
** May be joined by 'or'ing them using the | operator
*/
#define O_RDONLY	0x0000	/* open for reading only */
#define O_WRONLY	0x0001	/* open for writing only */
#define O_RDWR		0x0002	/* open for reading and writing */
#define O_APPEND	0x0008	/* writes done at eof */

#define O_CREAT 	0x0100	/* create and open file */
#define O_TRUNC 	0x0200	/* open and truncate */
#define O_EXCL		0x0400	/* open only if file doesn't already exist */

/* O_TEXT files have <cr><lf> sequences translated to <lf> on read()'s,
** and <lf> sequences translated to <cr><lf> on write()'s
*/
#define O_TEXT		0x4000	/* file mode is text (translated) */
#define O_BINARY	0x8000	/* file mode is binary (untranslated) */


/* _tlseek() seek mode constants */

#define SEEK_CUR 1
#define SEEK_END 2
#define SEEK_SET 0


/* Internal Clipper.lib stuff!
**
** Tough it is not advised to use one development tools'
** internals to build modules on, the ones below have been
** found to be very stable across Clipper versions Summer '87,
** 5.0 and 5.01 which makes them good candidates for use
** from C code.
*/

/* File I/O functions
**
** The parameters they expect are the same as their System V
** look alikes (which names are obtained by stripping off the
** leading '_t'. For instance, _topen() SEEMS to behave just
** like the standard open() function.
**
**	_terror is set by most of those functions to indicate	the kind of error
** (DOS error code) that may have occured.
*/

/* Working buffer used by some functions (_tctemp(),...???) */
extern void * _txlocus;

extern void  _tclose( int hFileHandle );
extern int  _tcreat( char *pszFileName, int iCreateMode );
extern int	_terror;										/* File system eror code */
extern long _tlseek( int hFileHandle, long lOffset, int iSeekMode );
extern int  _topen( char *pcFileName, int iOpenMode );
extern int  _tread( int hFileHandle, char *pcBuffer, int iCharCount );

/*	_twrite( <handle>, <data>, <length> ) -> <actual number of bytes>
	Writes n bytes to file.
	Returns the actual number of bytes written, which might differ from the one
	requested as third parameter.
	Sets _terror to DOS error code when relevant. */
extern int  _twrite( int hFileHandle,			/* Handle of file to be written to	*/
							char *pcBuffer,			/* Data buffer to write to it			*/
							int iCharCount );			/* Number of bytes to write			*/

/* Flush I/O buffers to disk */
extern int  _tcommit( int hFileHandle );		/* return value not sure 		*/

/* Delete file */
extern void  _tunlink( char *pcFileName );

/* Rename file */
extern void  _trename( char *pszOldName,		/* Name of file to be changed	*/
							  char *pszNewName );	/* New name to use				*/

/* Set file handles number */
extern BOOL	_thcount( quant iHandlesNb );

/* Creates a temporary file given a path, returning a handle or -1 */
extern int 	_tctemp(char * pszPath, unsigned uAttrib, char * pszFileName);

/* Get Microsoft network local machine name.
	the buffer must be at least 16 bytes long to receive the name.
	Uses DOS 21h/5eh/00h services */
extern int	_tmname(char * buffer);

/* Disk misceallanous functions
**
**	_dspace() 	relies on dos get disk free service
** _f_first()	relies on dos find first service
** _f_next()	relies on dos find next service
*/
void _dspace(
	unsigned drive,							/* 0 = Default, 1 = A, ....				*/
	struct diskfree_t * diskfree			/* Drive allocation information struct */
);

/* File search functions
**
** Call DOS	Set Disk Transfer Area			Int 21h Function 1Ah
**				Find First							Int 21h Function 4Eh
**				Find Next								Int 21h Function 4Fh
**
**	Arguments are the same as the MSC library's _dos_findfirst() and
**	_dos_findnext() functions except for the order. See prototypes.
**
**	WARNING:	Return values are the opposite of MSC's library functions!
**
**	_f_first()		return		0	when FAILED (no matching files)
**	_f_next()						1	when SUCCESSFUL
*/
extern unsigned short _far _cdecl _f_first(
	const unsigned char _far *,			/* ASCIIZ pathname			*/
	struct find_t _far *,					/* pointer on DTA buffer	*/
	unsigned										/* Search attribute word	*/
);
extern unsigned short _far _cdecl _f_next(struct find_t _far *);

/* Simple screen display function
**
** Use like Clipper's 5.01 QOUT() except for the second
** parameter which is the length of the text to display
*/
extern void _cQOut( char *, unsigned );


/* String handling functions. Same as C! */

char _far * _far _cdecl strcat(char _far *, const char _far *);
char _far * _far _cdecl strcpy(char _far *, const char _far *);
char _far * _far _cdecl strncpy(char _far *, const char _far *, quant);
quant _far _cdecl strlen(const char _far *);

/* Byte (unsigned char) handling functions. Same as C mem... functions */

/* See C function memcmp() */
byte _far * _far _cdecl _bcmp(const byte _far *buf1, const byte _far *buf2, quant count);

/* See C function memcpy() for near memory model */
byte _near * _near _cdecl _bcopy(byte _near *dest, const byte _near *src, quant count);

/* See C function _fmemcpy() */
byte _far * _far _cdecl _bcopyf(byte _far *dest, const byte _far *src, quant count);

/* See C function memmove() */
byte _far * _far _cdecl _bmove(byte _far *dest, byte _far *src, quant count);

/* See C function memchr() */
byte _far * _far _cdecl _bscan(byte _far *buf, int c, quant count);

/* See C function memset() */
byte _far * _far _cdecl _bset(byte _far *dest, int c, quant count);

/* See C function memccpy() */
byte _far * _far _cdecl stccpy(byte _far *dest, byte _far *src, int c, quant count);

/* See C function strpbrk() */
byte _far * _far _cdecl stpchr(byte _far *buf, int c);

/* See C function ??????, use with CARE! */
byte _far * _far _cdecl stpblk(byte _far *string1, byte _far *string2);

/* See C function getenv() */
byte _far * _far _cdecl _getenv(byte _far *varname);


/* Global variables, same as those from Microsoft's C6.00A */
byte _far *environ[];
extern unsigned _near _cdecl _psp;
extern unsigned _near _cdecl _osmajor;
extern unsigned _near _cdecl _osminor;
extern unsigned _near _cdecl _osmode;
extern unsigned _near _cdecl _osversion;
