/*
    win.prg

    Copyright (c) 1991 Anton van Straaten
*/


#include "class(y).ch"
#include "win.ch"
#include "gen.ch"


static currWin


create class Window

    instvar buf
    instvar cursor

    classvar winList

    method  _close
    method  _open

export :
    instvar top, left, bottom, right noassign
    instvar margin      noassign

    instvar boxChars    noassign
    instvar frameColor  noassign
    instvar paneColor   noassign
    instvar isOpen      noassign

    method  width       // make these instvars?
    method  height

    method  open
    method  draw
    method  clear
    method  close
    method  closeOn
    method  kill
    method  killOn

    method  activate

    method  title

    class method closeAll

endclass



constructor (nTop, nLeft, nBottom, nRight, cFrame, cFrameColor, cPaneColor, lOpen)
    ::top    := nTop
    ::left   := nLeft
    ::bottom := nBottom
    ::right  := nRight

    ::boxChars   := ifnil(cFrame, DUBLBORD)
    ::frameColor := cFrameColor
    ::paneColor  := cPaneColor

    if lOpen == NIL .or. lOpen
        ::open()
    end
return



procedure method open
    if ::isOpen == NIL .or. !::isOpen
        if ::winList == NIL
            ::winList := list():new
        end
        if ::winList:tail() <> NIL
            ::winList:tail():cursor := cursor():new
        end
        ::_open()
        ::winList:add(self)
    else
        ::activate()
    end
return



procedure method _open
    local buf := savescreen(::top, ::left, ::bottom, ::right)
    winCurrent(self)
    if ::isOpen == NIL
        ::draw()
    else
        restscreen(::top, ::left, ::bottom, ::right, ::buf)
        ::cursor:show()
    end
    ::buf := buf
    ::isOpen := .t.
return



procedure method draw
    if ::isOpen == NIL .or. !::isOpen
        ::margin := 0
        if ::boxChars <> NOBORDER
            setcolor(::frameColor)
            // margin must be 0 for following to work
            @ 0, 0, maxrow(), maxcol() box ::boxChars
            ::margin := 1
        end
        ::clear()
    end
return



procedure method clear
    setcolor(::paneColor)
    @ 0, 0 clear to maxrow(), maxcol()
    ::cursor := cursor():new
return



function method closeOn(event)
    local key
    local eventType := valtype(event)
    local curstate := setcursor(1)
    if eventType = 'C'
        // event should contain a string of key values
        while !(chr(key := inkey(0)) $ event)
        end
    elseif eventType $ 'NU'
        // event should contain a number of seconds;
        // 0 waits indefinitely for keystroke
        key := inkey(event)
    end
    setcursor(curstate)
    ::close()
return key



procedure method close
    if ::isOpen <> NIL .and. ::isOpen
        if !(self == ::winList:tail())
            ::activate()    // tbd: flag to prevent open of window being deleted? or use procname() in activate
        end
        ::_close()
        ::winList:delete()
        if ::winList:tail() <> NIL
            ::winList:tail():activate()
        end
    end
return



procedure method _close
    local buf := savescreen(::top, ::left, ::bottom, ::right)
    restscreen(::top, ::left, ::bottom, ::right, ::buf)
    ::cursor:update()
    ::buf := buf
    ::isOpen := .f.
return



procedure method kill
    ::close()
    ::buf := NIL
    ::cursor := NIL
return



procedure method killOn(event)
    ::closeOn(event)
    ::kill()
return



procedure method activate
    local win := ::winList:tail()

    if !(win == self) .and. win <> NIL
        // close all windows down to self
        while win <> NIL
            win:_close()
            if win == self
                exit
            end
            win := ::winList:prev()
        end

        ::winList:delete()              // delete self from list
        win := ::winList:current()

        while win <> NIL
            win:_open()
            win := ::winList:next()
        end
        ::winList:add(self)
        ::_open()
    elseif win <> NIL
        ::cursor:show()
        winCurrent(self)
    end
return



function method width
return (::right - ::left - ::margin * 2 + 1)


function method height
return (::bottom - ::top - ::margin * 2 + 1)


procedure method closeAll
    local win

    while (win := ::winList:tail()) != NIL
        win:close()
    end
return


/*

    :title(cMsg, nPosn, cColor)

    Display msg on the window border in position specified by posn, which
    must be one of the constants specified in winInit(): wTL, wTC, wTR, wBL,
    wBC, or wBR.  If msg is numeric, the relevant portion of the border is
    redrawn.  The color parameter is optional.

*/

procedure method title(msg, posn, color)
    local row, col, horizline

    if ::isOpen == NIL .or. !::isOpen        // tbd: method for this?
        return
    end

    ::activate()
    ifnil posn := wTC
    if posn = wTL .or. posn = wTC .or. posn = wTR
        row = ::top
        horizline = substr(::boxChars, 2, 1)
    elseif posn = wBL .or. posn = wBC .or. posn = wBR
        row = ::bottom
        horizline = substr(::boxChars, 6, 1)
*    else
        * tbd: error (or other behaviour?)
    end

    if valtype(msg) = 'N'
        msg = replicate(horizline, msg)
    end

    do case
        case posn = wTL .or. posn = wBL
            col = ::left + 2
        case posn = wTC .or. posn = wBC
            col = (::right + ::left - len(msg))/2
        case posn = wTR .or. posn = wBR
            col = ::right - len(msg) - 2
    end

    if col + len(msg) > ::right
        msg = left(msg, ::right - col)           // truncate message
    end

    ::cursor:update()
    setcolor(if(color == NIL, ::frameColor, color))
    // to avoid translation:
    DevPos(row, col)
    DevOut(msg)
    ::cursor:show()

return


function winCurrent(w)
    if w != NIL
        if valtype(w) == 'N' .and. w == 0
            // this is the only way to select the main screen at present. tbd.
            CurrWin := NIL
        else
            CurrWin := w
        end
    end
return CurrWin


function winTop
return if(CurrWin == NIL, 0, CurrWin:top + CurrWin:margin)

function winLeft
return if(CurrWin == NIL, 0, CurrWin:left + CurrWin:margin)

function winMaxRow
return if(CurrWin == NIL, 24, CurrWin:height() - 1)

function winMaxCol
return if(CurrWin == NIL, 79, CurrWin:width() - 1)


// used in win.ch
function _wtrunclen(nCol)
return if(CurrWin == NIL, 79, CurrWin:width() - nCol)


// eof win.prg
