    // scrnrect.prg

    #include "class(y).ch"
    #include "box.ch"

    create class ScreenRect from Rectangle
        instvar screenBuf
        instvar boxStyle
        instvar color

    export:
        method moveUp, moveDown
        method moveLeft, moveRight
        method hide, show
    endclass

    constructor (top, left, bottom, right, color, boxStyle), ;
            (top, left, bottom, right)

        ::boxStyle := if(boxStyle == nil, B_DOUBLE, boxStyle)
        ::color := color
        ::show()
    return

    procedure method hide
        restscreen(::top, ::left, ::bottom, ::right, ::screenBuf)
    return

    procedure method show
        local oldColor := setcolor(::color)
        ::screenBuf := savescreen(::top, ::left, ::bottom, ::right)
        @ ::top, ::left, ::bottom, ::right box ::boxStyle
        setcolor(oldColor)
    return

    procedure method moveUp(n)
        send self <- hide, set(::top - n, nil, ::bottom - n, nil), show
    return

    procedure method moveDown(n)
        send self <- hide, set(::top + n, nil, ::bottom + n, nil), show
    return

    procedure method moveLeft(n)
        send self <- hide, set(nil, ::left - n, nil, ::right - n), show
    return

    procedure method moveRight(n)
        send self <- hide, set(nil, ::left + n, nil, ::right + n), show
    return

    // eof scrnrect.prg
