// Substitute for regular USE command, without an ALIAS...
#command USE <(db)>                                                     ;
             [VIA <rdd>]                                                ;
             [<new: NEW>]                                               ;
             [<ex: EXCLUSIVE>]                                          ;
             [<sh: SHARED>]                                             ;
             [<ro: READONLY>]                                           ;
             [INDEX <(index1)>]                                         ;
                                                                        ;
      => <db> := UseClass(                                              ;
                          <(db)>, <(index1)>,                           ;
                          if(<.sh.> .or. <.ex.>, !<.ex.>, NIL),         ;
                          <.new.>, <.ro.>, <rdd>,, .T.                  ;
                          )

// ... or with an ALIAS...
#command USE <(db)>                                                     ;
             [VIA <rdd>]                                                ;
             ALIAS <a>                                                  ;
             [<new: NEW>]                                               ;
             [<ex: EXCLUSIVE>]                                          ;
             [<sh: SHARED>]                                             ;
             [<ro: READONLY>]                                           ;
             [INDEX <(index1)>]                                         ;
                                                                        ;
      => <a> := UseClass(                                               ;
                          <(db)>, <(index1)>,                           ;
                          if(<.sh.> .or. <.ex.>, !<.ex.>, NIL),         ;
                          <.new.>, <.ro.>, <rdd>, <(a)>, .T.            ;
                          )

// for MENUCLASS:TYPE...
#define X_VERTICAL   0
#define X_HORIZONTAL 1
#define X_SUBMENU    2

// for use in SHADOWCLASS:CHARS...
#define X_BOX_1   "Ŀ"
#define X_BOX_2   "ͻȺ"
#define X_BOX_3   "ķԳ"
#define X_BOX_4   "͸Ӻ"
#define X_BOX_5   "ͻ"
#define X_BOX_6   "ĿȺ"
#define X_BOX_7   "͸Գ"
#define X_BOX_8   "ķӺ"

