// CLASSic Demo Class
// By John D. Van Etten
// Written in CLASSic

#include "inkey.ch"
#include "classic.ch"
#include "Menu.ch"

Begin Class Main

  Method Demo Constructor // Program Startup!

  Local:
    Method MenuHelp // Popup Help For the Menu

End Class

Method Demo()
  Local nChoice   := 1
  Local oBack     := oWIN():New():Desktop( "Reading DEMO.INI File *** ", "w+/b"):Open()
  Local oMenu     := oMenu():New()
  Local oIni      := OINI():NEW():OPEN( "DEMO.INI" )
  Local cMenu1    := oIni:Get( "MENU OPTIONS", "WINDOW DEMO", "Where is DEMO.INI?" )
  Local cMenu2    := oIni:Get( "MENU OPTIONS", "BROWSE DEMO", "Did you delete it?" )
  Local nMenuKey1 := oIni:Get( "MENU HOTKEYS", "WINDOW DEMO",15 )
  Local nMenuKey2 := oIni:Get( "MENU HOTKEYS", "BROWSE DEMO",9 )

  // Setup the Pop-up Help Codeblock
  oMenu:CodeBlock := { |nMode, nKey, oMenu, oItem| ;
                       ::MenuHelp( nMode, nKey, oMenu, oItem ) }

  // Menu Window Options
  oMenu:Header       := "CLASSic Demo"
  oMenu:HeadColor    := "gr+/r"
  oMenu:Footer       := "Main Menu using oMENU.PRG"

  // Menu Options
  oMenu:Wrap       := .t.
  oMenu:MsgLine    := maxrow() - 1
  oMenu:ClsMsgLine := .t.
  oMenu:MsgCenter  := .t.

  // Add prompt
  oMenu:AddNewItem( cMenu1, nMenuKey1, ;
                    "A demo of the window class!",;
                    {|oMenu, oItem| Window():Demo() },;
                    "gr+/gb,n/w,,r+/n,w/b","n/w" ) : ;
                    Cargo := "Just Kidding! I Didn't make any help for oWIN"
  oMenu:AddText( "" )
  oMenu:AddNewItem( cMenu2, nMenuKey2, ;
                    "This option will run the browse demo!",;
                    {|oMenu, oItem| Browse():Demo() }, ;
                    ,"W+/gb" ): ;
                    Cargo := "Just Kidding! I Didn't make any help for oBROWSE"
  oMenu:AddText( "" )

  oMenu:AddNewItem( "Disabled Item", 10 ):Enabled := .f. // Disabled Item
  oMenu:AddText( "~" ) // Draw Line
  oMenu:AddNewItem( "Exit", 2, ;
                    "Exit this demo! OH NO!",,"r/gb, w+*/r,, gr+/n,w/b","GR+/R" )
  oMenu:AddText( "~" ) // Draw Line
  oMenu:AddText( "Press F1 for Help" )

  oMenu:Move(,19) // Move to column 19

  oBack:Header := "CLASSic DEMO PROGRAM"
  oBack:Footer := "No Functions or Procedures in this program!"
  oBack:Desktop( "CLASSic *** ", "b+/b")
  oBack:Open()

  nChoice := oMenu:MenuTo()
  oBack:Close()

Return( Self )

Method MenuHelp( nMode, oMenu, oItem, nKey )
  Local oHelp

  If nMode == pMENUKEY .and. nKey == K_F1
    If Full( oItem:Cargo )
      oHelp := oWin():New( oItem:Cargo )
      oHelp:Header := "Help For: " + oItem:Text
      oHelp:cHeaderColor := "gr+/r"
      oHelp:Footer := "Press any key"
      oHelp:Move( oItem:Row, oItem:Col + oMenu:Width )
      oHelp:Open()
      inkey( 0 )
      oHelp:Close()
    else
      oHelp := oWin():New( "NO HELP AVAILIABLE!")
      oHelp:Header := "Help For: " + oItem:Text
      oHelp:cHeaderColor := "gr+/r"
      oHelp:Footer := "Press any key"
      oHelp:Move( oItem:Row, oItem:Col + oMenu:Width )
      oHelp:Open()
      inkey( 0 )
      oHelp:Close()
    Endif
  Endif
Return( Self )
