// oMENU.CH
// Use with oMENU.PRG & oITEM.PRG

// oMENU Sends 4 parameters to you codeblock.
// 1. The Mode ( 0 - 4 )
// 2. The Menu object
// 3. The current Item object             ( if applicable )
// 4. The Key about to processed by oMENU ( if applicable )
// Your codeblock can return a different key for oMenu to process when
// the mode is set to 2.

// Here are the 5 possible Modes:
#Define pMENUSTART 0              // Before OMENU starts
#Define pGOTFOCUS  1              // An Item has got focus
#Define pMENUKEY   2              // A key has been pressed
#Define pLOSTFOCUS 3              // An Item has lost focus
#Define pMENUEND   4              // Before OMENU Exits

#TRANSLATE :Prompt <cString> [HotKey <nKey>]                            ;
                             [Message <cMsg> [, <cMsgColor>]]       ;
                             [EVAL <bBlock>]                            ;
                             [Color <cColor>]                           ;
        => :AddNewItem( <cString>, <nKey>, <cMsg>, <bBlock>, <cColor>,  ;
                        <cMsgColor> )

#TRANSLATE :Message <cString> [Line <nLine>]  ;
        => :AddItem( <cString>[, <nLine> ])

#TRANSLATE :Message <cString> [Line <nLine>]  ;
        => :AddItem( <cString>[, <nLine> ])

#TRANSLATE := Menu [Header <cHead>[, <cHeadColor>]];
                   [Footer <cFoot>[, <cFootColor>]] ;
                   [At [<nTop>], [<nLeft>], [<nBottom>], [<nRight>]] ;
                   [Color <cColor>] ;
        => := oMenu():New( <nTop>, <nLeft>, <nBottom>, <nRight>, <cColor>, ;
                           <cHead>, <cFoot>, <cHeadColor>, <cFootColor> )
