***********************************************************************
*                                                                     *
*   Author:  John F. Kaster                                           *
*   Date:    3/1/89                                                   *
*   Notes:                                                            *
*                                                                     *
*   These routines make use of ACHOICE() from EXTEND.LIB.  Therefore, *
*   extend.lib must be linked in with them in order for them to work. *
*                                                                     *
***********************************************************************


************************************************************************
*                                                                      *
* Checklist( <array>, <top>, <left>, <bottom>, <right> [, <skip array> *
*            [, <markat> ]] )                                          *
*   Calls ACHOICE to put  marks on array elements                     *
*   returns the last key pressed.                                      *
*   Array must be character array with at least leading space          *
*   available in the character string for inserting/deleting          *
*                                                                      *
************************************************************************

function checklist
parameter arr2chk, l1, c1, l2, c2, skiparr, markat
private skiptype, curel, keyp
skiptype = type( 'm->skiparr' )
if m->skiptype # 'A'
  skiparr = .t.
endif

if type( 'm->markat' ) # 'N'
  markat = 1
endif

curel = 1
keyp  = 0
do while m->curel # 0 .and. m->keyp # 13 .and. m->keyp # 27

  curel = achoice( m->l1, m->c1, m->l2, m->c2,;
                   arr2chk, skiparr, 'chklist', m->curel)
  keyp = lastkey()

  ** Move down from tag if spacebar was used
  if m->keyp == 32 
    if kbdstat( 2 )  && Left shift key pressed
      curel = if( m->curel > 1, m->curel - 1, m->curel )
      if m->skiptype == 'A'
        if ! skiparr[ m->curel ]
          curel = m->curel + 1
        endif
      endif
    else
      curel = if( m->curel < len( m->arr2chk ), m->curel + 1, m->curel )
      if m->skiptype == 'A'
        if ! skiparr[ m->curel ]
          curel = m->curel - 1
        endif
      endif
    endif
  endif

enddo
return m->keyp

****************************************************************
*                                                              *
* chklist is a function called from ACHOICE that enables       *
* the user to  an array element by pressing the space bar.    *
* if the user presses the <space bar> again, the  is removed. *
* ALT-T tags all, ALT-U untags all (right now).                *
*                                                              *
****************************************************************

function chklist
*         Status message   current element  relative position
parameter status, curel, relpos
private   keypress, retval, i
keypress = lastkey()
retval  = 2

do case
case m->status = 1 && Cursor past top of list
  keyboard chr(30) && ^PgDn
case m->status = 2 && Cursor past end of list
  keyboard chr(31) && ^PgUp
case m->status = 3 && Keyboard exception
  do case
  case m->keypress = 19 && Left arrow
    keyboard chr(5) && Up arrow
  case m->keypress = 4  && Right arrow
    keyboard chr(24) && Down arrow
  case m->keypress = 1  && Home key
    keyboard chr(31) && ^PgUp
  case m->keypress = 6  && End key
    keyboard chr(30) && ^PgDn
  case m->keypress = 13
    retval = 1
  case m->keypress = 27  && Escape
    retval = 0
  case m->keypress = 32
    if if( m->skiptype # 'A', .t., skiparr[ m->curel ] )
      arr2chk[ m->curel ] = stuff( arr2chk[ m->curel ], m->markat, 1, ;
                            iif('' $ arr2chk[ m->curel ],' ','') )
    endif
    retval = 1
  case m->keypress = 276  && Alt-T
    for i = 1 to len( arr2chk )
      if if( m->skiptype # 'A', .t., skiparr[ m->i ] )
        arr2chk[ m->i ] = stuff( arr2chk[ m->i ], m->markat, 1, '')
      endif
    next
    retval = 1    
  case m->keypress = 278 && Alt-U
    for i = 1 to len( arr2chk )
      if if( m->skiptype # 'A', .t., skiparr[ m->i ] )
        arr2chk[ m->i ] = stuff( arr2chk[ m->i ], m->markat, 1, ' ')
      endif
    next
    retval = 1
  other
****  Add message routine here! ***************************
*    mess ('[Enter] accepts current changes,;[Space] toggles ,;  move;[Esc] aborts changes', 'Invalid Key!' )
  endc
endc
keyp = m->keypress
return m->retval
