/***
*   Modified Frmrun.prg ( Clipper 5.0 REPORT FORM runtime system ).
*   Original Copyright (c) 1990 Nantucket Corp.  All rights reserved.
*   Modified by Jo W. French dba Practical Computing 09-28-1991.
*
*   08/20/91 Check for invalid Right Margin. If bad, ignore.
*   08/20/91 Cleanup aPageHeader for next report run.
*   08/20/91 Print Group Headers when SUMMARY report.
*
*   08/20/91 SEE NOTES at EOF for 2 Patches to FRMBACK.PRG.
*
*   09/05/91 Changed Line 478 to center heading.
*   09/28/91 Initialized nMaxLinesAvail in __ReportForm
*   07/08/92 Deleted XM functions.
*                    REPORT LAYOUT
*       |<                  Physical Page Width                 >|
*       |      |<             Report Page Width (RL)            >|
*       | Set  |Report|                                   |Report|
*       |Margin| Left |<        Data  Area Width         >| Right|
*       |      |Margin|           nDataWidth              |Margin|
*       | nLeftMargin |    (See #define NO_PAGE_ONE_LINE) |      |
*       |      |      | Page #|<   HEADING 1 ;   >|       |      |
*       |      |      |   15  |<   HEADING 2     >| 15    |      |
*       |      |      |       |    nHEADINGWidth          |      |
*       |      |      |       |  or, if won't fit:        |      |
*       |      |      | Page #|<      HEADING 1 ;        >|      |
*       |      |      |   15  |<      HEADING 2          >|      |
*       |      |      | Date                              |      |
*       |      |      |<         Report Header 1         >|      |
*       |      |      |<         Report Header 2         >|      |
*       |      |      | Blank                             |      |
*       |      |      | Column || Column ||   Column      |      |
*       |      |      | Heading|| Heading||   Heading     |      |
*       |      |      | Blank                             |      |
*       |      |      | Blank  (See #define STD_HEADER    |      |
*       |      |      | Record Header (Group, SubGroup)   |      |
*       |      |      | Record Data (Wrapped, Parsed)     |      |
*       |      |      | Record Footer (SubTotal, etc.)    |      |
*       |      |      |        etc.                       |      |
*
*  Notes: If TO FILE is specified, the TO FILE name is compared to
*         ALTFILE and EXTRAFILE.
*         If FILE TO name is unique, an EXTRAFILE will be opened and closed.
*         If FILE TO name == ALTFILE and ALTFILE is open, it will be appended
*            to and left open.
*         If FILE TO name == ALTFILE and ALTFILE is not open, ALTFILE will
*            be overwritten and closed.
*         If FILE TO name == EXTRAFILE and EXTRAFILE is _OPEN_OR_CLOSED_,
*            it will be opened, appended to, and CLOSED.
*
*   Compile: /n/w/m
*/
 
 
#include "frmdef.ch"
#include "error.ch"
 
#define PAGE_ONE_LINE   // Comment out to remove 1st Page top blank line.
#define STOPPIT         // Comment out to prevent Escaping from report.
#define SHORT_RL        // Comment out to force Column Headings + 3 lines.
#define PLAIN_FF        // Comment out to have NO form feeds in PLAIN report.
#define FILE_FF         // Comment out to have NO form feeds in FILE report.
 
STATIC aReportData, nLinesLeft, aReportTotals
STATIC aGroupTitles, lFirstPass, lFormFeeds, nMaxLinesAvail
STATIC lHasTotals, nDataWidth, nLeftMargin, nColumns, nGroups, lToFile
 
FUNCTION __ReportForm( cFRMName, lPrinter, cAltFile, lNoConsole, bFor, ;
                      bWhile, nNext, nRecord, lRest, lPlain, cHEADING, ;
                      lBEject, lSummary )
 
  LOCAL lPrintOn, lConsoleOn           // Status of PRINTER and CONSOLE
  LOCAL cExtraFile, lExtraState := .F. // Status of EXTRA
  LOCAL nCol, nGroup
  LOCAL xBreakVal, lBroke := .F.
  LOCAL err, nSetMargin, nLine, nRepWide := 0
  lHasTotals := lToFile := .F.
 
  // Resolve parameters
  IF cFRMName == NIL
    err           := ErrorNew()
    err:severity  := 2
    err:genCode   := EG_ARG
    err:subSystem := "FRMLBL"
    Eval(ErrorBlock(), err)
  ELSE
    IF AT( ".", cFRMName ) == 0
      cFRMName := TRIM( cFRMName ) + ".FRM"
    ENDIF
  ENDIF
 
  cHEADING := IF( cHEADING == NIL, "", cHEADING )
 
  // Set output devices
  lPrintOn   := IF(lPrinter, SET( _SET_PRINTER, lPrinter ), SET( _SET_PRINTER) )
  lConsoleOn := IF(lNoConsole, SET( _SET_CONSOLE, .F.), SET( _SET_CONSOLE) )
 
  lFormFeeds := IF(lPrinter, .T., .F.)
 
  IF !Empty(cAltFile)       // To file
    cAltFile := UPPER(cAltFile)
    lToFile     := .T.
    IF cAltFile == UPPER(SET(_SET_ALTFILE)) .and. SET(_SET_ALTERNATE)
      // If an AltFile was open, append to it.
      SET(_SET_ALTFILE, cAltFile, .T. )
    ELSE
      // Note: Anomaly SET(_SET_EXTRA) always returns NIL.
      cExtraFile := UPPER(SET(_SET_EXTRAFILE))
      IF cAltFile == cExtraFile
        // If an ExtraFile existed, append to it.
        SET(_SET_EXTRAFILE, cAltFile, .T.)
      ELSE
        SET(_SET_EXTRAFILE, cAltFile, .F.)
      ENDIF
      SET(_SET_EXTRA, .T.)
      lExtraState := .F.
    ENDIF
  ENDIF
 
  BEGIN SEQUENCE
 
    aReportData    := __FrmLoad( cFRMName )   // Load the frm into an array
 
    // Modify aReportData based on the report parameters
    aReportData[ RP_SUMMARY ] := IF( lSummary, .T., aReportData[ RP_SUMMARY ] )
    aReportData[ RP_BEJECT  ] := IF( lBEject , .F., aReportData[ RP_BEJECT  ] )
    // Parse cHEADING and store in aReportData[ RP_HEADING ].
    aReportData[ RP_HEADING ] := STRTRAN(cHEADING,";",CHR(13)+CHR(10))
 
    IF lPlain                // Set plain report flag
      aReportData[ RP_PLAIN ] := .T.
      cHEADING                := ""
 
#ifndef PLAIN_FF
      lFormFeeds              := .F.
#endif
 
    ENDIF
 
    // Subtract 1 from RL spacing (for convenience).
    aReportData[ RP_SPACING ] := IF(aReportData[ RP_SPACING ] > 0, ;
                                    aReportData[ RP_SPACING ] - 1, 0)
    // Set variables.
    nSetMargin     := SET( _SET_MARGIN, 0 )
 
    nLeftMargin    := aReportData[ RP_LMARGIN ] + nSetMargin
 
    nDataWidth     := aReportData[ RP_WIDTH] - aReportData[ RP_LMARGIN ] - ;
                                               aReportData[ RP_RMARGIN ]
 
    lFirstPass     := .T.           // Set the first pass flag
    nLinesLeft     := aReportData[ RP_LINES ]
    nMaxLinesAvail := aReportData[ RP_LINES ]
    nColumns       := LEN(aReportData[RP_COLUMNS])
    nGroups        := LEN(aReportData[RP_GROUPS])
 
 
    // Initialize aReportTotals to track both group and report totals, then
    // set the column total elements to 0 if they are to be totaled, otherwise
    // leave them NIL
 
    aReportTotals := ARRAY( nGroups + 1, nColumns )
 
    // Set aReportTotals to 0, determine if there are totals in report.
    FOR nCol := 1 TO nColumns
 
      nRepWide += ( aReportData[RP_COLUMNS,nCol,RC_WIDTH] + 1 )
 
#ifdef SHORT_RL
      // Minimize RL Column Header.
      FOR nline := LEN(aReportData[RP_COLUMNS,nCol,RC_HEADER]) TO 1 STEP -1
        IF !EMPTY(aReportData[RP_COLUMNS,nCol,RC_HEADER,nline])
          EXIT
        ELSE
           ASIZE(aReportData[RP_COLUMNS,nCol,RC_HEADER], ;
                 LEN(aReportData[RP_COLUMNS,nCol,RC_HEADER]) - 1)
        ENDIF
      NEXT
#endif
 
      IF aReportData[RP_COLUMNS,nCol,RC_TOTAL]
        lHasTotals := .T.
        FOR nGroup := 1 TO LEN(aReportTotals)
          aReportTotals[nGroup,nCol] := 0
        NEXT
      ENDIF
    NEXT
 
    nRepWide --
 
    /* Check for bad right margin setting.*/
    IF nDataWidth < nRepWide
      nDataWidth += aReportData[RP_RMARGIN]     // Add Back Right Margin
    ENDIF
 
    // Initialize aGroupTitles as an array
    aGroupTitles := ARRAY( nGroups )
 
    // Check for "before report" eject.
    IF aReportData[ RP_BEJECT ]
      EjectPage()
    ENDIF
 
    // Generate and print the initial report header.
    NewPage(.F.)
 
    // Execute the actual report based on matching records
    DBEval( { || ExecuteReport() }, bFor, bWhile, nNext, nRecord, lRest )
 
    // End of Report Processing; however, if lHasTotals.
 
    IF lHasTotals
      TotalsHeader(.T.)
    ENDIF
 
 
    // Check for "after report" eject.
    IF aReportData[ RP_AEJECT ]
      EjectPage()
    ENDIF
 
 
  RECOVER USING xBreakVal
 
    lBroke := .T.
 
  END  // Sequence
 
  // clean up
  SET( _SET_PRINTER, lPrintOn   )     // Set the printer back to prior state
  SET( _SET_CONSOLE, lConsoleOn )     // Set the console back to prior state
  SET( _SET_MARGIN,  nSetMargin )     // Set the margin  back to prior state
 
  IF lToFile                // To file
    IF (cAltFile == UPPER(SET(_SET_ALTFILE)) .and. SET(_SET_ALTERNATE)) .or. ;
                                                          lExtraState
      * Do Nothing
    ELSE
      SET( _SET_EXTRA, .F. )
      SET( _SET_EXTRAFILE, cExtraFile, .T.)
    ENDIF
  ENDIF
 
  // Recover the space
  aReportData    := NIL
  aReportTotals  := NIL
  aGroupTitles   := NIL
  lFirstPass     := NIL
  nLinesLeft     := NIL
  lFormFeeds     := NIL
  nMaxLinesAvail := NIL
  lHasTotals     := NIL
  nDataWidth     := NIL
  nLeftMargin    := NIL
  nColumns       := NIL
  nGroups        := NIL
  lToFile        := NIL
  NewPage(.T.)               // Sets aPageHeader and nPageNumber to NIL
 
  IF lBroke
    // keep the break value going
    BREAK xBreakVal
  END
 
RETURN NIL
 
/***
*   ExecuteReport() --> NIL
*   Executed by DBEVAL() for each record that matches record scope
*/
STATIC FUNCTION ExecuteReport
  LOCAL aRecordToPrint := {}           // Current record to print
  LOCAL nCol                           // Counter for the column work
  LOCAL nGroup                         // Counter for the group work
  LOCAL lGroupChanged  := .F.          // Has any group changed?
  LOCAL nMaxLines                      // Number of lines needed by record
  LOCAL nLine                          // Counter for each record line
  LOCAL cLine                          // Current line of text for parsing
  LOCAL cAdjLine                       // Used for parsing semi-colons
  LOCAL lGroupOneChange                // Used for Group 1 eject
  LOCAL nHdrLength
 
#ifdef STOPPIT
  IF Inkey() == 27
    BREAK
  ENDIF
#endif
 
  // Create / Print totals to date.
  IF (!lFirstPass .and. lHasTotals)
    TotalsHeader(.F.)
  ENDIF
 
  // Add to aRecordToPrint in the event that the group has changed and
  // new group headers need to be generated
 
  // Cycle through the groups
 
  IF nGroups > 0
    lGroupOneChange := (MakeAStr(EVAL(aReportData[RP_GROUPS, 1, RG_EXP]),;
           aReportData[RP_GROUPS, 1, RG_TYPE]) != aGroupTitles[1])
 
    IF aReportData[RP_GROUPS,1 ,RG_AEJECT] .and. lGroupOneChange .and. ;
                               !lHasTotals .and. !lFirstPass
      NewPage(.F.)
 
    ENDIF
 
  ENDIF
 
  FOR nGroup := 1 TO nGroups
    // If group 1 or group 2 have changed
    IF lGroupOneChange .or. ;
         MakeAStr(EVAL(aReportData[RP_GROUPS,nGroup,RG_EXP]),;
         aReportData[RP_GROUPS,nGroup,RG_TYPE]) != aGroupTitles[nGroup]
 
      AADD( aRecordToPrint, "" )   // The blank line
 
      AADD( aRecordToPrint, IF(nGroup==1,"** ","* ") +;
            aReportData[RP_GROUPS,nGroup,RG_HEADER] + " " +;
            MakeAStr(EVAL(aReportData[RP_GROUPS,nGroup,RG_EXP]), ;
            aReportData[RP_GROUPS,nGroup,RG_TYPE]) )
    ENDIF
  NEXT
 
  nHdrLength := LEN(aRecordToPrint)
 
  // Only run through the record detail if this is NOT a summary report
  IF !aReportData[ RP_SUMMARY ]
    // Determine the max number of lines needed by each expression
    nMaxLines := 1
    FOR nCol := 1 TO nColumns
      IF aReportData[RP_COLUMNS,nCol,RC_TYPE] $ "CM"
        IF aReportData[RP_COLUMNS,nCol,RC_TYPE] == "C"
          cAdjLine := STRTRAN(EVAL(aReportData[RP_COLUMNS,nCol,RC_EXP]), ;
                              ";", CHR(13)+CHR(10))
        ELSE
          cAdjLine := EVAL(aReportData[RP_COLUMNS,nCol,RC_EXP])
        ENDIF
        nMaxLines := MAX(MLCOUNT(cAdjLine, ;
                     aReportData[RP_COLUMNS,nCol,RC_WIDTH]), nMaxLines)
      ENDIF
    NEXT
 
    // Size aRecordToPrint to the maximum number of lines it will need, then
    // fill it with nulls
 
    ASIZE( aRecordToPrint, nHdrLength + nMaxLines)
    AFILL( aRecordToPrint, "" , nHdrLength + 1)
 
    // Load the current record into aRecordToPrint
    FOR nCol := 1 TO nColumns
      FOR nLine := 1 TO nMaxLines
        // Check to see if it's a memo or character
        IF aReportData[RP_COLUMNS,nCol,RC_TYPE] $ "CM"
          IF aReportData[RP_COLUMNS,nCol,RC_TYPE] == "C"
            cAdjLine := STRTRAN(EVAL(aReportData[RP_COLUMNS,nCol,RC_EXP]), ;
                             ";", CHR(13)+CHR(10))
          ELSE
            cAdjLine := EVAL(aReportData[RP_COLUMNS,nCol,RC_EXP])
          ENDIF
          // Load the current line of the current column into cLine
          cLine := MEMOLINE(TRIM(cAdjLine),;
                   aReportData[RP_COLUMNS,nCol,RC_WIDTH], nLine )
          cLine := PADR( cLine, aReportData[RP_COLUMNS,nCol,RC_WIDTH] )
        ELSE
          IF nLine == 1
            cLine := TRANSFORM(EVAL(aReportData[RP_COLUMNS,nCol,RC_EXP]),;
                     aReportData[RP_COLUMNS,nCol,RC_PICT])
            cLine := PADR( cLine, aReportData[RP_COLUMNS,nCol,RC_WIDTH] )
          ELSE
            cLine := SPACE( aReportData[RP_COLUMNS,nCol,RC_WIDTH])
          ENDIF
        ENDIF
        // Add it to the existing report line
        aRecordToPrint[ nHdrLength + nLine ] += cLine
        IF nCol < nColumns
          aRecordToPrint[ nHdrLength + nLine ] += " "
        ENDIF
      NEXT
    NEXT
 
  ENDIF    // Was this a summary report?
 
  // Remove blank line if first line after report header.
  IF nHdrLength > 0 .and. (lFirstPass .or. nLinesLeft < LEN(aRecordToPrint))
    ADEL(aRecordToPrint, 1)
    ASIZE(aRecordToPrint, LEN(aRecordToPrint) - 1)
  ENDIF
 
  // Print aRecordToPrint
  PrintArray(aRecordToPrint, .F.)
 
  // Tack on the spacing for double/triple/etc.
  nLine := aReportData[ RP_SPACING ]
  WHILE (nLine > 0 .and. nLinesLeft > 0)
    PrintIt()
    nLine --
    nLinesLeft --
  END
 
 
  lFirstPass := .F.
 
  // Reset the group expressions in aGroupTitles
  FOR nGroup := 1 TO nGroups
    aGroupTitles[nGroup] := MakeAStr(EVAL(aReportData[RP_GROUPS,nGroup,RG_EXP]),;
                            aReportData[RP_GROUPS,nGroup,RG_TYPE])
  NEXT
 
  // Add to the group totals
  FOR nCol := 1 TO nColumns
    // If this column should be totaled, do it
    IF aReportData[RP_COLUMNS,nCol,RC_TOTAL]
      // Cycle through the groups
      FOR nGroup := 1 TO LEN( aReportTotals )
        aReportTotals[nGroup ,nCol] += ;
          EVAL( aReportData[RP_COLUMNS,nCol,RC_EXP] )
      NEXT
    ENDIF
  NEXT
 
RETURN NIL
 
 
/***
*   NewPage(lDestruct) --> NIL
*    Create Page Header. Eject and Send to print. Reset nLinesLeft.
*/
STATIC FUNCTION NewPage(lDestruct)
  STATIC aPageHeader, nPageNumber
  LOCAL nLinesInHeader := 0
  LOCAL nCol, nLine, nMaxColLength, nGroup, nHEADINGWidth
 
  IF lDestruct
    aPageHeader := NIL
    nPageNumber := NIL
    RETURN NIL                  // NOTE
  ENDIF
 
  IF !aReportData[ RP_PLAIN ]   // If not a plain paper report
    nLinesLeft := nMaxLinesAvail := aReportData[RP_LINES]
  ELSE
 
#ifdef PLAIN_FF
    nLinesLeft := nMaxLinesAvail := aReportData[RP_LINES]
#else
    nLinesLeft := nMaxLinesAvail := 1000
#endif
 
  ENDIF
 
  IF aPageHeader == NIL
    aPageHeader := {}
    nPageNumber := 1
 
    // Create the header and drop it into aPageHeader
    // Start with the command line HEADING.
 
    IF !aReportData[ RP_PLAIN ]         // If not a plain paper report
 
      // ****   Command line HEADING ****
      nHEADINGWidth := IF(nDataWidth > 30, nDataWidth - 30, ;
                       IF(nDataWidth > 15, nDataWidth - 15, 0 ))
 
      IF aReportData[RP_HEADING] == ""    // the heading
        AADD( aPageHeader, SPACE(15) )    // Reserved for Page No.
      ELSE
        nLinesInHeader := MLCOUNT( aReportData[RP_HEADING], nHEADINGWidth )
        FOR nLine := 1 TO nLinesInHeader
          AADD( aPageHeader, SPACE(15) + ;
          PADC(TRIM(MEMOLINE(aReportData[RP_HEADING],nHEADINGWidth,nLine)),;
               nHEADINGWidth))
        NEXT
      ENDIF
      AADD( aPageHeader, DTOC(DATE()) )
 
    ENDIF
 
    // ****   Report Form Header from the FRM ****
    FOR nLine := 1 TO LEN( aReportData[RP_HEADER] )
      IF !EMPTY(aReportData[RP_HEADER, nLine])
        AADD( aPageHeader, PADC(TRIM(aReportData[ RP_HEADER, nLine ]), nDataWidth) )
      ENDIF
    NEXT
 
    // S87 compat.
    AADD( aPageHeader, "" )
 
    // ****   Report Form Column Headings from the FRM ****
 
    nLinesInHeader := LEN( aPageHeader )
    // Determine the longest column header
    nMaxColLength := 0
    FOR nCol := 1 TO nColumns
        nMaxColLength := MAX( LEN(aReportData[RP_COLUMNS,nCol,RC_HEADER]), ;
                              nMaxColLength )
    NEXT
    FOR nCol := 1 TO nColumns
      ASIZE( aReportData[RP_COLUMNS,nCol,RC_HEADER], nMaxColLength )
    NEXT
 
    FOR nLine := 1 TO nMaxColLength
      AADD( aPageHeader, "" )
    NEXT
 
    FOR nCol := 1 TO nColumns       // Cycle through the columns
 
      FOR nLine := 1 TO nMaxColLength
 
        IF aReportData[RP_COLUMNS,nCol,RC_HEADER,nLine] == NIL
           aPageHeader[ nLinesInHeader + nLine ] += ;
                   SPACE( aReportData[RP_COLUMNS,nCol,RC_WIDTH] )
        ELSE
          IF aReportData[RP_COLUMNS,nCol,RC_TYPE] == "N"
            aPageHeader[ nLinesInHeader + nLine ] += ;
              PADL(aReportData[RP_COLUMNS,nCol,RC_HEADER,nLine],;
                          aReportData[RP_COLUMNS,nCol,RC_WIDTH])
          ELSE
            aPageHeader[ nLinesInHeader + nLine ] += ;
              PADR(aReportData[RP_COLUMNS,nCol,RC_HEADER,nLine],;
                          aReportData[RP_COLUMNS,nCol,RC_WIDTH])
          ENDIF
        ENDIF
        IF nCol < nColumns
          aPageHeader[ nLinesInHeader + nLine ] += " "
        ENDIF
      NEXT
    NEXT
 
    // Insert a blank line after heading, if column headings.
 
    IF nMaxColLength > 0
      AADD( aPageHeader, "" )
    ENDIF
 
#ifdef PAGE_ONE_LINE
    QOUT()
    nLinesLeft --
    nMaxLinesAvail --
#endif
 
  ENDIF
  // aPageHeader has been initialized. Stuff page number if not PLAIN
 
  IF !aReportData[ RP_PLAIN ]
    aPageHeader[ 1 ] := STUFF( aPageHeader[ 1 ], 1, 14, ;
                                   "Page No." + STR(nPageNumber,6) )
  ENDIF
 
  IF !lFirstPass
    EjectPage()
  ENDIF
 
  // Send it for printing ( nLinesLeft decremented ).
  PrintArray(aPageHeader, .F.)
 
  // Set nMaxLinesAvail
  nMaxLinesAvail := nLinesLeft
 
  // Increment the page number
  nPageNumber++
 
RETURN NIL
 
 
/***
*   TotalsHeader( <lEndOfReport> ) --> NIL
*    Create and Print Record Header when Totals are included.
*/
STATIC FUNCTION TotalsHeader(lEndOfReport)
  Local nCol, nGroup, lAnySubTotals, lGroupOneChange
  Local aTotalsHeader := {}
  // Determine if any of the groups have changed.  If so, add the appropriate
  // line to aTotalsHeader for totaling out the previous records
  IF !lFirstPass         // Don't bother
    IF nGroups > 0
      lGroupOneChange := (MakeAStr(EVAL(aReportData[RP_GROUPS, 1, RG_EXP]),;
         aReportData[RP_GROUPS, 1, RG_TYPE]) != aGroupTitles[1])
    ENDIF
 
    // Make a pass through all the groups
    FOR nGroup :=  nGroups TO 1 STEP -1
      // make sure group has subtotals
      lAnySubTotals := .F.
      FOR nCol := 1 TO nColumns
        IF aReportData[RP_COLUMNS,nCol,RC_TOTAL]
          lAnySubTotals := .T.
          EXIT           // NOTE
        ENDIF
      NEXT
 
      IF !lAnySubTotals
        LOOP            // NOTE
      ENDIF
      // **** SubTotals to Date ****
      // If group 1 or group 2 has changed since the last record
      IF (lGroupOneChange .or. ;
          MakeAStr(EVAL(aReportData[RP_GROUPS, nGroup, RG_EXP]), ;
          aReportData[RP_GROUPS,nGroup,RG_TYPE]) != aGroupTitles[nGroup])
 
        AADD( aTotalsHeader, IF(nGroup==1,"** Subtotal **","* Subsubtotal *") )
        AADD( aTotalsHeader, "" )
 
        // Cycle through the columns, adding either the group
        // amount from aReportTotals or spaces wide enough for
        // the non-totaled columns
        FOR nCol := 1 TO nColumns
          IF aReportData[RP_COLUMNS,nCol,RC_TOTAL]
 
            aTotalsHeader[ LEN(aTotalsHeader) ] += ;
              TRANSFORM(aReportTotals[nGroup+1,nCol], ;
              aReportData[RP_COLUMNS,nCol,RC_PICT])
 
            // Zero out the group totals column from aReportTotals
            aReportTotals[nGroup+1,nCol] := 0
          ELSE
            aTotalsHeader[ LEN(aTotalsHeader) ] += ;
            SPACE(aReportData[RP_COLUMNS,nCol,RC_WIDTH])
          ENDIF
          IF nCol < nColumns
            aTotalsHeader[ LEN(aTotalsHeader) ] += " "
          ENDIF
        NEXT
      ENDIF
    NEXT
 
  ENDIF     // !lFirstPass
 
  IF lEndOfReport   // Add Grand Total to aTotalsHeader.
    AADD( aTotalsHeader, "*** Total ***" )
    AADD( aTotalsHeader, "" )
 
    FOR nCol := 1 TO nColumns
      IF aReportData[RP_COLUMNS,nCol,RC_TOTAL]
        aTotalsHeader[ LEN(aTotalsHeader) ] += ;
          TRANSFORM(aReportTotals[ 1, nCol], ;
          aReportData[RP_COLUMNS,nCol,RC_PICT])
      ELSE
        aTotalsHeader[ LEN(aTotalsHeader) ] += ;
        SPACE(aReportData[RP_COLUMNS,nCol,RC_WIDTH])
      ENDIF
      IF nCol < nColumns
        aTotalsHeader[ LEN(aTotalsHeader) ] += " "
      ENDIF
    NEXT
  ENDIF
 
  PrintArray( aTotalsHeader, .T. )
 
RETURN NIL
 
/***
*   PrintArray( <array>, <lIsTotHdg> ) --> NIL
*    Send the input array to the output device.
*/
STATIC FUNCTION PrintArray(aArray, lIsTotHdg)
  Local nLine, nPtr := 0
 
  IF LEN( aArray ) > 0
 
 
    // Send aArray to the output device, resetting nLinesLeft
    IF !lIsTotHdg
      IF LEN( aArray ) <= nLinesLeft
        AEVAL( aArray, ;
             { | PrintLine | PrintIt( SPACE(nLeftMargin) + PrintLine ) } )
        nLinesLeft -= LEN( aArray )
 
      ELSEIF LEN( aArray ) <= nMaxLinesAvail
        NewPage(.F.)                // Recursive
        AEVAL( aArray, ;
             { | PrintLine | PrintIt( SPACE(nLeftMargin) + PrintLine ) } )
        nLinesLeft -= LEN( aArray )
 
      ELSE
        // Big Momma
        IF nLinesLeft == 0
          NewPage(.F.)             // Recursive
        ENDIF
        nLine := 1
        WHILE nLine < LEN( aArray )
          PrintIt( SPACE(nLeftMargin) + aArray[nLine] )
          nLine++
          nLinesLeft--
          IF nLinesLeft == 0
            NewPage(.F.)             // Recursive
          ENDIF
        END
      ENDIF
 
    ELSE
 
      FOR nLine := 1 TO LEN(aArray) STEP 2
        IF nLinesLeft < 2
          NewPage(.F.)               // Recursive
        ENDIF
        AEVAL( aArray, ;
           { | PrintLine | PrintIt( SPACE(nLeftMargin) + PrintLine ) }, ;
            nLine, 2)
        nLinesLeft -= 2
      NEXT
      IF (nGroups > 0 .and. ;
          aReportData[RP_GROUPS,1 ,RG_AEJECT] .and. LEN(aArray)/2 = nGroups)
        NewPage(.F.)                 // Recursive
      ENDIF
 
    ENDIF
  ENDIF
 
RETURN NIL
 
/***
*   MakeStr( <exp>, <cType> ) --> value
*    Convert a value of any data type into string to add to the group header 
*/
STATIC FUNCTION MakeAStr( uVar, cType )
  LOCAL cString
  DO CASE
    CASE UPPER(cType) == "D"
      cString := DTOC( uVar )
 
    CASE UPPER(cType) == "L"
      cString := IF( uVar, "T", "F" )
 
    CASE UPPER(cType) == "N"
      cString := STR( uVar )
 
    CASE UPPER(cType) == "C"
      cString := uVar
 
    OTHERWISE
      cString := "INVALID EXPRESSION"
  ENDCASE
RETURN( cString )
 
/***
*   PrintIt( <cString> ) --> NIL
*   Print a string, THEN send a CRLF
*/
STATIC FUNCTION PrintIt( cString )
  IF cString == NIL
    cString := ""
  ELSE
    // prevents output of trailing space, also prevents wrapping of some
    // lines when sent to screen or 80-column printer. Comment out this
    // line for complete Summer 87 compatibility.
    // cString := Trim( cString )
  ENDIF
 
  QQOUT( cString )
  QOUT()
 
RETURN NIL
 
/***
*   EjectPage() --> NIL
*   Eject a page if the form feed option is set
*   Send CHR(12) if TO FILE and FILE_FF is defined.
*/
STATIC FUNCTION EjectPage
  IF lFormFeeds
    EJECT
 
#ifdef FILE_FF
  ELSEIF lToFile
    QQOUT(CHR(12))
#endif
 
  ENDIF
RETURN NIL
 
/* NOTES re' FRMBACK.PRG
*  1) Change line 154:
*     FROM:    paths := ListAsArray( s )
*     TO  :    paths := ListAsArray( s, ";" )
*
*  2) Replace the ListAsArray Function with the following:
*
* FUNCTION ListAsArray(cList, cDelim, nWide)
*   LOCAL aArray := {}, lNum
*   cDelim := IF(VALTYPE(cDelim) == 'C', cDelim, ";")
*   cList  := TRIM( STRTRAN(cList, cdelim, chr(13)+chr(10)) )
*   nWide  := IF( (lNum := (VALTYPE(nWide) == 'N' .and. nWide > 0 )), ;
*                        nWide, LEN(cList) )
*   aArray := ARRAY(MLCOUNT(cList,nWide,1,.T.))
*   AEVAL(aArray, {|a,e| aArray[e] := IF(lNum, MEMOLINE(cList,nWide,e,1,.T.),;
*                                     TRIM(MEMOLINE(cList,nWide,e,1,.T.)))})
* RETURN aArray
*/
 
