/********************************************************************/
/*     Function: BoxShade                                           */
/*     Writer: Kraig Krist/TBCS                                     */
/*             PO Box 711                                           */
/*             Annandale, VA 22003-0711                             */
/*     Date: August 18, 1993                                        */
/*     Description: Examine area around box to determine best       */
/*                  shading.  Then actually shade the area.         */
/********************************************************************/
/*                    ----- Modification Log -----                  */
/*     When:                                                        */
/*     Why:                                                         */
/********************************************************************/
/*                                                                  */
/*     Called By:                                                   */
/*       Passed in from ________: Top, Left, Bottom and Right       */
/*       Returns to ________: nothing                               */
/*                                                                  */
/*     Calls: nothing                                               */
/*                                                                  */
/********************************************************************/

#include <stdio.h>
#include <dos.h>
#include <color.h>
#include "c:\clipper5\include\extend.h"
void MoveCursor (unsigned int nRow, unsigned int nCol);
/********************************************************************/
/*     Function BoxShade                                            */
/********************************************************************/
CLIPPER BoxShade()
{
/********************************************************************/
/* Declare variables.                                               */
/********************************************************************/
  union REGS vr;
  unsigned int aFCCheck[8], aBCCheck[8];
  unsigned int nTop, nLeft, nBottom, nRight;
  unsigned int nRow, nCol, nX, nShadeAreaBlank;
  unsigned int nHorizontal, nVertical;
  unsigned int nBColor, nFColor, nVChar, nShadeAttribute;
  unsigned int sBColor, sFColor, nShadeDefault;

/********************************************************************/
/* Initialize variables.                                            */
/********************************************************************/
  nTop = nLeft = nBottom = nRight = nRow = nCol = nX = 0;
  nShadeAreaBlank = 0;
  nHorizontal = nVertical = nBColor = nFColor = nVChar = 0;
  nShadeAttribute = sBColor = sFColor = nShadeDefault = 0;

    for (nX = 0; nX < 8; nX++)
    {
      aFCCheck[nX] = aBCCheck[nX] = 0;
    }  /* end for */

/********************************************************************/
/* Get parameters passed from calling Clipper Program.              */
/********************************************************************/

  if (PCOUNT == 4 && ISNUM(1) && ISNUM(2) && ISNUM(3) && ISNUM(4))
  {
    nTop = _parni(1);
    nLeft = _parni(2);
    nBottom = _parni(3);
    nRight = _parni(4);

/********************************************************************/
/* Remember the Clipper screen coordinates are -1 from those in C   */
/* For example Top Left in Clipper is 0,0 in C the same position    */
/* is 1,1                                                           */
/********************************************************************/

/*    nTop++; only applies if using settextposition to move cursor
    nLeft++;  commented out as I'm now using int86
    nBottom++;
    nRight++;   */

/********************************************************************/
/* Examine horizontal area to be shaded.                            */
/********************************************************************/

    nRow = nBottom + 1;
    nHorizontal = (nRight - nLeft) + 1;

    for (nCol = (nLeft + 1); nCol <= (nRight + 1); nCol++)
    {
      MoveCursor(nRow,nCol);
      vr.h.ah = 8;
      vr.h.bh = 0;
      int86(BIOS_VIDEO,&vr,&vr);

      if (vr.h.al == 32)
      { nShadeAreaBlank++; }

      va.attrib  = vr.h.ah;

      nFColor = ((va.bits.f1) + (va.bits.f2 * 2) + (va.bits.f3 * 4));
      nBColor = ((va.bits.b1 * 16) + (va.bits.b2 * 32) +
        (va.bits.b3 * 64));
      sBColor = nBColor / 16;
      sFColor = nFColor;
      aFCCheck[sFColor]++;
      aBCCheck[sBColor]++;
    }   /* end for */

/********************************************************************/
/* Examine vertical area to be shaded.                              */
/********************************************************************/

    nCol = nRight + 1;
    nVertical = (nBottom - nTop);

/********************************************************************/
/* Notice the following test is only < as the (nBottom+1),          */
/* (nRight+1) area was already examined during horizontal testing.  */
/********************************************************************/

    for (nRow = (nTop + 1); nRow < (nBottom + 1); nRow++)
    {
      MoveCursor(nRow,nCol);
      vr.h.ah = 8;
      vr.h.bh = 0;
      int86(BIOS_VIDEO,&vr,&vr);

      if (vr.h.al == 32)
      { nShadeAreaBlank++; }

      va.attrib  = vr.h.ah;

      nFColor = ((va.bits.f1) + (va.bits.f2 * 2) + (va.bits.f3 * 4));
      nBColor = ((va.bits.b1 * 16) + (va.bits.b2 * 32) +
        (va.bits.b3 * 64));
      sBColor = nBColor / 16;
      sFColor = nFColor;
      aFCCheck[sFColor]++;
      aBCCheck[sBColor]++;
    }  /* end for */

/********************************************************************/
/* Determine the most commonly used Background & Foreground colors. */
/********************************************************************/

    sBColor = sFColor = nBColor = nFColor = 0;

    for (nX = 0; nX < 8; nX++)
    {
      if (aFCCheck[nX] > nFColor)
      {
        sFColor = nX;
        nFColor = aFCCheck[nX];
      }  /* end if */
      if (aBCCheck[nX] > nBColor)
      {
        sBColor = nX;
        nBColor = aBCCheck[nX];
      }  /* end if */

    }  /* end for */

/********************************************************************/
/* Determine the Shade Character.                                   */
/********************************************************************/

    if (nShadeAreaBlank == (nHorizontal + nVertical))
      { nShadeDefault = 1; }
    else
      { nShadeDefault = 0; }

/********************************************************************/
/* Determine if Background is Black.                                */
/********************************************************************/

    nBColor = sBColor * 16;

    if (nBColor == BCBlack)
/********************************************************************/
/* Default to Intense Black on Gray shade.                          */
/********************************************************************/
      { nShadeAttribute = FCIntensityOn + FCBlinkOff + FCBlack +
        BCGray;}
    else   /* Background Color is not Black */
/********************************************************************/
/* Determine if the Foreground and Background colors are the same.  */
/********************************************************************/
    {
      if (sFColor == sBColor)
      {
        if (sBColor == FCGray)
        { nShadeAttribute = FCGray + BCBlack; }
        else
        {
          if (nShadeDefault)
/********************************************************************/
/* Use Intense Black on the Background of the Current Foreground    */
/* color (that will now being used as the Background Color).        */
/********************************************************************/
          { nShadeAttribute = FCIntensityOn + FCBlack + nBColor; }
          else
          { nShadeAttribute = sFColor + BCBlack; }
        } /* end if */
      } /* end if */
      else   /* Foreground and Background colors are not the same */
      {
/********************************************************************/
/* Determine if the Foreground Colors were Intense.                 */
/********************************************************************/
      if (sFColor == FCBlack)
      { nShadeAttribute = FCIntensityOff + FCGray + BCBlack; }
      else
      {
        if (((nHorizontal+nVertical)-nShadeAreaBlank) <=
          nShadeAreaBlank)
        { nShadeAttribute = FCIntensityOff + sFColor + BCBlack; }
        else
          { nShadeAttribute = FCIntensityOff + sFColor + nBColor; }
        }   /* end if */
      } /* end if */
    } /* end if */

/********************************************************************/
/* Now that the area has been analyzed and appropriate shade        */
/* attributes have been established, actually paint the shadow.     */
/********************************************************************/

/********************************************************************/
/* Paint the Horizontal Shade area.                                 */
/********************************************************************/

    nRow = nBottom + 1;
    for (nCol = (nLeft + 1); nCol <= (nRight + 1); nCol++)
    {
      MoveCursor(nRow,nCol);

      if (nShadeDefault == 0)
      {
        vr.h.ah = 8;
        vr.h.bh = 0;
        int86(BIOS_VIDEO,&vr,&vr);
        nVChar = vr.h.al;
      }  /* end if */

/********************************************************************/
/* Rewrite the current value with the established shade attribute.  */
/********************************************************************/

      vr.h.ah = 9;

      if (nShadeDefault)
      { vr.h.al = 177; }
      else
      { vr.h.al = nVChar; }

      vr.h.bh = 0;
      vr.h.bl = nShadeAttribute;
      vr.x.cx = 1;
      int86(BIOS_VIDEO,&vr,&vr);
    }  /* end for */

/********************************************************************/
/* Paint the Vertical Shade area.                                   */
/********************************************************************/

    nCol = nRight + 1;

/********************************************************************/
/* Notice the following test is only < as the (nBottom+1),          */
/* (nRight+1) area was already shaded during the horizontal shading.*/
/********************************************************************/

    for (nRow = (nTop + 1); nRow < (nBottom + 1); nRow++)
    {
      MoveCursor(nRow,nCol);
      if (nShadeDefault == 0)
      {
        vr.h.ah = 8;
        vr.h.bh = 0;
        int86(BIOS_VIDEO,&vr,&vr);
        nVChar = vr.h.al;
      }  /* endif */

/********************************************************************/
/* Rewrite the current value with the established shade attribute.  */
/********************************************************************/

      vr.h.ah = 9;

      if (nShadeDefault)
      { vr.h.al = 177; }
      else
      { vr.h.al = nVChar; }

      vr.h.bh = 0;
      vr.h.bl = nShadeAttribute;
      vr.x.cx = 1;
      int86(BIOS_VIDEO,&vr,&vr);

    }  /* end for */

  }  /* end if */

  _retni(0);
}
/********************************************************************/
/* Must use the int86 to move the cursor as MS C Version 5.x will   */
/* not position the cursor past row 25 in text mode.                */
/********************************************************************/
void MoveCursor (unsigned int nRow, unsigned int nCol)
{
  union REGS vc;
  vc.h.ah = 2;
  vc.h.bh = 0;
  vc.h.dh = nRow;
  vc.h.dl = nCol;
  int86(BIOS_VIDEO,&vc,&vc);
}
