/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/

#include "beckner.inc"

////////////////
////////////////
//
// Purpose:
//    Sample use of mAPR()
//
// Syntax:
//    C> APR
//
// Formal Arguments: (0)
//
// Files:
//    none
//
// Description:
//    Interactive program demonstrating mAPR() function.
//
// See Also:
//    mAPR()
//    AMORTIZE
//
// Category:
//    Sample Program
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

FUNCTION Main()
   LOCAL nAF := 0.00, nPmt := 0.00, nNumPmts := 3, GetList := {}
   CLS
   @ 5, 1 SAY "Amount Financed ......" GET nAF PICTURE "999999.99"
   @ 6, 1 SAY "Payment .............." GET nPmt PICTURE "999999.99"
   @ 7, 1 SAY "# payments ..........." GET nNumPmts PICTURE "99"
   READ
   @ 10, 1 SAY "APR is "
   DevOut(sMake(mAPR(nAF, nPmt, nNumPmts)))
   DevOut("%")
   QUIT
ENDFUNCTION
