#INCLUDE "CLASSY2.CH"
"#INCLUDE "FUNCKY.CH"
#INCLUDE "FLEXFILE.CH"

REQUEST DBFNTX
REQUEST FLEXFILE


FUNCTION Main()

	RDDSETDEFAULT( "FLEXFILE" )
	ALTD()

	CntTypes()                           // Look at different counter objects.
	CntUses()                            // Look at counter object uses.

RETURN (NIL)

//  Function Ŀ
//          Name: CntUses()             Docs: Chris Pels                     
//   Description: Demo of counter object uses.                               
//        Author: Chris Pels                                                 
//  Date created: 04-15-94              Date updated: 04-15-94              
//  Time created: 02:38:49pm            Time updated: 02:38:49pm            
//     Copyright: Greenwich Bay Technologies, Inc.                           
// Ĵ
//     Arguments: None                                                       
//  Return Value: (NIL)                                                    
//      See Also:                                                            
// 
FUNCTION CntUses()

	LOCAL ;
		nCount

	CntRepo()                            // Make a counter "repository".
	MakeCnt()                            // Make/store each type of counter.

	FOR nCount := 1 TO 5
		AddEmp()                           // Simulate adding new employee.
	NEXT

RETURN (NIL)

//  Function Ŀ
//          Name: CntTypes()            Docs: Chris Pels                     
//   Description: Demo of different counter types.                           
//        Author: Chris Pels                                                 
//  Date created: 04-15-94              Date updated: 04-15-94              
//  Time created: 02:38:25pm            Time updated: 02:38:25pm            
//     Copyright: Greenwich Bay Technologies, Inc.                           
// Ĵ
//     Arguments: None                                                       
//  Return Value: (NIL)                                                    
//      See Also:                                                            
// 
FUNCTION CntTypes()

	LOCAL ;
		nCount,;
		uValue,;
		oCntnum,;
		oCntASC,;
		oCntalpha


	// NUMERIC COUNTER OBJECT

	uValue := 0
	oCntnum := CntNumeric():New()
	uValue := oCntnum:Get()
	oCntnum:Inc()
	uValue := oCntnum:Get()
	oCntnum:Inc()
	uValue := oCntnum:Get()
	oCntnum:Dec(2)
	uValue := oCntnum:Get()

	// COUNTER USING FULL ASCII CHARACTER SET

	uValue := ""
	oCntASC := CntFullASC():New()
	uValue := oCntASC:Get()
	FOR nCount := 1 TO 255
		oCntASC:Inc()
		uValue := oCntASC:Get()
	NEXT

	// COUNTER USING ALPHA & NUMERIC CHARACTERS

	uValue := ""
	oCntalpha := CntAlphaNum():New()
	uValue := oCntalpha:Get()
	FOR nCount := 1 TO 36
		oCntalpha:Inc()
		uValue := oCntalpha:Get()
	NEXT

RETURN (NIL)

//  Function Ŀ
//          Name: CntRepo()             Docs: Chris Pels                     
//   Description: Make a counter repository.                                 
//        Author: Chris Pels                                                 
//  Date created: 04-15-94              Date updated: 04-15-94              
//  Time created: 02:35:39pm            Time updated: 02:35:39pm            
//     Copyright: Greenwich Bay Technologies, Inc.                           
// Ĵ
//     Arguments: None                                                       
//  Return Value: (NIL)                                                    
//      See Also:                                                            
// 
FUNCTION CntRepo()

	DBCREATE(;
		"COUNTERS",;                       // Create a counters DBF/DBV pair.
		{;
		{ "KEY","C",8,0 },;                // Unique identifier for object in DBV.
		{ "OBJECT","M",10,0 };             // Pointer into DBV.
		},;
		"FLEXFILE";                        // Flexfile RDD.
		)

	USE COUNTERS VIA "FLEXFILE"          // Open the table.
	INDEX ON COUNTERS->KEY TO KEYS


RETURN (NIL)

//  Function Ŀ
//          Name: MakeCnt()             Docs: Chris Pels                     
//   Description: Make serveral counters.                                    
//        Author: Chris Pels                                                 
//  Date created: 04-15-94              Date updated: 04-15-94              
//  Time created: 02:34:23pm            Time updated: 02:34:23pm            
//     Copyright: Greenwich Bay Technologies, Inc.                           
// Ĵ
//     Arguments: None                                                       
//  Return Value: (NIL)                                                    
//      See Also:                                                            
// 
FUNCTION MakeCnt()

	Local ;
		oCntnum := CntNumeric():New(),;
		oCntalpha := CntAlphaNum():New()

	// COUNTER FOR INVOICE NUMBER.
	oCntnum:Assign(1)
	WriteCnt( KeyCounter():New( "INVOICE", oCntnum ) )

	// COUNTER FOR UNIQUE EMPLOYEE ID.
	oCntalpha:Reset()
	WriteCnt( KeyCounter():New( "EMPID", oCntalpha ) )

	// COUNTER FOR UNIQUE CUSTOMER ID.
	oCntalpha:Reset()
	WriteCnt( KeyCounter():New( "CUSTID", oCntalpha ) )

	// COUNTER FOR UNIQUE ORDER ID.
	oCntalpha:Reset()
	WriteCnt( KeyCounter():New( "ORDERID", oCntalpha ) )

RETURN (NIL)

//  Method Ŀ
//          Name: WriteCnt()                                                 
//   Description: Store a counter to disk.                                   
//        Author: Chris Pels                                                 
//  Date created: 04-15-94              Date updated: 04-15-94              
//  Time created: 02:28:48pm            Time updated: 02:28:48pm            
//     Copyright: Greenwich Bay Technologies, Inc.                           
// Ĵ
//     Arguments: None                                                       
//  Return Value: (NIL)                                                      
//      See Also:                                                            
// 
FUNCTION WriteCnt( oCounter )

	COUNTERS->( DBSEEK( oCounter:cKey) )
	IF FOUND()
		COUNTERS->OBJECT := oCounter
	ELSE
		COUNTERS->( DBAPPEND() )
		COUNTERS->KEY := oCounter:cKey
		COUNTERS->OBJECT := oCounter
	ENDIF

RETURN (.T.)

//  Function Ŀ
//          Name: ReadCnt()              Docs: Chris Pels                     
//   Description: Retrieve a counter from disk.                              
//        Author: Chris Pels                                                 
//  Date created: 04-15-94              Date updated: 04-15-94              
//  Time created: 02:32:03pm            Time updated: 02:32:03pm            
//     Copyright: Greenwich Bay Technologies, Inc.                           
// Ĵ
//     Arguments: cKey                                                       
//  Return Value: (NIL)                                                    
//      See Also:                                                            
// 
FUNCTION ReadCnt( cKey )

	COUNTERS->( DBSEEK(cKey) )
	IF FOUND()
		RETU( COUNTERS->OBJECT )
	ENDIF

RETURN (NIL)

